/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt.jna;

import java.util.logging.Level;
import org.glassfish.virtualization.libvirt.LibVirtError;
import org.glassfish.virtualization.libvirt.jna.ConnectionPointer;
import org.glassfish.virtualization.libvirt.jna.Domain;
import org.glassfish.virtualization.libvirt.jna.DomainPointer;
import org.glassfish.virtualization.libvirt.jna.LibVirtLibrary;
import org.glassfish.virtualization.libvirt.jna.LibVirtObject;
import org.glassfish.virtualization.libvirt.jna.StoragePool;
import org.glassfish.virtualization.libvirt.jna.StoragePoolPointer;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.util.RuntimeContext;

public class Connect
extends LibVirtObject {
    final ConnectionPointer handle;

    public Connect(String uri) throws VirtException {
        this.handle = libvirt.virConnectOpen(uri);
        LibVirtError.processError(libvirt);
    }

    public int numOfDomains() throws VirtException {
        int returnValue = libvirt.virConnectNumOfDomains(this.handle);
        this.checkForError();
        return returnValue;
    }

    public int[] listDomains() throws VirtException {
        int maxids = this.numOfDomains();
        int[] ids = new int[maxids];
        if (maxids > 0) {
            libvirt.virConnectListDomains(this.handle, ids, maxids);
            this.checkForError();
        }
        return ids;
    }

    public int numOfDefinedDomains() throws VirtException {
        int returnValue = libvirt.virConnectNumOfDefinedDomains(this.handle);
        this.checkForError();
        return returnValue;
    }

    public String[] listDefinedDomains() throws VirtException {
        int maxnames = this.numOfDefinedDomains();
        String[] names = new String[maxnames];
        if (maxnames > 0) {
            libvirt.virConnectListDefinedDomains(this.handle, names, maxnames);
            this.checkForError();
        }
        return names;
    }

    public Domain domainLookupByID(int id) throws VirtException {
        DomainPointer ptr = libvirt.virDomainLookupByID(this.handle, id);
        this.checkForError();
        return ptr == null ? null : new Domain(ptr);
    }

    public Domain domainLookupByName(String name) throws VirtException {
        DomainPointer ptr = libvirt.virDomainLookupByName(this.handle, name);
        this.checkForError();
        return ptr == null ? null : new Domain(ptr);
    }

    public int numOfStoragePools() throws VirtException {
        int returnValue = libvirt.virConnectNumOfStoragePools(this.handle);
        this.checkForError();
        return returnValue;
    }

    public String[] listStoragePools() throws VirtException {
        int num = this.numOfStoragePools();
        String[] returnValue = new String[num];
        libvirt.virConnectListStoragePools(this.handle, returnValue, num);
        this.checkForError();
        return returnValue;
    }

    public StoragePool storagePoolLookupByName(String name) throws VirtException {
        StoragePoolPointer ptr = libvirt.virStoragePoolLookupByName(this.handle, name);
        this.checkForError();
        return ptr == null ? null : new StoragePool(ptr);
    }

    public StoragePool storagePoolCreateXML(String xmlDesc, int flags) throws VirtException {
        StoragePoolPointer ptr = libvirt.virStoragePoolCreateXML(this.handle, xmlDesc, flags);
        this.checkForError();
        return ptr == null ? null : new StoragePool(ptr);
    }

    public Domain domainDefineXML(String xmlDesc) throws VirtException {
        Object returnValue = null;
        DomainPointer ptr = libvirt.virDomainDefineXML(this.handle, xmlDesc);
        this.checkForError();
        return ptr == null ? null : new Domain(ptr);
    }

    static {
        LibVirtLibrary.INSTANCE.virInitialize();
        try {
            LibVirtError.processError(LibVirtLibrary.INSTANCE);
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Error initializing libvirt library", e);
        }
    }
}

