/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt.jna;

import org.glassfish.virtualization.libvirt.jna.LibVirtObject;
import org.glassfish.virtualization.libvirt.jna.StoragePoolPointer;
import org.glassfish.virtualization.libvirt.jna.StorageVol;
import org.glassfish.virtualization.libvirt.jna.StorageVolPointer;
import org.glassfish.virtualization.spi.VirtException;

public class StoragePool
extends LibVirtObject {
    final StoragePoolPointer handle;

    public StoragePool(StoragePoolPointer handle) {
        this.handle = handle;
    }

    public int numOfVolumes() throws VirtException {
        int returnValue = libvirt.virStoragePoolNumOfVolumes(this.handle);
        this.checkForError();
        return returnValue;
    }

    public String[] listVolumes() throws VirtException {
        int num = this.numOfVolumes();
        String[] returnValue = new String[num];
        libvirt.virStoragePoolListVolumes(this.handle, returnValue, num);
        this.checkForError();
        return returnValue;
    }

    public StorageVol storageVolLookupByName(String name) throws VirtException {
        StorageVolPointer ptr = libvirt.virStorageVolLookupByName(this.handle, name);
        this.checkForError();
        return new StorageVol(ptr);
    }

    public StorageVol storageVolCreateXML(String xmlDesc, int flags) throws VirtException {
        StorageVolPointer ptr = libvirt.virStorageVolCreateXML(this.handle, xmlDesc, flags);
        this.checkForError();
        return new StorageVol(ptr);
    }

    public void delete(int flags) throws VirtException {
        libvirt.virStoragePoolDelete(this.handle, flags);
        this.checkForError();
    }
}

