/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.virtualization.config.Emulator;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="add-virtualization")
@Supplemental(on=Supplemental.Timing.Before, value="create-vm-cluster")
@Scoped(value=PerLookup.class)
public class AddVirtualizationCapabilities
implements AdminCommand {
    @Param
    String type;
    @Param
    String emulator;
    @Inject
    ServerEnvironment env;
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    final Logger logger = LogDomains.getLogger(AddVirtualizationCapabilities.class, (String)"javax.enterprise.system.core");

    public void execute(AdminCommandContext context) {
        URL temp;
        final Virtualizations virtualizations = (Virtualizations)this.domain.getExtensionByType(Virtualizations.class);
        if (virtualizations != null) {
            for (Virtualization v : virtualizations.getVirtualizations()) {
                if (!v.getName().equals(this.type)) continue;
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.WARNING);
                context.getActionReport().setActionDescription("Configuration already present in the domain.xml");
                return;
            }
        }
        String virtType = this.type;
        final long now = System.currentTimeMillis();
        File f = new File(this.env.getConfigDirPath(), virtType);
        if (!(f = new File(f, "virtualizations.xml")).exists()) {
            this.logger.info("Cannot find virtualizations.xml at " + f.getAbsolutePath());
            temp = this.getClass().getClassLoader().getResource(virtType + "/virtualizations.xml");
        } else {
            try {
                temp = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.logger.log(Level.SEVERE, "Cannot get valid URL for virtualization.xml template", e);
                return;
            }
        }
        final URL url = temp;
        if (url != null) {
            ConfigParser configParser = new ConfigParser(this.habitat);
            new Populator(){

                public void run(ConfigParser parser) {
                    if (url != null) {
                        try {
                            DomDocument document = parser.parse(url, new DomDocument(AddVirtualizationCapabilities.this.habitat){

                                public Dom make(Habitat habitat, XMLStreamReader in, Dom parent, ConfigModel model) {
                                    return new GlassFishConfigBean(habitat, (DomDocument)this, (GlassFishConfigBean)parent, model, in);
                                }
                            }, Dom.unwrap((ConfigBeanProxy)AddVirtualizationCapabilities.this.domain));
                            final Virtualizations defaultConfig = (Virtualizations)document.getRoot().createProxy(Virtualizations.class);
                            if (virtualizations == null) {
                                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                                    public Object run(Domain wConfig) throws PropertyVetoException, TransactionFailure {
                                        wConfig.getExtensions().add(defaultConfig);
                                        return null;
                                    }
                                }, (ConfigBeanProxy)AddVirtualizationCapabilities.this.domain);
                            } else {
                                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Virtualizations>(){

                                    public Object run(Virtualizations wVirtualizations) throws PropertyVetoException, TransactionFailure {
                                        for (Virtualization v : defaultConfig.getVirtualizations()) {
                                            wVirtualizations.getVirtualizations().add(v);
                                        }
                                        return null;
                                    }
                                }, (ConfigBeanProxy)virtualizations);
                            }
                        }
                        catch (Exception e) {
                            AddVirtualizationCapabilities.this.logger.log(Level.SEVERE, "Exception while parsing virtualizations.xml", e);
                        }
                        AddVirtualizationCapabilities.this.logger.fine("time to parse virtualizations.xml : " + String.valueOf(System.currentTimeMillis() - now));
                    }
                }
            }.run(configParser);
        } else {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Virtualizations>(){

                    public Object run(Virtualizations param) throws PropertyVetoException, TransactionFailure {
                        Virtualization virt = (Virtualization)param.createChild(Virtualization.class);
                        virt.setName(AddVirtualizationCapabilities.this.type);
                        if (AddVirtualizationCapabilities.this.emulator != null) {
                            Emulator emulatorConfig = param.emulatorByName(AddVirtualizationCapabilities.this.emulator);
                            if (emulatorConfig == null) {
                                throw new TransactionFailure("Cannot find emulator " + AddVirtualizationCapabilities.this.emulator);
                            }
                            virt.setDefaultEmulator(emulatorConfig);
                        }
                        param.getVirtualizations().add(virt);
                        return virt;
                    }
                }, (ConfigBeanProxy)virtualizations);
            }
            catch (TransactionFailure e) {
                context.getActionReport().failure(RuntimeContext.logger, e.getMessage(), (Throwable)e);
            }
        }
        File destDir = new File(this.env.getConfigDirPath(), virtType);
        if (!destDir.exists() && !destDir.mkdirs()) {
            this.logger.severe("Cannot create " + destDir);
        }
    }
}

