/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.virtualization.ShellExecutor;
import org.glassfish.virtualization.config.GroupConfig;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class GroupMembersPopulator
implements Startup,
PostConstruct,
GroupManagement,
ConfigListener {
    @Inject
    ShellExecutor shell;
    @Inject(optional=true)
    Virtualizations virtualizations = null;
    @Inject
    OsInterface os;
    @Inject
    Habitat habitat;
    private final Map<String, PhysicalGroup> groups = new HashMap<String, PhysicalGroup>();

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    @Override
    public Iterator<PhysicalGroup> iterator() {
        return this.groups.values().iterator();
    }

    @Override
    public PhysicalGroup byName(String groupName) {
        return this.groups.get(groupName);
    }

    public void postConstruct() {
        if (this.virtualizations == null) {
            return;
        }
        for (GroupConfig groupConfig : this.virtualizations.getGroupConfigs()) {
            try {
                PhysicalGroup group = this.processGroupConfig(groupConfig);
                System.out.println("I have a group " + group.getName());
                for (Machine machine : group.machines()) {
                    System.out.println("LibVirtMachine  " + machine.getName() + " is at " + machine.getIpAddress() + " state is " + (Object)((Object)machine.getState()));
                    if (!machine.getState().equals((Object)Machine.State.READY)) continue;
                    try {
                        System.out.println(machine.toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhysicalGroup processGroupConfig(GroupConfig groupConfig) {
        PhysicalGroup group = (PhysicalGroup)this.habitat.getComponent(PhysicalGroup.class, groupConfig.getVirtualization().getName());
        group.setConfig(groupConfig);
        GroupMembersPopulator groupMembersPopulator = this;
        synchronized (groupMembersPopulator) {
            this.groups.put(groupConfig.getName(), group);
        }
        return group;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])propertyChangeEvents, (Changed)new Changed(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                block6: {
                    try {
                        GroupConfig groupConfig = (GroupConfig)GroupConfig.class.cast(t);
                        if (type.equals((Object)Changed.TYPE.ADD)) {
                            GroupMembersPopulator.this.processGroupConfig(groupConfig);
                        }
                        if (!type.equals((Object)Changed.TYPE.REMOVE)) break block6;
                        1 var5_6 = this;
                        synchronized (var5_6) {
                            GroupMembersPopulator.this.groups.remove(groupConfig.getName());
                        }
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                }
                return null;
            }
        }, (Logger)Logger.getAnonymousLogger());
    }
}

