/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.virtualization.ParameterResolver;
import org.glassfish.virtualization.ShellCommand;
import org.glassfish.virtualization.config.Action;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class ShellExecutor {
    final boolean debug = false;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Virtualizations virtualizations;
    @Inject
    ServerEnvironment env;
    final Logger logger = RuntimeContext.logger;

    public String output(Process pr) throws IOException {
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        StringBuffer sb = new StringBuffer();
        String line = "";
        while ((line = buf.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public String error(Process pr) throws IOException {
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
        StringBuffer sb = new StringBuffer();
        String line = "";
        while ((line = buf.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public Process execute(File dir, ShellCommand command) throws IOException, InterruptedException {
        String commandString = command.build();
        return this.executeAndWait(dir, commandString);
    }

    public Process executeAndWait(File dir, String command) throws IOException, InterruptedException {
        Process pr = this.execute(dir, command);
        pr.waitFor();
        return pr;
    }

    public Process execute(File dir, String command) throws IOException, InterruptedException {
        Runtime run = Runtime.getRuntime();
        dir = dir == null ? new File(System.getProperty("user.dir")) : dir;
        return run.exec(dir.getAbsolutePath() + "/" + command);
    }

    public void executionActions(ActionReport report, String provider, Action.Timing timing, ParameterResolver resolver) {
        for (Virtualization virtualization : this.virtualizations.getVirtualizations()) {
            if (!provider.equals(virtualization.getName())) continue;
            for (Action action : virtualization.getActions()) {
                File script;
                if (!action.getTiming().equals(timing.name())) continue;
                String path = virtualization.getScriptsLocation();
                if (path == null) {
                    path = new File(this.env.getConfigDirPath(), provider).getAbsolutePath();
                }
                if (!(script = new File(action.getCommand())).exists() && !(script = new File(path, action.getCommand())).exists()) {
                    this.logger.log(Level.SEVERE, "Cannot find script " + action.getCommand() + " in " + path);
                    return;
                }
                ShellCommand command = new ShellCommand(path, action, resolver);
                this.logger.info("Running " + command.build());
                try {
                    Process result = this.execute(null, command);
                    if (result.exitValue() == 0) continue;
                    this.logger.info("Command failed with exit code " + result.exitValue());
                    String output = this.output(result);
                    if (output == null) continue;
                    this.logger.severe(output);
                }
                catch (InterruptedException e) {
                    report.failure(this.logger, "Interrupted exception while running " + command.build(), (Throwable)e);
                }
                catch (IOException ioe) {
                    report.failure(this.logger, "IOException while running " + command.build(), (Throwable)ioe);
                }
            }
        }
    }

    public boolean executeAdminCommand(ActionReport report, String commandName, String operand, String ... parameters) {
        ParameterMap params = new ParameterMap();
        if (operand != null) {
            params.add((Object)"DEFAULT", (Object)operand);
        }
        int i = 0;
        while (i < parameters.length) {
            String key = parameters[i++];
            String value = null;
            if (i < parameters.length) {
                value = parameters[i++];
            }
            params.add((Object)key, value);
        }
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(commandName, report);
        inv.parameters(params);
        inv.execute();
        return report.getActionExitCode() == ActionReport.ExitCode.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installScript(File destDir, String provider, String scriptName) throws IOException {
        URL url = this.getClass().getClassLoader().getResource(provider + "/" + scriptName);
        if (url == null) {
            return;
        }
        InputStream is = null;
        OutputStream os = null;
        try {
            is = url.openStream();
            File outDir = new File(destDir, provider);
            os = new BufferedOutputStream(new FileOutputStream(new File(outDir, scriptName)));
            byte[] mem = new byte[2048];
            int read = 0;
            do {
                if ((read = is.read(mem)) <= 0) continue;
                os.write(mem, 0, read);
            } while (read > 0);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Cannot close input file", e);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Cannot close output file", e);
                }
            }
        }
    }
}

