/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.runtime.VirtualCluster;
import org.glassfish.virtualization.runtime.VirtualClusters;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.glassfish.virtualization.virtmgt.GroupAccess;
import org.glassfish.virtualization.virtmgt.GroupsAccess;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-virtual-cluster")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class CreateVirtualCluster
implements AdminCommand {
    @Param(optional=true)
    String groupNames = null;
    @Param(optional=true)
    String template = null;
    @Param(primary=true)
    String name;
    @Param(optional=true, defaultValue="1")
    String min = "1";
    @Param(optional=true, defaultValue="5")
    String max = "5";
    @Inject
    GroupsAccess groups;
    @Inject
    Virtualizations virts;
    @Inject
    VirtualClusters clusters;
    @Inject
    RuntimeContext rtContext;

    public void execute(AdminCommandContext context) {
        ArrayList<GroupAccess> targetGroups = new ArrayList<GroupAccess>();
        if (this.groupNames == null) {
            for (GroupAccess group : this.groups.groups()) {
                targetGroups.add(group);
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(this.groupNames, ",");
            while (tokenizer.hasMoreElements()) {
                String groupName = tokenizer.nextToken();
                GroupAccess group = this.groups.byName(groupName);
                if (group == null) {
                    context.getActionReport().failure(RuntimeContext.logger, "There are not defined groups named " + groupName);
                    return;
                }
                targetGroups.add(group);
            }
        }
        if (targetGroups.isEmpty()) {
            context.getActionReport().failure(RuntimeContext.logger, "There are not defined groups to deploy to");
            return;
        }
        ActionReport report = context.getActionReport();
        StringBuilder sb = new StringBuilder();
        int minNumber = Integer.parseInt(this.min);
        sb.append("Successfully created ").append(minNumber).append(" virtual machine(s) : ");
        int numberPerGroup = minNumber / targetGroups.size();
        for (GroupAccess targetGroup : targetGroups) {
            Virtualization virt = this.virts.byName(targetGroup.getVirtualizationName());
            if (virt == null) {
                context.getActionReport().failure(RuntimeContext.logger, "Cannot find virtualization configuration " + targetGroup.getVirtualizationName());
                return;
            }
            Template template_ = this.template != null ? virt.templateByName(this.template) : virt.getTemplates().get(0);
            ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
            this.rtContext.executeAdminCommand(report, "create-cluster", this.name, new String[0]);
            if (report.hasFailures()) {
                return;
            }
            VirtualCluster vc = this.clusters.byName(this.name);
            try {
                Iterable<Future<VirtualMachine>> futures = targetGroup.allocate(template_, vc, numberPerGroup);
                for (Future<VirtualMachine> future : futures) {
                    VirtualMachine vm;
                    try {
                        vm = future.get();
                    }
                    catch (Exception e) {
                        context.getActionReport().failure(RuntimeContext.logger, "Failure to allocate virtual machine ", (Throwable)e);
                        return;
                    }
                    vms.add(vm);
                    sb.append(vm.getName()).append("(").append(vm.getAddress()).append(") ");
                }
            }
            catch (VirtException e) {
                this.rtContext.executeAdminCommand(report, "delete-cluster", this.name, new String[0]);
                RuntimeContext.logger.log(Level.SEVERE, e.getMessage(), e);
                context.getActionReport().failure(RuntimeContext.logger, e.getMessage());
                return;
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(sb.toString());
    }
}

