/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.concurrent.Future;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.runtime.VirtualClusters;
import org.glassfish.virtualization.spi.Group;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-vm")
@Scoped(value=PerLookup.class)
public class CreateVirtualMachine
implements AdminCommand {
    @Param(name="template")
    String templateName;
    @Param(name="group", optional=true)
    String groupName = null;
    @Param(name="cluster")
    String clusterName;
    @Inject
    GroupManagement groups;
    @Inject
    VirtualClusters clusters;
    @Inject
    Domain domain;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AdminCommandContext context) {
        Group group = this.groupName == null ? (Group)this.groups.iterator().next() : this.groups.byName(this.groupName);
        Virtualization virt = group.getConfig().getVirtualization();
        Template template = virt.templateByName(this.templateName);
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (template == null) {
            context.getActionReport().failure(RuntimeContext.logger, "Template not registered " + this.templateName);
            return;
        }
        try {
            Iterable<Future<VirtualMachine>> vm = group.allocate(template, this.clusters.byName(this.clusterName), 1);
            for (Future<VirtualMachine> future : vm) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new VirtException(e);
                    return;
                }
            }
        }
        catch (VirtException e) {
            context.getActionReport().failure(RuntimeContext.logger, e.getMessage(), (Throwable)e);
        }
    }
}

