/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-vm")
@Scoped(value=PerLookup.class)
public class DeleteVirtualMachine
implements AdminCommand {
    @Param(primary=true)
    String clusterName;
    @Inject
    GroupManagement groups;
    @Inject
    RuntimeContext rtContext;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        if (cluster == null) {
            context.getActionReport().failure(RuntimeContext.logger, "Cannot find cluster named " + this.clusterName);
            return;
        }
        if (cluster.getServerRef().size() == 0) {
            context.getActionReport().failure(RuntimeContext.logger, "Cluster is empty");
            return;
        }
        this.deleteServerRef(context, (ServerRef)cluster.getServerRef().get(0));
    }

    public void deleteServerRef(AdminCommandContext context, ServerRef serverRef) {
        String instanceName = serverRef.getRef();
        Server instance = this.domain.getServerNamed(instanceName);
        if (instance != null) {
            String nodeName = instance.getNodeRef();
            this.rtContext.executeAdminCommand(context.getActionReport(), "stop-instance", instanceName, "_vmShutdown", "false");
            this.rtContext.executeAdminCommand(context.getActionReport(), "delete-instance", instanceName, new String[0]);
            String vmName = instanceName.substring(instanceName.lastIndexOf("_") + 1, instanceName.length() - "Instance".length());
            for (PhysicalGroup group : this.groups) {
                for (Machine machine : group.machines()) {
                    try {
                        for (VirtualMachine virtualMachine : machine.getVMs()) {
                            if (!virtualMachine.getName().equals(vmName)) continue;
                            virtualMachine.delete();
                        }
                    }
                    catch (VirtException e) {
                        RuntimeContext.logger.log(Level.WARNING, "Exception while talking to machine " + machine.getName(), e);
                    }
                }
            }
            Node node = this.domain.getNodeNamed(nodeName);
            if (node != null && node.getType().equals("SSH")) {
                this.rtContext.executeAdminCommand(context.getActionReport(), "delete-node-ssh", nodeName, new String[0]);
            }
        }
    }
}

