/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.spi.Group;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="register-virtual-machine")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class RegisterVirtualMachine
implements AdminCommand {
    @Param
    String group;
    @Param
    String machine;
    @Param
    String address;
    @Param
    String sshUser;
    @Param
    String installDir;
    @Param
    String cluster;
    @Param(primary=true)
    String virtualMachine;
    @Param(optional=true, defaultValue="false")
    boolean notssh;
    @Inject
    Virtualizations virts;
    @Inject
    GroupManagement groups;
    @Inject
    RuntimeContext rtContext;
    @Inject
    ExecutorService executorService;
    final ActionReport actionReport;

    public RegisterVirtualMachine(@Inject(name="plain") ActionReport ar) {
        this.actionReport = ar;
    }

    public void execute(AdminCommandContext context) {
        if (this.group == null) {
            context.getActionReport().failure(RuntimeContext.logger, "LibVirtGroup name cannot be null");
            return;
        }
        Group targetGroup = this.groups.byName(this.group);
        if (this.group == null) {
            context.getActionReport().failure(RuntimeContext.logger, "Cannot find group " + this.group);
        }
        try {
            VirtualMachine vm = targetGroup.vmByName(this.virtualMachine);
            if (vm != null) {
                vm.setAddress(this.address);
                ActionReport report = context.getActionReport();
                String vmName = this.group + "_" + this.machine + "_" + this.virtualMachine;
                if (!this.notssh) {
                    this.rtContext.executeAdminCommand(report, "create-node-ssh", vmName, "nodehost", this.address, "sshUser", this.sshUser, "installdir", this.installDir);
                    if (report.hasFailures()) {
                        return;
                    }
                    this.rtContext.executeAdminCommand(report, "create-instance", vmName + "Instance", "node", vmName, "cluster", this.cluster);
                    if (report.hasFailures()) {
                        return;
                    }
                } else {
                    this.rtContext.executeAdminCommand(report, "_create-node-implicit", this.address, "name", vmName, "installdir", this.installDir);
                    if (report.hasFailures()) {
                        return;
                    }
                }
            }
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, e.getMessage(), e);
            context.getActionReport().failure(RuntimeContext.logger, e.getMessage());
        }
    }
}

