/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.os.Disk;
import org.glassfish.virtualization.runtime.VirtualMachineLifecycle;
import org.glassfish.virtualization.spi.Group;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.spi.VirtualMachineInfo;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Supplemental(value="start-instance", on=Supplemental.Timing.Before)
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class SupplementStartInstance
implements AdminCommand {
    @Param(name="instance_name", primary=true)
    String instanceName;
    @Inject
    GroupManagement groups;
    @Inject
    VirtualMachineLifecycle vmLifecycle;
    @Inject
    RuntimeContext rtContext;
    @Inject
    Virtualizations virtualizations;
    @Inject
    Disk custDisk;
    @Inject
    AuthTokenManager authTokenManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        String groupName = this.instanceName.substring(0, this.instanceName.indexOf("_"));
        String machineName = this.instanceName.substring(this.instanceName.indexOf("_") + 1, this.instanceName.lastIndexOf("_"));
        String vmName = this.instanceName.substring(this.instanceName.lastIndexOf("_") + 1, this.instanceName.length() - "Instance".length());
        Group group = this.groups.byName(groupName);
        try {
            VirtualMachine vm = group.vmByName(vmName);
            VirtualMachineInfo vmInfo = vm.getInfo();
            if (Machine.State.RESUMING.equals((Object)vmInfo.getState()) || Machine.State.READY.equals((Object)vmInfo.getState())) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
        }
        catch (VirtException e) {
            RuntimeContext.logger.warning(e.getMessage());
        }
        File machineDisks = RuntimeContext.absolutize(new File(this.virtualizations.getDisksLocation(), group.getName()));
        machineDisks = new File(machineDisks, machineName);
        File custDir = new File(machineDisks, vmName + "cust");
        File custFile = new File(custDir, "customization");
        try {
            if (custFile.exists() && group instanceof PhysicalGroup) {
                Properties customizedProperties = new Properties();
                InputStreamReader fileReader = null;
                try {
                    fileReader = new FileReader(custFile);
                    customizedProperties.load(fileReader);
                }
                finally {
                    fileReader.close();
                }
                customizedProperties.put("AuthToken", this.authTokenManager.createToken());
                customizedProperties.put("AuthToken2", this.authTokenManager.createToken());
                customizedProperties.put("StartToken", this.authTokenManager.createToken());
                OutputStreamWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(new File(custDir, "customization"));
                    customizedProperties.store(fileWriter, "Customization properties for virtual machine" + vmName);
                }
                finally {
                    fileWriter.close();
                }
                File custISOFile = new File(machineDisks, vmName + "cust.iso");
                this.custDisk.createISOFromDirectory(custDir, custISOFile);
                PhysicalGroup physicalGroup = (PhysicalGroup)group;
                Machine machine = physicalGroup.byName(machineName);
                machine.getFileOperations().delete(machine.getConfig().getDisksLocation() + "/" + vmName + "cust.iso");
                machine.getFileOperations().copy(custISOFile, new File(machine.getConfig().getDisksLocation()));
            }
            VirtualMachine vm = group.vmByName(vmName);
            vm.start();
            CountDownLatch latch = this.vmLifecycle.inStartup(vm);
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getActionReport().failure(RuntimeContext.logger, e.getMessage(), (Throwable)e);
            try {
                this.custDisk.umount();
            }
            catch (IOException exe) {
                // empty catch block
            }
            return;
        }
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

