/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import com.sun.enterprise.util.io.FileUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
public interface Template
extends ConfigBeanProxy,
Named {
    public void setName(String var1);

    @Element
    public VirtUser getUser();

    @Create(value="create-template-user", resolver=TemplateResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    public void setUser(VirtUser var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class TemplateAddDecorator
    implements CreationDecorator<Template> {
        @Param
        String location = null;
        @Param
        String xml = null;
        @Param(primary=true)
        String name;
        @Inject
        Virtualizations virt;

        public void decorate(AdminCommandContext context, Template instance) throws TransactionFailure, PropertyVetoException {
            File source;
            instance.setName(this.name);
            File templateLocation = new File(this.virt.getTemplatesLocation());
            if (!templateLocation.exists()) assert (templateLocation.mkdirs());
            if (this.location != null) {
                try {
                    source = new File(this.location);
                    if (!source.isAbsolute()) {
                        source = new File(System.getProperty("user.dir"), this.location);
                    }
                    if (!source.exists()) {
                        context.getActionReport().failure(RuntimeContext.logger, "File not found : " + source.getAbsolutePath());
                        return;
                    }
                    FileUtils.copy((File)source, (File)new File(templateLocation, instance.getName() + ".img"));
                }
                catch (IOException e) {
                    context.getActionReport().failure(RuntimeContext.logger, "Error copying template " + this.location, (Throwable)e);
                }
            }
            if (this.xml != null) {
                try {
                    source = new File(this.xml);
                    if (!source.isAbsolute()) {
                        source = new File(System.getProperty("user.dir"), this.xml);
                    }
                    if (!source.exists()) {
                        context.getActionReport().failure(RuntimeContext.logger, "File not found : " + source.getAbsolutePath());
                        new File(templateLocation, instance.getName() + ".img").delete();
                        throw new TransactionFailure("Cannot find file " + source.getAbsolutePath());
                    }
                    FileUtils.copy((File)source, (File)new File(templateLocation, instance.getName() + ".xml"));
                }
                catch (IOException e) {
                    new File(templateLocation, instance.getName() + ".img").delete();
                    context.getActionReport().failure(RuntimeContext.logger, "Error copying xml " + this.location, (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class TemplateResolver
    implements CrudResolver {
        @Param
        String templateName;
        @Param
        String virtName;
        @Inject
        Virtualizations virts;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            Virtualization virt = this.virts.byName(this.virtName);
            if (virt == null) {
                context.getActionReport().failure(RuntimeContext.logger, "Cannot find virtualization config named " + this.virtName);
                return null;
            }
            Template thisTemplate = virt.templateByName(this.templateName);
            return (T)thisTemplate;
        }
    }
}

