/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.DomainExtension;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.config.support.TypeAndNameResolver;
import org.glassfish.virtualization.config.Emulator;
import org.glassfish.virtualization.config.GroupConfig;
import org.glassfish.virtualization.config.GroupManager;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualization;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Virtualizations
extends DomainExtension {
    @Element(value="virtualization")
    public List<Virtualization> getVirtualizations();

    @Element(value="emulator")
    @Create(value="create-emulator", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-emulator"))
    @Listing(value="list-emulators", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-emulators"))
    @Delete(value="delete-emulator", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.delete-emulator"))
    public List<Emulator> getEmulators();

    @Element(value="group-managers")
    @Create(value="create-group-manager", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-group-manager"))
    @Listing(value="list-group-managers", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-group-managers"))
    @Delete(value="delete-group-manager", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.delete-group-manager"))
    public List<GroupManager> getGroupManagers();

    @Element(value="group-providers")
    @Create(value="create-virt-group", resolver=VirtResolver.class, decorator=GroupDecorator.class, i18n=@I18n(value="org.glassfish.virtualization.create-virt-group"))
    @Listing(value="list-virt-groups", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-virt-groups"))
    @Delete(value="delete-virt-group", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-virt-group"))
    public List<GroupConfig> getGroupConfigs();

    @Attribute(defaultValue="${com.sun.aas.instanceRoot}/virt/disks")
    public String getDisksLocation();

    public void setDisksLocation();

    @Attribute(defaultValue="${com.sun.aas.instanceRoot}/virt/templates")
    public String getTemplatesLocation();

    public void setTemplatesLocation();

    @DuckTyped
    public Virtualization byName(String var1);

    @DuckTyped
    public GroupConfig groupConfigByName(String var1);

    @DuckTyped
    public Emulator emulatorByName(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class GroupDecorator
    implements CreationDecorator<GroupConfig> {
        @Param(name="virtName")
        String virtName;
        @Inject
        Virtualizations virts;

        public void decorate(AdminCommandContext context, GroupConfig instance) throws TransactionFailure, PropertyVetoException {
            VirtUser user = (VirtUser)instance.createChild(VirtUser.class);
            instance.setUser(user);
            Virtualization virt = this.virts.byName(this.virtName);
            if (virt == null) {
                throw new TransactionFailure("Cannot find virtualization configuration for " + this.virtName);
            }
            instance.setVirtualization(virt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class VirtResolver
    implements CrudResolver {
        @Inject
        Domain domain;
        @Inject(optional=true)
        Virtualizations virt = null;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            if (this.virt != null) {
                return (T)this.virt;
            }
            try {
                this.virt = (Virtualizations)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain wDomain) throws PropertyVetoException, TransactionFailure {
                        Virtualizations v = (Virtualizations)wDomain.createChild(Virtualizations.class);
                        wDomain.getExtensions().add(v);
                        return v;
                    }
                }, (ConfigBeanProxy)this.domain);
            }
            catch (TransactionFailure t) {
                throw new RuntimeException(t);
            }
            return (T)this.virt;
        }
    }

    public static class Duck {
        public static Virtualization byName(Virtualizations self, String name) {
            for (Virtualization v : self.getVirtualizations()) {
                if (!v.getName().equals(name)) continue;
                return v;
            }
            return null;
        }

        public static GroupConfig groupConfigByName(Virtualizations self, String name) {
            for (GroupConfig groupConfig : self.getGroupConfigs()) {
                if (!groupConfig.getName().equals(name)) continue;
                return groupConfig;
            }
            return null;
        }

        public static Emulator emulatorByName(Virtualizations self, String name) {
            for (Emulator emulator : self.getEmulators()) {
                if (!emulator.getName().equals(name)) continue;
                return emulator;
            }
            return null;
        }
    }
}

