/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.os;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import org.glassfish.virtualization.ShellExecutor;
import org.glassfish.virtualization.config.GroupConfig;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ubuntu")
public class Ubuntu
implements OsInterface {
    @Inject
    ShellExecutor shell;
    @Inject
    RuntimeContext context;

    @Override
    public void suspend(Machine machine) throws IOException {
        try {
            machine.sleep();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resume(Machine machine) throws IOException {
        try {
            Process result = this.shell.executeAndWait(new File("/"), this.wol() + " " + machine.getConfig().getMacAddress());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, String> populateMacToIpsTable(PhysicalGroup group) {
        GroupConfig groupConfig = group.getConfig();
        String subNet = groupConfig.getSubNet();
        HashMap<String, String> macToIps = new HashMap<String, String>();
        RuntimeContext.logger.info("Populating IP addresses tables, this may take a while...");
        try {
            Process result = this.shell.executeAndWait(new File(this.fpingPath()), "fping -c 1 -g " + subNet);
            if (result.exitValue() == 1) {
                String line;
                result = this.shell.execute(new File(this.arpPath()), this.getArpCommand());
                Thread.sleep(100L);
                LineNumberReader lnReader = new LineNumberReader(new InputStreamReader(result.getInputStream()));
                lnReader.readLine();
                while ((line = lnReader.readLine()) != null) {
                    Thread.sleep(25L);
                    this.scanArpLine(line, macToIps);
                }
                lnReader.close();
                result.destroy();
            } else {
                System.out.println("error : " + this.shell.output(result));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RuntimeContext.logger.info("Finished populating IP addresses");
        return macToIps;
    }

    @Override
    public String macAddressGen() {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("52:54");
            Random random = new Random();
            for (int i = 0; i < 4; ++i) {
                buffer.append(String.format(":%02x", random.nextInt(256)));
            }
            return buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getArpCommand() {
        return "arp -n";
    }

    protected void scanArpLine(String arpLine, Map<String, String> macToIps) {
        Scanner scanner = new Scanner(arpLine);
        String ipAddress = scanner.next();
        String hwType = scanner.next();
        if (hwType.equals("(incomplete)")) {
            return;
        }
        String macAddress = scanner.next();
        macToIps.put(macAddress, ipAddress);
        System.out.println("--->" + ipAddress + " is at " + macAddress);
    }

    protected String fpingPath() {
        return "/usr/bin";
    }

    protected String arpPath() {
        return "/usr/sbin";
    }

    protected String wol() {
        return "/usr/bin/wakeonlan";
    }

    @Override
    public String userId() {
        try {
            Process result = this.shell.executeAndWait(new File("/usr/bin"), "id -u");
            return this.shell.output(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String groupId() {
        try {
            Process result = this.shell.executeAndWait(new File("/usr/bin"), "id -g");
            return this.shell.output(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

