/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.runtime;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.grizzly.config.dom.NetworkListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.virtualization.config.Emulator;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.os.Disk;
import org.glassfish.virtualization.os.FileOperations;
import org.glassfish.virtualization.runtime.LocalUser;
import org.glassfish.virtualization.runtime.VMTemplate;
import org.glassfish.virtualization.runtime.VirtualCluster;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.StoragePool;
import org.glassfish.virtualization.spi.StorageVol;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.util.Host;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalMachine
implements Machine,
FileOperations {
    protected final MachineConfig config;
    protected final PhysicalGroup group;
    protected final Map<String, VMTemplate> installedTemplates = new HashMap<String, VMTemplate>();
    volatile Machine.State state;
    VirtUser myself = null;
    @Inject
    Virtualizations virtualizations;
    @Inject
    Habitat habitat;
    @Inject
    Host host;
    final Injector injector;

    protected LocalMachine(Injector injector, PhysicalGroup group, MachineConfig config) {
        this.group = group;
        this.config = config;
        this.injector = injector;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public MachineConfig getConfig() {
        return this.config;
    }

    @Override
    public String getIpAddress() {
        return "";
    }

    @Override
    public PhysicalGroup getGroup() {
        return this.group;
    }

    public void setState(Machine.State state) {
        this.state = state;
    }

    @Override
    public Machine.State getState() {
        return this.state;
    }

    @Override
    public FileOperations getFileOperations() {
        return this;
    }

    public String toString() {
        return "Machine " + this.getName();
    }

    public VMTemplate getVMTemplateFor(Template template) {
        return this.installedTemplates.get(template.getName());
    }

    @Override
    public void sleep() throws IOException, InterruptedException {
        throw new IOException("Impossible to put myself to sleep");
    }

    @Override
    public boolean isUp() {
        return true;
    }

    @Override
    public synchronized VirtUser getUser() {
        if (this.myself == null) {
            this.myself = LocalUser.myself((Injector)this.habitat);
        }
        return this.myself;
    }

    protected String getUserHome() {
        return System.getProperty("user.home");
    }

    protected Emulator getEmulator() {
        if (this.config.getEmulator() == null) {
            return this.group.getConfig().getVirtualization().getDefaultEmulator();
        }
        return this.config.getEmulator();
    }

    protected File absolutize(File source) {
        return RuntimeContext.absolutize(source);
    }

    @Override
    public boolean mkdir(String destPath) throws IOException {
        File target = this.absolutize(new File(destPath));
        return !target.exists() && target.mkdirs();
    }

    @Override
    public boolean delete(String path) throws IOException {
        File target = this.absolutize(new File(path));
        return target.exists() && target.delete();
    }

    @Override
    public boolean mv(String source, String dest) throws IOException {
        File sourceFile = this.absolutize(new File(source));
        if (sourceFile.exists()) {
            return sourceFile.renameTo(this.absolutize(new File(dest)));
        }
        return false;
    }

    @Override
    public long length(String path) throws IOException {
        File sourceFile = this.absolutize(new File(path));
        if (sourceFile.exists()) {
            return sourceFile.length();
        }
        throw new FileNotFoundException("Cannot find file " + path);
    }

    @Override
    public void copy(File source, File destDir) throws IOException {
        FileUtils.copy((File)this.absolutize(source), (File)new File(this.absolutize(destDir), source.getName()));
    }

    @Override
    public void localCopy(String source, String destDir) throws IOException {
        this.copy(new File(source), new File(destDir));
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.absolutize(new File(path)).exists();
    }

    protected List<StorageVol> prepare(final Template template, final String name, VirtualCluster cluster) throws VirtException, IOException {
        this.mkdir(this.config.getDisksLocation());
        final File sourceFile = new File(this.virtualizations.getTemplatesLocation(), template.getName() + ".img");
        this.delete(this.config.getDisksLocation() + "/" + name + "-cust.img");
        this.delete(this.config.getDisksLocation() + "/" + name + ".img");
        final StoragePool pool = this.getStoragePools().get("glassfishInstances") != null ? this.getStoragePools().get("glassfishInstances") : this.addStoragePool("glassfishInstances", 136112211968L);
        ArrayList<StorageVol> volumes = new ArrayList<StorageVol>();
        Object custDir = null;
        File custFile = null;
        Future<StorageVol> diskFuture = null;
        final String diskLocation = this.config.getDisksLocation();
        final LocalMachine target = this;
        try {
            diskFuture = ((ExecutorService)this.habitat.getComponent(ExecutorService.class)).submit(new Callable<StorageVol>(){

                @Override
                public StorageVol call() throws Exception {
                    VMTemplate vmTemplate = LocalMachine.this.getVMTemplateFor(template);
                    vmTemplate.copyTo(target, diskLocation);
                    StorageVol volume = pool.byName(name);
                    if (volume != null) {
                        volume.delete();
                    }
                    if (pool.byName(name) != null) {
                        pool.byName(name).delete();
                    }
                    volume = pool.allocate(name, vmTemplate.getSize());
                    LocalMachine.this.delete(diskLocation + "/" + name + ".img");
                    LocalMachine.this.mv(diskLocation + "/" + sourceFile.getName(), diskLocation + "/" + name + ".img");
                    return volume;
                }
            });
            File machineDisks = this.absolutize(new File(this.virtualizations.getDisksLocation(), this.group.getName()));
            machineDisks = new File(machineDisks, this.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            for (StorageVol vol : volumes) {
                try {
                    vol.delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (custFile != null && custFile.exists()) assert (custFile.delete());
            throw new VirtException(e);
        }
        try {
            volumes.add(0, diskFuture.get());
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ArrayList<StorageVol> copy = new ArrayList<StorageVol>();
                for (StorageVol storageVol : pool.volumes()) {
                    copy.add(storageVol);
                }
                for (StorageVol storageVol : copy) {
                    storageVol.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw new VirtException(e);
        }
        return volumes;
    }

    protected File prepareCustDirectory(String name, VirtualCluster cluster, Template template) throws IOException {
        File machineDisks = this.absolutize(new File(this.virtualizations.getDisksLocation(), this.group.getName()));
        File custDir = new File(machineDisks = new File(machineDisks, this.getName()), name + "cust");
        if (!custDir.exists() && !custDir.mkdirs()) {
            throw new IOException("cannot create disk cache on local machine");
        }
        this.createCustomizationFile(custDir, cluster, name, template);
        File home = new File(System.getProperty("user.home"));
        File keyFile = new File(home, ".ssh/id_dsa.pub");
        FileUtils.copy((File)keyFile, (File)new File(custDir, keyFile.getName()));
        keyFile = new File(home, ".ssh/id_rsa.pub");
        if (keyFile.exists()) {
            FileUtils.copy((File)keyFile, (File)new File(custDir, keyFile.getName()));
        }
        return custDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createCustomizationFile(File customizationDir, VirtualCluster cluster, String name, Template template) throws IOException {
        Properties customizedProperties = new Properties();
        Config configuration = (Config)this.habitat.getComponent(Config.class, "default-instance-name");
        NetworkListener nl = configuration.getNetworkConfig().getNetworkListener("admin-listener");
        customizedProperties.put("Group", this.group.getName());
        customizedProperties.put("Cluster", cluster.getConfig().getName());
        customizedProperties.put("Machine", this.getName());
        customizedProperties.put("MachineAlias", name);
        customizedProperties.put("GroupMasterPort", nl.getPort());
        customizedProperties.put("GroupMasterMachine", this.host.getHostAddress(this.group.getConfig().getPortName()));
        customizedProperties.put("DAS", System.getProperty("com.sun.aas.hostName"));
        customizedProperties.put("DASAddress", this.host.getHostAddress(this.group.getConfig().getPortName()));
        VirtUser vmUser = this.getUser();
        if (template.getUser() != null) {
            vmUser = template.getUser();
        }
        customizedProperties.put("UserName", vmUser.getName());
        customizedProperties.put("UserId", vmUser.getUserId());
        customizedProperties.put("GroupId", vmUser.getGroupId());
        AuthTokenManager tokenMgr = (AuthTokenManager)this.habitat.getComponent(AuthTokenManager.class);
        customizedProperties.put("AuthToken", tokenMgr.createToken(1800000L));
        customizedProperties.put("StartToken", tokenMgr.createToken(1800000L));
        File customization = new File(customizationDir, "customization");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(customization);
            customizedProperties.store(fileWriter, "Customization properties for virtual machine" + name);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
            return customization;
        }
    }

    protected Disk prepareCustomization(File custDir, File custFile, String name) throws IOException {
        Disk custDisk = (Disk)this.habitat.getComponent(Disk.class);
        custDisk.createISOFromDirectory(custDir, custFile);
        return custDisk;
    }
}

