/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.os.FileOperations;
import org.glassfish.virtualization.runtime.VMTemplate;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.util.RuntimeContext;

public class LocalTemplate
extends VMTemplate {
    public LocalTemplate(String location, Template config) {
        super(location, config);
    }

    public synchronized void copyTo(Machine destination, String destDir) throws IOException {
        String destPath = destDir + "/" + this.config.getName() + ".img";
        File source = new File(this.getLocation() + "/" + this.config.getName() + ".img");
        if (!source.exists()) {
            RuntimeContext.logger.severe("Cannot find template " + source.getAbsolutePath());
            throw new FileNotFoundException("Cannot find template " + source.getAbsolutePath());
        }
        FileOperations files = destination.getFileOperations();
        try {
            if (!files.exists(destPath)) {
                files.mkdir(destination.getConfig().getTemplatesLocation());
                RuntimeContext.logger.info("Copying template " + this.getDefinition().getName() + " on " + destination.getName());
                files.copy(source, new File(destination.getConfig().getTemplatesLocation()));
                RuntimeContext.logger.info("Finished copying template " + this.getDefinition().getName() + " on " + destination.getName());
            }
        }
        catch (IOException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot copy template on " + this.config.getName(), e);
            throw e;
        }
    }

    public long getSize() throws IOException {
        File source = new File(this.getLocation() + "/" + this.config.getName() + ".img");
        return source.length();
    }

    public boolean isLocal() {
        return true;
    }
}

