/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Service;

@Service
public class Host {
    public String getHostAddress(String name) {
        InetAddress addr;
        try {
            try {
                StringTokenizer portNames = new StringTokenizer(name, ";");
                while (portNames.hasMoreTokens()) {
                    String portName = portNames.nextToken();
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = interfaces.nextElement();
                        if (!networkInterface.getName().equals(portName)) continue;
                        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            String address = addresses.nextElement().getHostAddress();
                            if (!address.contains(".")) continue;
                            return address;
                        }
                    }
                }
            }
            catch (SocketException e) {
                RuntimeContext.logger.log(Level.INFO, e.getMessage(), e);
            }
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            RuntimeContext.logger.log(Level.INFO, e.getMessage(), e);
            return null;
        }
        return addr.getHostAddress();
    }
}

