/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.virtualization.config.GroupConfig;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.libvirt.LibVirtLocalMachine;
import org.glassfish.virtualization.libvirt.LibVirtMachine;
import org.glassfish.virtualization.runtime.VMTemplate;
import org.glassfish.virtualization.runtime.VirtualCluster;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Injector;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="libvirt")
@Scoped(value=PerLookup.class)
public class LibVirtGroup
implements PhysicalGroup,
ConfigListener {
    @Inject
    Injector injector;
    @Inject
    ExecutorService executorService;
    public GroupConfig config;
    final ConcurrentMap<String, Machine> machines = new ConcurrentHashMap<String, Machine>();
    List<VMTemplate> templates = new ArrayList<VMTemplate>();

    @Override
    public void setConfig(GroupConfig config) {
        this.config = config;
        Habitat habitat = Dom.unwrap((ConfigBeanProxy)config).getHabitat();
        if (((Virtualizations)habitat.getComponent(Virtualizations.class)).byName("libvirt") == null) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Virtualizations>(){

                    public Object run(Virtualizations wVirts) throws PropertyVetoException, TransactionFailure {
                        Virtualization libVirtConfig = (Virtualization)wVirts.createChild(Virtualization.class);
                        libVirtConfig.setName("libvirt");
                        wVirts.getVirtualizations().add(libVirtConfig);
                        return libVirtConfig;
                    }
                }, (ConfigBeanProxy)((ConfigBeanProxy)habitat.getComponent(Virtualizations.class)));
            }
            catch (TransactionFailure e) {
                RuntimeContext.logger.log(Level.SEVERE, "LibVirt configuration cannot be added to domain", e);
            }
        }
        Dom.unwrap((ConfigBeanProxy)config).addListener((ConfigListener)this);
        this.populateGroup();
    }

    @Override
    public GroupConfig getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public Iterable<? extends Machine> machines() {
        return this.machines.values();
    }

    @Override
    public int size() {
        return this.machines.size();
    }

    @Override
    public VirtualMachine vmByName(String name) throws VirtException {
        for (Machine machine : this.machines.values()) {
            VirtualMachine vm = machine.byName(name);
            if (vm == null) continue;
            return vm;
        }
        return null;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])propertyChangeEvents, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                try {
                    MachineConfig machineConfig = (MachineConfig)MachineConfig.class.cast(t);
                    if (type.equals((Object)Changed.TYPE.ADD)) {
                        Map macToIps = LibVirtGroup.this.MacAddressesToIps();
                        LibVirtGroup.this.addMachine(machineConfig, (String)macToIps.get(machineConfig.getMacAddress()));
                    }
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                return null;
            }
        }, (Logger)Logger.getAnonymousLogger());
    }

    @Override
    public Machine byName(String machineName) {
        return (Machine)this.machines.get(machineName);
    }

    private Map<String, String> MacAddressesToIps() {
        Habitat habitat = Dom.unwrap((ConfigBeanProxy)this.config).getHabitat();
        OsInterface os = (OsInterface)habitat.getComponent(OsInterface.class);
        return os.populateMacToIpsTable(this);
    }

    private void populateGroup() {
        Properties cached = new Properties();
        File cache = null;
        try {
            cache = new File(RuntimeContext.getCacheDir(), this.config.getName() + ".cache");
            if (cache.exists()) {
                this.populateCachedValues(cached, cache);
            }
        }
        catch (IOException e) {
            RuntimeContext.logger.log(Level.INFO, "Error while reading cache, recalculating all machines IPs", e);
        }
        Map<String, String> macToIps = null;
        boolean dirtyCache = false;
        for (MachineConfig machineConfig : this.config.getMachines()) {
            String macAddress;
            if (cached.containsKey(machineConfig.getName())) {
                LibVirtMachine machine;
                String ipAddress = cached.getProperty(machineConfig.getName());
                LibVirtLocalMachine libVirtLocalMachine = machine = machineConfig.getNetworkName() != null && machineConfig.getNetworkName().equals("localhost") ? LibVirtLocalMachine.from(this.injector, this, machineConfig) : LibVirtMachine.from(this.injector, this, machineConfig, ipAddress);
                if (machine.isUp()) {
                    this.addMachine(machine);
                    continue;
                }
            }
            if ((macAddress = machineConfig.getMacAddress()) != null && macToIps == null) {
                macToIps = this.MacAddressesToIps();
            }
            String ipAddress = null;
            if (macToIps != null) {
                ipAddress = macToIps.get(macAddress);
            }
            this.addMachine(machineConfig, ipAddress);
            if (ipAddress == null) continue;
            cached.put(machineConfig.getName(), ipAddress);
            dirtyCache = true;
        }
        if (dirtyCache && cache != null) {
            try {
                this.saveCachedValues(cached, cache);
            }
            catch (IOException e) {
                RuntimeContext.logger.log(Level.INFO, "Error while writing cache", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCachedValues(Properties cached, File cache) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(cache);
            cached.load(reader);
        }
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCachedValues(Properties cached, File cache) throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(cache);
            cached.store(writer, "Cache file for group " + this.config.getName());
        }
        finally {
            if (writer != null) {
                ((Writer)writer).close();
            }
        }
    }

    private void addMachine(MachineConfig machineConfig, String ipAddress) {
        LibVirtMachine machine = machineConfig.getNetworkName() != null && machineConfig.getNetworkName().equals("localhost") ? LibVirtLocalMachine.from(this.injector, this, machineConfig) : LibVirtMachine.from(this.injector, this, machineConfig, ipAddress);
        this.addMachine(machine);
    }

    private synchronized void addMachine(Machine machine) {
        this.machines.put(machine.getConfig().getName(), machine);
    }

    private Habitat getHabitat() {
        return Dom.unwrap((ConfigBeanProxy)this.config).getHabitat();
    }

    public String getHostAddress() {
        InetAddress addr;
        try {
            try {
                StringTokenizer portNames = new StringTokenizer(this.config.getPortName(), ";");
                while (portNames.hasMoreTokens()) {
                    String portName = portNames.nextToken();
                    Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = interfaces.nextElement();
                        if (!networkInterface.getName().equals(portName)) continue;
                        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            String address = addresses.nextElement().getHostAddress();
                            if (!address.contains(".")) continue;
                            return address;
                        }
                    }
                }
            }
            catch (SocketException e) {
                RuntimeContext.logger.log(Level.INFO, e.getMessage(), e);
            }
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            RuntimeContext.logger.log(Level.INFO, e.getMessage(), e);
            return null;
        }
        return addr.getHostAddress();
    }

    @Override
    public Iterable<Future<VirtualMachine>> allocate(final Template template, final VirtualCluster cluster, int number) throws VirtException {
        int park = this.size();
        if (park == 0) {
            throw new VirtException("Cannot allocate virtual machine to a group with no machine");
        }
        final ArrayList<Future<VirtualMachine>> vms = new ArrayList<Future<VirtualMachine>>();
        Iterator<? extends Machine> machines = this.machines().iterator();
        final CountDownLatch latch = new CountDownLatch(number);
        for (int i = 0; i < number; ++i) {
            Machine machine;
            int machineTried = 0;
            do {
                if (!machines.hasNext()) {
                    machines = this.machines().iterator();
                }
                machine = machines.next();
                ++machineTried;
                if (machine.isUp()) continue;
                RuntimeContext.logger.info("Waking up machine " + machine.getName());
                try {
                    Habitat habitat = Dom.unwrap((ConfigBeanProxy)this.config).getHabitat();
                    ((OsInterface)habitat.getComponent(OsInterface.class)).resume(machine);
                }
                catch (IOException e) {
                    RuntimeContext.logger.log(Level.SEVERE, "Error while waking up machine " + machine.getName(), e);
                }
                int tries = 0;
                do {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while (!machine.isUp() && ++tries < 5);
                if (machine.isUp()) continue;
                RuntimeContext.logger.log(Level.SEVERE, "Cannot wake up machine " + machine.getConfig().getDisksLocation());
            } while (!machine.isUp() || machineTried > park);
            if (!machine.isUp()) {
                RuntimeContext.logger.log(Level.SEVERE, "All the machines of this group are shutdown and cannot be started");
                throw new VirtException("Cannot start any of the group's machine");
            }
            final Machine targetMachine = machine;
            String suffix = number > 1 ? String.valueOf(i + 1) : "";
            this.executorService.submit(new Runnable(){

                public void run() {
                    try {
                        Future<VirtualMachine> vm = targetMachine.create(template, cluster);
                        vms.add(vm);
                    }
                    catch (Exception e) {
                        RuntimeContext.logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                    latch.countDown();
                }
            });
            RuntimeContext.logger.info("Virtual machine allocated in group " + this.getName() + " for cluster " + cluster.getConfig().getName());
        }
        try {
            latch.await(100L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            RuntimeContext.logger.warning("Timeout while waiting for machine allocation");
        }
        RuntimeContext.logger.info(number + " virtual machines allocated");
        return vms;
    }

    @Override
    public List<VMTemplate> getInstalledTemplates() {
        return new ArrayList<VMTemplate>(this.templates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(VMTemplate template) {
        LibVirtGroup libVirtGroup = this;
        synchronized (libVirtGroup) {
            this.templates.add(template);
        }
        for (Machine machine : this.machines()) {
            try {
                template.copyTo(machine, machine.getConfig().getTemplatesLocation());
            }
            catch (IOException e) {
                RuntimeContext.logger.log(Level.SEVERE, "Error while copying template to remote machine ", e);
            }
        }
    }
}

