/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.libvirt.LibVirtGroup;
import org.glassfish.virtualization.libvirt.LibVirtLocalMachine;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Injector;
import org.jvnet.hk2.component.PostConstruct;

class LibVirtMachine
extends LibVirtLocalMachine
implements Machine,
PostConstruct {
    final String ipAddress;
    @Inject
    SSHLauncher sshLauncher;

    public static LibVirtMachine from(Injector injector, LibVirtGroup group, MachineConfig config, String ipAddress) {
        return (LibVirtMachine)injector.inject((Object)new LibVirtMachine(injector, group, config, ipAddress));
    }

    protected LibVirtMachine(Injector injector, LibVirtGroup group, MachineConfig config, String ipAddress) {
        super(injector, group, config);
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean mkdir(String destPath) throws IOException {
        this.getSSH();
        SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
        if (!sftpClient.exists(this.config.getDisksLocation())) {
            sftpClient.mkdirs(this.config.getDisksLocation(), 493);
            return true;
        }
        return false;
    }

    public boolean delete(String path) throws IOException {
        SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
        if (sftpClient.exists(path)) {
            sftpClient.rm(path);
            return true;
        }
        return false;
    }

    public boolean mv(String source, String dest) throws IOException {
        SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
        if (this.exists(dest)) {
            this.delete(dest);
        }
        sftpClient.mv(source, dest);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length(String path) throws IOException {
        SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
        try {
            long l = sftpClient.lstat((String)path).size;
            return l;
        }
        finally {
            sftpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String path) throws IOException {
        SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
        try {
            boolean bl = sftpClient.exists(path);
            return bl;
        }
        finally {
            sftpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File source, File destination) throws IOException {
        this.getSSH();
        SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
        try {
            this.mkdirs(sftpClient, destination);
            String destPath = destination + "/" + source.getName();
            if (sftpClient.exists(destPath)) {
                sftpClient.rm(destPath);
            }
        }
        finally {
            sftpClient.close();
        }
        this.sshLauncher.getSCPClient().put(source.getAbsolutePath(), destination.getPath());
    }

    public void mkdirs(SFTPClient client, File path) throws IOException {
        if (path.getParentFile() != null) {
            this.mkdirs(client, path.getParentFile());
        }
        if (!client.exists(path.getPath())) {
            client.mkdirs(path.getPath(), 493);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localCopy(String source, String destDir) throws IOException {
        this.getSSH();
        try {
            SFTPClient client = this.sshLauncher.getSFTPClient();
            try {
                if (!client.exists(destDir)) {
                    client.mkdirs(destDir, 493);
                }
            }
            finally {
                client.close();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            RuntimeContext.logger.info("Remote cp file " + source + " on " + this.getName());
            this.sshLauncher.runCommand("cp " + source + " " + destDir, (OutputStream)baos);
        }
        catch (IOException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot copy file on " + this.getName(), e);
            throw e;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public PhysicalGroup getGroup() {
        return this.group;
    }

    public void ping() throws IOException, InterruptedException {
        SSHLauncher ssl = this.getSSH();
        ssl.pingConnection();
    }

    public void sleep() throws IOException, InterruptedException {
        SSHLauncher ssl = this.getSSH();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ssl.runCommand("sudo pm-suspend", (OutputStream)baos);
        System.out.println(baos.toString());
    }

    public boolean isUp() {
        if (Machine.State.READY.equals((Object)this.getState())) {
            return true;
        }
        if (this.ipAddress == null) {
            return false;
        }
        try {
            this.ping();
        }
        catch (Exception e) {
            RuntimeContext.logger.log(Level.SEVERE, "Exception while pinging " + this.config.getName() + " : " + e.getMessage());
            RuntimeContext.logger.log(Level.FINE, "Exception while pinging " + this.config.getName(), e);
            return false;
        }
        try {
            this.connection();
        }
        catch (VirtException e) {
            RuntimeContext.logger.log(Level.SEVERE, "Cannot connect to machine " + this.config.getName() + " with the user " + this.group.getConfig().getUser().getName(), e);
            return false;
        }
        return true;
    }

    public VirtUser getUser() {
        if (this.config.getUser() != null) {
            return this.config.getUser();
        }
        return this.group.getConfig().getUser();
    }

    protected String getUserHome() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.getSSH().runCommand("echo $HOME", (OutputStream)baos);
        }
        catch (Exception e) {
            return "/home" + this.getUser().getName();
        }
        String userHome = baos.toString();
        return userHome.substring(0, userHome.length() - 1);
    }

    private SSHLauncher getSSH() {
        File home = new File(System.getProperty("user.home"));
        String keyFile = new File(home, ".ssh/id_dsa").getAbsolutePath();
        this.sshLauncher.init(this.getUser().getName(), this.ipAddress, 22, null, keyFile, null, Logger.getAnonymousLogger());
        return this.sshLauncher;
    }
}

