/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.libvirt.jna;

import org.glassfish.virtualization.libvirt.jna.DomainInfo;
import org.glassfish.virtualization.libvirt.jna.DomainPointer;
import org.glassfish.virtualization.libvirt.jna.LibVirtObject;
import org.glassfish.virtualization.spi.VirtException;

public class Domain
extends LibVirtObject {
    final DomainPointer handle;

    public Domain(DomainPointer handle) {
        this.handle = handle;
    }

    public String getName() throws VirtException {
        String returnValue = libvirt.virDomainGetName(this.handle);
        this.checkForError();
        return returnValue;
    }

    public String getOSType() throws VirtException {
        String returnValue = libvirt.virDomainGetOSType(this.handle);
        this.checkForError();
        return returnValue;
    }

    public int getID() throws VirtException {
        int returnValue = libvirt.virDomainGetID(this.handle);
        this.checkForError();
        return returnValue;
    }

    public int create() throws VirtException {
        int returnValue = libvirt.virDomainCreate(this.handle);
        this.checkForError();
        return returnValue;
    }

    public void destroy() throws VirtException {
        libvirt.virDomainDestroy(this.handle);
        this.checkForError();
    }

    public void suspend() throws VirtException {
        libvirt.virDomainSuspend(this.handle);
        this.checkForError();
    }

    public void undefine() throws VirtException {
        libvirt.virDomainUndefine(this.handle);
        this.checkForError();
    }

    public void reboot(int flags) throws VirtException {
        libvirt.virDomainReboot(this.handle, flags);
        this.checkForError();
    }

    public void resume() throws VirtException {
        libvirt.virDomainResume(this.handle);
        this.checkForError();
    }

    public DomainInfo getInfo() throws VirtException {
        DomainInfo returnValue = new DomainInfo();
        int success = libvirt.virDomainGetInfo(this.handle, returnValue);
        this.checkForError();
        return success == 0 ? returnValue : null;
    }
}

