/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.cloud;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.admin.DeployCommand;
import org.glassfish.deployment.cloud.CloudApplication;
import org.glassfish.deployment.cloud.CloudService;
import org.glassfish.deployment.cloud.JavaEEService;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

@Service
@Scoped(value=PerLookup.class)
public class CloudInterceptor
implements DeployCommand.Interceptor {
    @Inject
    Habitat habitat;
    @Inject
    RuntimeContext rtContext;
    @Inject(name="plain")
    ActionReport actionReport;

    public void intercept(DeployCommand command, DeploymentContext context) {
        block4: {
            System.out.println("Interceptor called for ..." + command.name());
            boolean clusterCreated = false;
            try {
                if (context.getSource().exists("META-INF/cloud.xml")) {
                    System.out.println("This is a virtual application !");
                    CloudApplication cloudApplication = this.readConfig(context.getSource());
                    for (CloudService cloudService : cloudApplication.getServices().getServices()) {
                        if (!(cloudService instanceof JavaEEService)) continue;
                        JavaEEService javaEE = (JavaEEService)cloudService;
                        System.out.println("Applications wants " + javaEE.getMinInstances() + " Java EE instances");
                        this.rtContext.executeAdminCommand(this.actionReport, "create-virtual-cluster", command.name(), "min", javaEE.getMinInstances());
                        clusterCreated = !this.actionReport.hasFailures();
                        command.target = command.name();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!clusterCreated) break block4;
                this.rtContext.executeAdminCommand(this.actionReport, "delete-virtual-cluster", command.name(), new String[0]);
            }
        }
    }

    private CloudApplication readConfig(ReadableArchive archive) throws IOException {
        InputStream is = null;
        try {
            XMLStreamReader reader;
            is = archive.getEntry("META-INF/cloud.xml");
            if (is == null) {
                return null;
            }
            try {
                reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                return null;
            }
            ConfigParser configParser = new ConfigParser(this.habitat);
            DomDocument document = configParser.parse(reader);
            return (CloudApplication)document.getRoot().createProxy(CloudApplication.class);
        }
        catch (Exception e) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw new IOException(e);
            }
            return null;
        }
    }
}

