/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization;

import java.io.File;
import org.glassfish.virtualization.ParameterResolver;
import org.glassfish.virtualization.config.Action;

public class ShellCommand {
    final Action action;
    final String path;
    final ParameterResolver resolver;

    public ShellCommand(String path, Action action, ParameterResolver resolver) {
        this.path = path;
        this.action = action;
        this.resolver = resolver;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        File f = new File(this.path, this.action.getCommand());
        if (this.action.getInvoker() != null) {
            builder.append(this.action.getInvoker()).append(' ');
        }
        if (f.exists()) {
            builder.append(f.getAbsolutePath());
        } else {
            builder.append(this.action.getCommand());
        }
        builder.append(' ');
        for (String p : this.action.getParameters()) {
            if (p != null) {
                String resolved = this.resolver.resolve(p);
                if (resolved == null) {
                    builder.append(p);
                } else {
                    builder.append(resolved);
                }
            }
            builder.append(' ');
        }
        return builder.toString();
    }
}

