/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ServerRef;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.virtualization.commands.DeleteVirtualMachine;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-virtual-cluster")
@Scoped(value=PerLookup.class)
public class DeleteVirtualCluster
implements AdminCommand {
    @Param(primary=true)
    String name;
    @Inject
    Domain domain;
    @Inject
    RuntimeContext rtContext;
    @Inject
    DeleteVirtualMachine vmDeleter;
    @Inject
    ExecutorService executorService;

    public void execute(final AdminCommandContext context) {
        Cluster cluster = this.domain.getClusterNamed(this.name);
        if (cluster == null) {
            context.getActionReport().failure(RuntimeContext.logger, "Cannot find cluster named " + this.name);
            return;
        }
        ArrayList deletions = new ArrayList();
        for (final ServerRef serverRef : cluster.getServerRef()) {
            deletions.add(this.executorService.submit(new Runnable(){

                public void run() {
                    DeleteVirtualCluster.this.vmDeleter.deleteServerRef(context, serverRef);
                }
            }));
        }
        for (Future future : deletions) {
            try {
                future.get(100L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                RuntimeContext.logger.log(Level.WARNING, "Cannot delete remote virtual machine...", e);
            }
        }
        this.rtContext.executeAdminCommand(context.getActionReport(), "delete-cluster", this.name, new String[0]);
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
        context.getActionReport().setMessage("Cluster " + this.name + " deleted successfully");
    }
}

