/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.util.logging.Logger;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-vm")
@Scoped(value=PerLookup.class)
public class ListVirtualMachines
implements AdminCommand {
    @Inject
    GroupManagement gm;

    public void execute(AdminCommandContext context) {
        try {
            for (PhysicalGroup group : this.gm) {
                context.getActionReport().setMessage("For Group : " + group.getName());
                for (Machine machine : group.machines()) {
                    System.out.println("  LibVirtMachine " + machine.getName() + " at " + machine.getIpAddress());
                    for (VirtualMachine virtualMachine : machine.getVMs()) {
                        context.getActionReport().getTopMessagePart().addChild().setMessage("Virtual Machine: " + virtualMachine.getName() + " is " + (Object)((Object)virtualMachine.getInfo().getState()));
                    }
                }
            }
        }
        catch (VirtException e) {
            context.getActionReport().failure(Logger.getAnonymousLogger(), "Exception while listing machines ", (Throwable)e);
        }
    }
}

