/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.virtualization.spi.Group;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;

public abstract class MachineMgt {
    @Param(name="group")
    String groupName;
    @Param(name="machine")
    String machineName;
    @Inject
    GroupManagement gm;
    protected ActionReport report;

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        Group vmProvider = this.gm.byName(this.groupName);
        if (vmProvider != null && vmProvider instanceof PhysicalGroup) {
            PhysicalGroup group = (PhysicalGroup)vmProvider;
            Machine machine = group.byName(this.machineName);
            if (machine == null) {
                context.getActionReport().failure(Logger.getAnonymousLogger(), "Don't know about machine " + this.machineName);
                return;
            }
            try {
                this.doWork(machine);
            }
            catch (VirtException e) {
                context.getActionReport().failure(Logger.getAnonymousLogger(), e.getMessage(), (Throwable)e);
            }
        } else {
            context.getActionReport().failure(RuntimeContext.logger, "group does not exist or does not contain physical machines");
        }
    }

    abstract void doWork(Machine var1) throws VirtException;
}

