/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.util.concurrent.CountDownLatch;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.virtualization.runtime.VirtualMachineLifecycle;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="register-startup")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class RegisterStartup
implements AdminCommand {
    @Param(primary=true)
    String instanceName;
    @Inject
    VirtualMachineLifecycle vmLifecycle;

    public void execute(AdminCommandContext context) {
        String vmName = this.instanceName.substring(this.instanceName.lastIndexOf("_") + 1);
        CountDownLatch latch = this.vmLifecycle.getStartupLatch(vmName);
        if (latch != null) {
            latch.countDown();
        }
        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

