/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.virtualization.spi.Group;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.VirtException;
import org.glassfish.virtualization.spi.VirtualMachine;
import org.glassfish.virtualization.spi.VirtualMachineInfo;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Supplemental(value="stop-instance", on=Supplemental.Timing.After)
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class SupplementalStopInstance
implements AdminCommand {
    @Param(name="instance_name", primary=true)
    String instanceName;
    @Param(name="_vmShutdown", optional=true, defaultValue="true")
    private String vmShutdown;
    @Inject(optional=true)
    GroupManagement groups = null;

    public void execute(AdminCommandContext context) {
        if (!Boolean.valueOf(this.vmShutdown).booleanValue() || this.instanceName.indexOf("_") == -1 || this.groups == null) {
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        if (this.instanceName.endsWith("Instance")) {
            try {
                String groupName = this.instanceName.substring(0, this.instanceName.indexOf("_"));
                String vmName = this.instanceName.substring(this.instanceName.lastIndexOf("_") + 1, this.instanceName.length() - "Instance".length());
                Group group = this.groups.byName(groupName);
                try {
                    VirtualMachine vm = group.vmByName(vmName);
                    VirtualMachineInfo vmInfo = vm.getInfo();
                    if (Machine.State.SUSPENDED.equals((Object)vmInfo.getState())) {
                        context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return;
                    }
                    vm.stop();
                }
                catch (VirtException e) {
                    RuntimeContext.logger.warning(e.getMessage());
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.SUCCESS);
                return;
            }
        }
    }
}

