/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.commands;

import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.virtualization.spi.GroupManagement;
import org.glassfish.virtualization.spi.Machine;
import org.glassfish.virtualization.spi.OsInterface;
import org.glassfish.virtualization.spi.PhysicalGroup;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="suspend-machine")
@Scoped(value=PerLookup.class)
public class SuspendMachine
implements AdminCommand {
    @Param(primary=true)
    String machineName;
    @Inject
    OsInterface os;
    @Inject
    GroupManagement groups;

    public void execute(AdminCommandContext context) {
        for (PhysicalGroup group : this.groups) {
            for (Machine machine : group.machines()) {
                if (!machine.getName().equals(this.machineName)) continue;
                try {
                    this.os.suspend(machine);
                }
                catch (IOException e) {
                    context.getActionReport().failure(RuntimeContext.logger, e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

