/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.virtualization.config.MachineConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualization;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface GroupConfig
extends ConfigBeanProxy {
    @Attribute(key=true)
    public String getName();

    @Param(name="name", primary=true)
    public void setName(String var1);

    @Attribute
    public String getPortName();

    @Param(name="portName")
    public void setPortName(String var1);

    @Attribute(reference=true)
    public Virtualization getVirtualization();

    public void setVirtualization(Virtualization var1);

    @Attribute
    public String getSubNet();

    @Param(name="subNet")
    public void setSubNet(String var1);

    @Element
    @NotNull
    public VirtUser getUser();

    @Create(value="create-group-user", resolver=GroupResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    public void setUser(VirtUser var1);

    @Element
    @Create(value="create-machine", resolver=GroupResolver.class, decorator=MachineConfig.Decorator.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    @Listing(value="list-machines", resolver=GroupResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-machines"))
    @Delete(value="delete-machine", resolver=WithinGroupResolver.class, i18n=@I18n(value="org.glassfish.virtualization.delete-machine"))
    public List<MachineConfig> getMachines();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class WithinGroupResolver
    extends GroupResolver {
        @Param(primary=true)
        String name;

        @Override
        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            GroupConfig group = (GroupConfig)super.resolve(context, type);
            if (group != null) {
                for (MachineConfig machineConfig : group.getMachines()) {
                    if (!machineConfig.getName().equals(this.name)) continue;
                    return (T)machineConfig;
                }
                context.getActionReport().failure(context.getLogger(), "Cannot find a machine by the name of " + group);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class GroupResolver
    implements CrudResolver {
        @Param(name="group")
        String group;
        @Inject
        Virtualizations virt;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            for (GroupConfig provider : this.virt.getGroupConfigs()) {
                if (!provider.getName().equals(this.group)) continue;
                return (T)provider;
            }
            context.getActionReport().failure(context.getLogger(), "Cannot find a group by the name of " + this.group);
            return null;
        }
    }
}

