/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import java.beans.PropertyVetoException;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.virtualization.config.Emulator;
import org.glassfish.virtualization.config.GroupConfig;
import org.glassfish.virtualization.config.VirtUser;
import org.glassfish.virtualization.config.Virtualizations;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.TransactionFailure;

@Configured
public interface MachineConfig
extends ConfigBeanProxy {
    @Attribute(key=true)
    public String getName();

    @Param(primary=true, name="name")
    public void setName(String var1);

    @Element
    public String getNetworkName();

    @Param(optional=true, name="networkName")
    public void setNetworkName(String var1);

    @Element
    public String getIpAddress();

    public void setIpAddress(String var1);

    @Element
    public String getMacAddress();

    @Param(optional=true, name="mac")
    public void setMacAddress(String var1);

    @Attribute
    public String getOsName();

    public void setOsName(String var1);

    @Attribute(reference=true)
    public Emulator getEmulator();

    public void setEmulator(Emulator var1);

    @Attribute(defaultValue="virt/disks")
    public String getDisksLocation();

    @Param(optional=true)
    public void setDisksLocation(String var1);

    @Attribute(defaultValue="virt/templates")
    public String getTemplatesLocation();

    @Param(optional=true)
    public void setTemplatesLocation(String var1);

    @Element
    public VirtUser getUser();

    @Create(value="create-machine-user", resolver=MachineResolver.class, i18n=@I18n(value="org.glassfish.virtualization.create-machine"))
    public void setUser(VirtUser var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class Decorator
    implements CreationDecorator<MachineConfig> {
        @Param(name="emulator", optional=true)
        String emulatorName;
        @Inject
        Habitat habitat;

        public void decorate(AdminCommandContext context, MachineConfig instance) throws TransactionFailure, PropertyVetoException {
            if (this.emulatorName == null) {
                return;
            }
            Emulator emulator = (Emulator)this.habitat.getComponent(Emulator.class, this.emulatorName);
            if (emulator == null) {
                context.getActionReport().failure(RuntimeContext.logger, "Cannot find emulator definition named " + this.emulatorName);
                throw new TransactionFailure("Cannot find emulator definition named " + this.emulatorName);
            }
            instance.setEmulator(emulator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class MachineResolver
    implements CrudResolver {
        @Param(name="group")
        String group;
        @Param(name="machine")
        String machine;
        @Inject
        Virtualizations virt;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            for (GroupConfig provider : this.virt.getGroupConfigs()) {
                if (!provider.getName().equals(this.group)) continue;
                for (MachineConfig mc : provider.getMachines()) {
                    if (!mc.getName().equals(this.machine)) continue;
                    return (T)mc;
                }
            }
            context.getActionReport().failure(context.getLogger(), "Cannot find a machine by the name of " + this.machine);
            return null;
        }
    }
}

