/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.config;

import java.util.List;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.Create;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.Delete;
import org.glassfish.config.support.Listing;
import org.glassfish.config.support.TypeAndNameResolver;
import org.glassfish.virtualization.config.Action;
import org.glassfish.virtualization.config.Emulator;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.config.Virtualizations;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configured
public interface Virtualization
extends ConfigBeanProxy {
    @Attribute(key=true)
    public String getName();

    public void setName(String var1);

    @Element
    public String getScriptsLocation();

    public void setScriptsLocation(String var1);

    @Element(value="action")
    public List<Action> getActions();

    @Attribute(reference=true)
    public Emulator getDefaultEmulator();

    public void setDefaultEmulator(Emulator var1);

    @Element
    @Create(value="add-template", resolver=VirtResolver.class, decorator=Template.TemplateAddDecorator.class, i18n=@I18n(value="org.glassfish.virtualization.add-template"))
    @Listing(value="list-templates", resolver=VirtResolver.class, i18n=@I18n(value="org.glassfish.virtualization.list-templates"))
    @Delete(value="remove-template", resolver=TypeAndNameResolver.class, i18n=@I18n(value="org.glassfish.virtualization.remove-template"))
    public List<Template> getTemplates();

    @DuckTyped
    public Template templateByName(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Service
    public static class VirtResolver
    implements CrudResolver {
        @Param(name="virtName")
        String virt;
        @Inject
        Virtualizations virtulizations;

        public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, Class<T> type) {
            for (Virtualization v : this.virtulizations.getVirtualizations()) {
                if (!v.getName().equals(this.virt)) continue;
                return (T)v;
            }
            return null;
        }
    }

    public static class Duck {
        public static Template templateByName(Virtualization self, String name) {
            for (Template template : self.getTemplates()) {
                if (!template.getName().equals(name)) continue;
                return template;
            }
            return null;
        }
    }
}

