/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.runtime;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.virtualization.runtime.VirtualCluster;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class VirtualClusters {
    final Domain domain;
    final Map<String, VirtualCluster> clusterMap = new HashMap<String, VirtualCluster>();

    public VirtualClusters(@Inject Domain domain) {
        this.domain = domain;
    }

    public void add(VirtualCluster vc) {
        this.clusterMap.put(vc.getConfig().getName(), vc);
    }

    public void remove(VirtualCluster vc) {
        this.clusterMap.remove(vc.getConfig().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualCluster byName(String clusterName) {
        if (!this.clusterMap.containsKey(clusterName)) {
            Cluster cluster = this.domain.getClusterNamed(clusterName);
            if (cluster == null) {
                throw new InvalidParameterException(clusterName + " cluster not found");
            }
            VirtualClusters virtualClusters = this;
            synchronized (virtualClusters) {
                if (!this.clusterMap.containsKey(clusterName)) {
                    this.clusterMap.put(clusterName, new VirtualCluster(cluster));
                }
            }
        }
        return this.clusterMap.get(clusterName);
    }
}

