/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.glassfish.virtualization.config.Template;
import org.glassfish.virtualization.spi.Group;
import org.glassfish.virtualization.spi.StaticVirtualMachineInfo;
import org.glassfish.virtualization.spi.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMOrder {
    final int number;
    final Template template;
    final List<Group> groups = new ArrayList<Group>();
    final List<VirtualMachine> noColocationList = new ArrayList<VirtualMachine>();
    final Properties vmProps = new Properties();

    public VMOrder(Template template, int number) {
        this.number = number;
        this.template = template;
    }

    public int number() {
        return this.number;
    }

    public StaticVirtualMachineInfo getCharacteristics() {
        return null;
    }

    public VMOrder in(Group ... groups) {
        this.groups.addAll(Arrays.asList(groups));
        return this;
    }

    public VMOrder noColocationWith(VirtualMachine ... vms) {
        this.noColocationList.addAll(Arrays.asList(vms));
        return this;
    }

    public Properties getVirtualMachineProperties(int machineNumber) {
        return this.vmProps;
    }

    public Collection<Group> affinities() {
        return Collections.unmodifiableList(this.groups);
    }

    public List<VirtualMachine> separateFrom() {
        return Collections.unmodifiableList(this.noColocationList);
    }
}

