/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.util;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service
public class RuntimeContext {
    public static final boolean debug = true;
    public static final Logger logger = Logger.getAnonymousLogger();
    @Inject
    CommandRunner commandRunner;
    public static final ExecutorService es = Executors.newFixedThreadPool(5);

    public static File getCacheDir() throws IOException {
        File instanceRoot = new File(System.getProperty("com.sun.aas.instanceRoot"));
        File virtRoot = new File(instanceRoot, "virt");
        File cacheRoot = new File(virtRoot, "cache");
        if (!cacheRoot.exists() && !cacheRoot.mkdirs()) {
            throw new IOException("Cannot create cache directory at " + cacheRoot.getAbsolutePath());
        }
        return cacheRoot;
    }

    public static File absolutize(File source) {
        return source.isAbsolute() ? source : new File(System.getProperty("user.home"), source.getPath());
    }

    public static String getEncodedOS() {
        return System.getProperty("os.name").replaceAll(" ", "_");
    }

    public boolean executeAdminCommand(ActionReport report, String commandName, String operand, String ... parameters) {
        ParameterMap params = new ParameterMap();
        if (operand != null) {
            params.add((Object)"DEFAULT", (Object)operand);
        }
        int i = 0;
        while (i < parameters.length) {
            String key = parameters[i++];
            String value = null;
            if (i < parameters.length) {
                value = parameters[i++];
            }
            params.add((Object)key, value);
        }
        CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation(commandName, report);
        inv.parameters(params);
        inv.execute();
        return report.getActionExitCode() == ActionReport.ExitCode.SUCCESS;
    }
}

