/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.virtualization.util;

import java.io.File;
import java.io.IOException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.virtualization.ShellExecutor;
import org.glassfish.virtualization.os.Disk;
import org.glassfish.virtualization.util.RuntimeContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class ScriptBasedDisk
implements Disk {
    @Inject
    ShellExecutor shell;
    @Inject
    ServerContext env;
    int loopCounter = 0;
    File mountPoint;

    public File getScriptPath() {
        File file = new File(this.env.getInstallRoot(), "config");
        File parentDir = new File(file, "libvirt");
        File osDir = new File(parentDir, RuntimeContext.getEncodedOS());
        if (!osDir.exists()) {
            osDir = new File(parentDir, "linux");
        }
        return osDir;
    }

    public int create(File path, int size, File mountPoint) throws IOException {
        Process p;
        try {
            p = this.shell.execute(new File("/usr/bin"), "sudo " + this.getScriptPath() + "/create-disk.sh " + path.getAbsolutePath() + " " + size + " " + mountPoint.getAbsolutePath());
            p.waitFor();
            RuntimeContext.logger.info(this.shell.output(p));
            RuntimeContext.logger.info(this.shell.error(p));
            this.mountPoint = mountPoint;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.loopCounter = p.exitValue();
        return p.exitValue();
    }

    public int mount(File path, File mountPoint) throws IOException {
        Process p;
        try {
            p = this.shell.execute(new File("/usr/bin"), "sudo " + this.getScriptPath() + "/mount-disk.sh " + path.getAbsolutePath() + " " + mountPoint.getAbsolutePath());
            p.waitFor();
            RuntimeContext.logger.info(this.shell.output(p));
            RuntimeContext.logger.info(this.shell.error(p));
            this.mountPoint = mountPoint;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.loopCounter = p.exitValue();
        return p.exitValue();
    }

    public int umount() throws IOException {
        try {
            Process p = this.shell.execute(new File("/usr/bin"), "sudo " + this.getScriptPath() + "/unmount-disk.sh " + this.mountPoint.getAbsolutePath() + " " + this.loopCounter);
            RuntimeContext.logger.info(this.shell.output(p));
            RuntimeContext.logger.info(this.shell.error(p));
            p.waitFor();
            return p.exitValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public int createISOFromDirectory(File sourceDirectory, File outputISOFile) throws IOException {
        try {
            File scriptLoc = new File(this.getScriptPath(), "mkisofs.sh");
            scriptLoc.setExecutable(true);
            Process p = this.shell.execute(this.getScriptPath(), "mkisofs.sh " + sourceDirectory.getAbsolutePath() + " " + outputISOFile.getAbsolutePath());
            RuntimeContext.logger.info(this.shell.output(p));
            RuntimeContext.logger.info(this.shell.error(p));
            p.waitFor();
            return p.exitValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

