/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.MethodInvoker;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

public class MonitoringHandlers {
    private TreeNode serverRoot = ((MonitoringRuntimeDataRegistry)GuiUtil.getHabitat().getComponent(MonitoringRuntimeDataRegistry.class)).get("server");
    private static final String RESOURCE_NAME = "org.glassfish.web.admingui.Strings";

    public void getVirtualServers(HandlerContext handlerCtx) {
        TreeNode server;
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String application = (String)handlerCtx.getInputValue("application");
        ArrayList<String> dataList = new ArrayList<String>();
        if (application.equals("All")) {
            dataList.add("All");
        } else if (this.serverRoot != null && (server = this.serverRoot.getNode("applications." + application)) != null && server.isEnabled()) {
            Collection coll = server.getChildNodes();
            for (TreeNode tn : coll) {
                dataList.add(tn.getName());
            }
        }
        handlerCtx.setOutputValue("virtualServers", dataList);
        if (!dataList.isEmpty()) {
            handlerCtx.setOutputValue("firstVirtualServer", (Object)((String)dataList.get(0)));
        }
    }

    public void getWebStats(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String application = (String)handlerCtx.getInputValue("application");
        String virtualServer = (String)handlerCtx.getInputValue("virtualServer");
        List statNames = (List)handlerCtx.getInputValue("statNames");
        String type = (String)handlerCtx.getInputValue("type");
        String test = (String)handlerCtx.getInputValue("test");
        TreeNode statsNode = null;
        if (this.serverRoot != null) {
            statsNode = application == null || application.equals("All") ? this.serverRoot.getNode("web." + type) : this.serverRoot.getNode("applications." + application + "." + virtualServer);
        }
        List<Object> coll = null;
        ArrayList dataList = new ArrayList();
        if (statsNode != null && statsNode.isEnabled()) {
            if (application == null || application.equals("All")) {
                coll = statsNode.getChildNodes();
            } else if (type.equals("request")) {
                coll = new ArrayList<TreeNode>();
                for (String s : statNames) {
                    TreeNode tn = this.serverRoot.getNode("applications." + application + "." + virtualServer + "." + s);
                    if (tn == null) continue;
                    coll.add(tn);
                }
            } else {
                String ype = type.substring(1);
                String t = type.substring(0, 1);
                String T = t.toUpperCase();
                coll = statsNode.getNodes("*applications." + application + "." + virtualServer + "." + "*" + "[" + t + T + "]" + ype + "*");
            }
            ArrayList list = new ArrayList();
            list.addAll(coll);
            Collections.sort(list);
            for (Object o : list) {
                TreeNode tn = (TreeNode)o;
                HashMap<String, Object> statMap = new HashMap<String, Object>();
                statMap.put("Name", tn.getName());
                statMap.put("Value", tn.getValue());
                statMap.put("ToolTip", "");
                if (tn instanceof Counter) {
                    statMap.put("ToolTip", ((Counter)tn).getDescription());
                }
                dataList.add(statMap);
            }
        }
        handlerCtx.setOutputValue("stats", dataList);
    }

    public void getStats(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        String node = (String)handlerCtx.getInputValue("node");
        if (node != null && node.endsWith("All")) {
            node = node.replace("All", "request");
        }
        String test = (String)handlerCtx.getInputValue("test");
        ArrayList dataList = new ArrayList();
        if (this.serverRoot != null) {
            TreeNode statsNode = this.serverRoot.getNode(node);
            Collection coll = null;
            if (statsNode != null && statsNode.isEnabled()) {
                coll = statsNode.getChildNodes();
                ArrayList list = new ArrayList();
                list.addAll(coll);
                Collections.sort(list);
                for (Object o : list) {
                    TreeNode tn = (TreeNode)o;
                    HashMap<String, Object> statMap = new HashMap<String, Object>();
                    statMap.put("Name", tn.getName());
                    statMap.put("Value", tn.getValue());
                    statMap.put("ToolTip", "");
                    if (tn instanceof Counter) {
                        statMap.put("ToolTip", ((Counter)tn).getDescription());
                    }
                    dataList.add(statMap);
                }
            }
        }
        handlerCtx.setOutputValue("stats", dataList);
    }

    public void getJvmStats(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        ArrayList dataList = new ArrayList();
        if (this.serverRoot != null) {
            MethodInvoker tn = (MethodInvoker)this.serverRoot.getNode("jvm").getNode("committedHeapSize");
            MemoryUsage mu = (MemoryUsage)tn.getInstance();
            HashMap<String, Object> statMap = new HashMap<String, Object>();
            statMap.put("Name", "init");
            statMap.put("Value", mu.getInit());
            statMap.put("ToolTip", GuiUtil.getMessage((String)RESOURCE_NAME, (String)"monitoring.jvm.init.tooltip"));
            dataList.add(statMap);
            statMap = new HashMap();
            statMap.put("Name", "used");
            statMap.put("Value", mu.getUsed());
            statMap.put("ToolTip", GuiUtil.getMessage((String)RESOURCE_NAME, (String)"monitoring.jvm.used.tooltip"));
            dataList.add(statMap);
            statMap = new HashMap();
            statMap.put("Name", "committed");
            statMap.put("Value", mu.getCommitted());
            statMap.put("ToolTip", GuiUtil.getMessage((String)RESOURCE_NAME, (String)"monitoring.jvm.committed.tooltip"));
            dataList.add(statMap);
            statMap = new HashMap();
            statMap.put("Name", "max");
            statMap.put("Value", mu.getMax());
            statMap.put("ToolTip", GuiUtil.getMessage((String)RESOURCE_NAME, (String)"monitoring.jvm.max.tooltip"));
            dataList.add(statMap);
        }
        handlerCtx.setOutputValue("jvmStats", dataList);
    }

    public void getChildNodes(HandlerContext handlerCtx) {
        String node = (String)handlerCtx.getInputValue("node");
        String category = (String)handlerCtx.getInputValue("category");
        String firstInList = (String)handlerCtx.getInputValue("firstInList");
        ArrayList<String> dataList = new ArrayList<String>();
        TreeNode treeNode = null;
        if (this.serverRoot != null) {
            treeNode = this.serverRoot.getNode(node);
        }
        if (treeNode != null && treeNode.isEnabled()) {
            Collection coll = treeNode.getChildNodes();
            for (TreeNode tn : coll) {
                if (category != null) {
                    if (!tn.getCategory().equals(category)) continue;
                    dataList.add(tn.getName());
                    continue;
                }
                dataList.add(tn.getName());
            }
            if (firstInList != null) {
                dataList.add(0, firstInList);
            }
        }
        handlerCtx.setOutputValue("childNodes", dataList);
        if (!dataList.isEmpty()) {
            handlerCtx.setOutputValue("firstItem", dataList.get(0));
        }
    }

    private TreeNode setupTree() {
        TreeNode serverRoot = TreeNodeFactory.createTreeNode((String)"server", (Object)this, (String)"server");
        TreeNode applications = TreeNodeFactory.createTreeNode((String)"applications", (Object)this, (String)"applications");
        TreeNode webApp1 = TreeNodeFactory.createTreeNode((String)"webApp1", (Object)this, (String)"application");
        TreeNode webApp2 = TreeNodeFactory.createTreeNode((String)"webApp2", (Object)this, (String)"application");
        TreeNode webApp3 = TreeNodeFactory.createTreeNode((String)"webApp3", (Object)this, (String)"application");
        TreeNode server11 = TreeNodeFactory.createTreeNode((String)"server11", (Object)this, (String)"server");
        TreeNode server12 = TreeNodeFactory.createTreeNode((String)"server12", (Object)this, (String)"server");
        TreeNode server13 = TreeNodeFactory.createTreeNode((String)"server13", (Object)this, (String)"server");
        TreeNode server21 = TreeNodeFactory.createTreeNode((String)"server21", (Object)this, (String)"server");
        TreeNode server22 = TreeNodeFactory.createTreeNode((String)"server22", (Object)this, (String)"server");
        TreeNode server23 = TreeNodeFactory.createTreeNode((String)"server23", (Object)this, (String)"server");
        Counter counter111 = CounterFactory.createCount((long[])new long[]{10L});
        counter111.setName("11activesessionscurrent-count");
        server11.addChild((TreeNode)counter111);
        Counter counter112 = CounterFactory.createCount((long[])new long[]{9L});
        counter112.setName("11activesessionshigh-count");
        server11.addChild((TreeNode)counter112);
        Counter counter113 = CounterFactory.createCount((long[])new long[]{5L});
        counter113.setName("11expiredsessionstotal-count");
        server11.addChild((TreeNode)counter113);
        Counter counter114 = CounterFactory.createCount((long[])new long[]{6L});
        counter114.setName("11rejectedsessionstotal-count");
        server11.addChild((TreeNode)counter114);
        Counter counter115 = CounterFactory.createCount((long[])new long[]{7L});
        counter115.setName("11sessionstotal-count");
        server11.addChild((TreeNode)counter115);
        Counter reqcountjsp11 = CounterFactory.createCount((long[])new long[]{10L});
        reqcountjsp11.setName("11jsp1requestcount");
        server11.addChild((TreeNode)reqcountjsp11);
        Counter proctimejsp11 = CounterFactory.createCount((long[])new long[]{9L});
        proctimejsp11.setName("11jsp1processingtime");
        server11.addChild((TreeNode)proctimejsp11);
        Counter servicetimejsp11 = CounterFactory.createCount((long[])new long[]{5L});
        servicetimejsp11.setName("11jsp1servicingtime");
        server11.addChild((TreeNode)servicetimejsp11);
        webApp1.addChild(server11);
        Counter reqcountjsp12 = CounterFactory.createCount((long[])new long[]{10L});
        reqcountjsp12.setName("jsp12requestcount");
        server12.addChild((TreeNode)reqcountjsp12);
        Counter proctimejsp12 = CounterFactory.createCount((long[])new long[]{9L});
        proctimejsp12.setName("jsp12processingtime");
        server12.addChild((TreeNode)proctimejsp12);
        Counter servicetimejsp12 = CounterFactory.createCount((long[])new long[]{5L});
        servicetimejsp12.setName("jsp12servicingtime");
        server12.addChild((TreeNode)servicetimejsp12);
        webApp1.addChild(server12);
        Counter reqcountjsp23 = CounterFactory.createCount((long[])new long[]{10L});
        reqcountjsp23.setName("jsp23requestcount");
        server23.addChild((TreeNode)reqcountjsp23);
        Counter proctimejsp23 = CounterFactory.createCount((long[])new long[]{9L});
        proctimejsp23.setName("jsp23processingtime");
        server23.addChild((TreeNode)proctimejsp23);
        Counter servicetimejsp23 = CounterFactory.createCount((long[])new long[]{5L});
        servicetimejsp23.setName("jsp23servicingtime");
        server23.addChild((TreeNode)servicetimejsp23);
        webApp2.addChild(server23);
        Counter counter211 = CounterFactory.createCount((long[])new long[]{210L});
        counter211.setName("21activesessionscurrent-count");
        server21.addChild((TreeNode)counter211);
        Counter counter212 = CounterFactory.createCount((long[])new long[]{29L});
        counter212.setName("21activesessionshigh-count");
        server21.addChild((TreeNode)counter212);
        Counter counter213 = CounterFactory.createCount((long[])new long[]{25L});
        counter213.setName("21expiredsessionstotal-count");
        server21.addChild((TreeNode)counter213);
        Counter counter214 = CounterFactory.createCount((long[])new long[]{26L});
        counter214.setName("21rejectedsessionstotal-count");
        server21.addChild((TreeNode)counter214);
        Counter counter215 = CounterFactory.createCount((long[])new long[]{27L});
        counter215.setName("21sessionstotal-count");
        server21.addChild((TreeNode)counter215);
        webApp2.addChild(server21);
        applications.addChild(webApp1);
        applications.addChild(webApp2);
        applications.addChild(webApp3);
        serverRoot.addChild(applications);
        TreeNode web = TreeNodeFactory.createTreeNode((String)"web", (Object)this, (String)"web");
        TreeNode session = TreeNodeFactory.createTreeNode((String)"session", (Object)this, (String)"session");
        TreeNode servlet = TreeNodeFactory.createTreeNode((String)"servlet", (Object)this, (String)"servlet");
        TreeNode jsp = TreeNodeFactory.createTreeNode((String)"jsp", (Object)this, (String)"jsp");
        TreeNode request = TreeNodeFactory.createTreeNode((String)"request", (Object)this, (String)"request");
        Counter sessionStat1 = CounterFactory.createCount((long[])new long[]{210L});
        sessionStat1.setName("Totalactivesessionscurrent-count");
        session.addChild((TreeNode)sessionStat1);
        Counter sessionStat2 = CounterFactory.createCount((long[])new long[]{29L});
        sessionStat2.setName("Totalactivesessionshigh-count");
        session.addChild((TreeNode)sessionStat2);
        Counter sessionStat3 = CounterFactory.createCount((long[])new long[]{25L});
        sessionStat3.setName("Totalexpiredsessionstotal-count");
        session.addChild((TreeNode)sessionStat3);
        Counter servletStat1 = CounterFactory.createCount((long[])new long[]{210L});
        servletStat1.setName("Totalactiveservletscurrent-count");
        servlet.addChild((TreeNode)servletStat1);
        Counter servletStat2 = CounterFactory.createCount((long[])new long[]{29L});
        servletStat2.setName("Totalactiveservletshigh-count");
        servlet.addChild((TreeNode)servletStat2);
        Counter servletStat3 = CounterFactory.createCount((long[])new long[]{25L});
        servletStat3.setName("Totalexpiredservletstotal-count");
        servlet.addChild((TreeNode)servletStat3);
        Counter jspStat1 = CounterFactory.createCount((long[])new long[]{210L});
        jspStat1.setName("Totalactivejspscurrent-count");
        jsp.addChild((TreeNode)jspStat1);
        Counter jspStat2 = CounterFactory.createCount((long[])new long[]{29L});
        jspStat2.setName("Totalactivejspshigh-count");
        jsp.addChild((TreeNode)jspStat2);
        Counter jspStat3 = CounterFactory.createCount((long[])new long[]{25L});
        jspStat3.setName("Totalexpiredjspstotal-count");
        jsp.addChild((TreeNode)jspStat3);
        Counter requestStat1 = CounterFactory.createCount((long[])new long[]{210L});
        requestStat1.setName("Totalactiverequestscurrent-count");
        request.addChild((TreeNode)requestStat1);
        Counter requestStat2 = CounterFactory.createCount((long[])new long[]{29L});
        requestStat2.setName("Totalactiverequestshigh-count");
        request.addChild((TreeNode)requestStat2);
        Counter requestStat3 = CounterFactory.createCount((long[])new long[]{25L});
        requestStat3.setName("Totalexpiredrequestsstotal-count");
        request.addChild((TreeNode)requestStat3);
        web.addChild(session);
        web.addChild(servlet);
        web.addChild(jsp);
        web.addChild(request);
        serverRoot.addChild(web);
        TreeNode httpService = TreeNodeFactory.createTreeNode((String)"http-service", (Object)this, (String)"http-service");
        TreeNode virtualServer1 = TreeNodeFactory.createTreeNode((String)"virtual-server1", (Object)this, (String)"virtual-server");
        TreeNode virtualServer2 = TreeNodeFactory.createTreeNode((String)"virtual-server2", (Object)this, (String)"virtual-server");
        TreeNode hsrequest1 = TreeNodeFactory.createTreeNode((String)"request", (Object)this, (String)"request");
        TreeNode hsrequest2 = TreeNodeFactory.createTreeNode((String)"request", (Object)this, (String)"request");
        Counter hsrequestStat11 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hsrequestStat12 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hsrequestStat13 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hsrequestStat21 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hsrequestStat22 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hsrequestStat23 = CounterFactory.createCount((long[])new long[]{210L});
        hsrequestStat11.setName("hsrequestStat11");
        hsrequestStat12.setName("hsrequestStat12");
        hsrequestStat13.setName("hsrequestStat13");
        hsrequestStat21.setName("hsrequestStat21");
        hsrequestStat22.setName("hsrequestStat22");
        hsrequestStat23.setName("hsrequestStat23");
        hsrequest1.addChild((TreeNode)hsrequestStat11);
        hsrequest1.addChild((TreeNode)hsrequestStat12);
        hsrequest1.addChild((TreeNode)hsrequestStat13);
        hsrequest2.addChild((TreeNode)hsrequestStat21);
        hsrequest2.addChild((TreeNode)hsrequestStat22);
        hsrequest2.addChild((TreeNode)hsrequestStat23);
        virtualServer1.addChild(hsrequest1);
        virtualServer2.addChild(hsrequest2);
        TreeNode httpListener11 = TreeNodeFactory.createTreeNode((String)"http-listener11", (Object)this, (String)"http-listener");
        TreeNode httpListener12 = TreeNodeFactory.createTreeNode((String)"http-listener12", (Object)this, (String)"http-listener");
        TreeNode httpListener21 = TreeNodeFactory.createTreeNode((String)"http-listener21", (Object)this, (String)"http-listener");
        TreeNode httpListener22 = TreeNodeFactory.createTreeNode((String)"http-listener22", (Object)this, (String)"http-listener");
        Counter hlrequestStat111 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat112 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat113 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat121 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat122 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat123 = CounterFactory.createCount((long[])new long[]{210L});
        hlrequestStat111.setName("hlrequestStat111");
        hlrequestStat112.setName("hlrequestStat112");
        hlrequestStat113.setName("hlrequestStat113");
        hlrequestStat121.setName("hlrequestStat121");
        hlrequestStat122.setName("hlrequestStat122");
        hlrequestStat123.setName("hlrequestStat123");
        Counter hlrequestStat211 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat212 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat213 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat221 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat222 = CounterFactory.createCount((long[])new long[]{210L});
        Counter hlrequestStat223 = CounterFactory.createCount((long[])new long[]{210L});
        hlrequestStat211.setName("hlrequestStat211");
        hlrequestStat212.setName("hlrequestStat212");
        hlrequestStat213.setName("hlrequestStat213");
        hlrequestStat221.setName("hlrequestStat221");
        hlrequestStat222.setName("hlrequestStat222");
        hlrequestStat223.setName("hlrequestStat223");
        httpListener11.addChild((TreeNode)hlrequestStat111);
        httpListener11.addChild((TreeNode)hlrequestStat112);
        httpListener11.addChild((TreeNode)hlrequestStat113);
        httpListener12.addChild((TreeNode)hlrequestStat121);
        httpListener12.addChild((TreeNode)hlrequestStat122);
        httpListener12.addChild((TreeNode)hlrequestStat123);
        httpListener21.addChild((TreeNode)hlrequestStat211);
        httpListener21.addChild((TreeNode)hlrequestStat212);
        httpListener21.addChild((TreeNode)hlrequestStat213);
        httpListener22.addChild((TreeNode)hlrequestStat221);
        httpListener22.addChild((TreeNode)hlrequestStat222);
        httpListener22.addChild((TreeNode)hlrequestStat223);
        virtualServer1.addChild(httpListener11);
        virtualServer1.addChild(httpListener12);
        virtualServer2.addChild(httpListener21);
        virtualServer2.addChild(httpListener22);
        httpService.addChild(virtualServer1);
        httpService.addChild(virtualServer2);
        TreeNode threadPool = TreeNodeFactory.createTreeNode((String)"thread-pool", (Object)this, (String)"thread-pool");
        Counter threadPoolStat1 = CounterFactory.createCount((long[])new long[]{210L});
        Counter threadPoolStat2 = CounterFactory.createCount((long[])new long[]{210L});
        Counter threadPoolStat3 = CounterFactory.createCount((long[])new long[]{210L});
        threadPoolStat1.setName("threadPoolStat1");
        threadPoolStat2.setName("threadPoolStat2");
        threadPoolStat3.setName("threadPoolStat3");
        threadPool.addChild((TreeNode)threadPoolStat1);
        threadPool.addChild((TreeNode)threadPoolStat2);
        threadPool.addChild((TreeNode)threadPoolStat3);
        httpService.addChild(threadPool);
        TreeNode connectionQueue = TreeNodeFactory.createTreeNode((String)"connection-queue", (Object)this, (String)"connection-queue");
        Counter connectionQueueStat1 = CounterFactory.createCount((long[])new long[]{210L});
        Counter connectionQueueStat2 = CounterFactory.createCount((long[])new long[]{210L});
        Counter connectionQueueStat3 = CounterFactory.createCount((long[])new long[]{210L});
        connectionQueueStat1.setName("connectionQueueStat1");
        connectionQueueStat2.setName("connectionQueueStat2");
        connectionQueueStat3.setName("connectionQueueStat3");
        connectionQueue.addChild((TreeNode)connectionQueueStat1);
        connectionQueue.addChild((TreeNode)connectionQueueStat2);
        connectionQueue.addChild((TreeNode)connectionQueueStat3);
        httpService.addChild(connectionQueue);
        serverRoot.addChild(httpService);
        TreeNode jvm = TreeNodeFactory.createTreeNode((String)"jvm", (Object)this, (String)"jvm");
        Counter jvmStat1 = CounterFactory.createCount((long[])new long[]{210L});
        Counter jvmStat2 = CounterFactory.createCount((long[])new long[]{210L});
        Counter jvmStat3 = CounterFactory.createCount((long[])new long[]{210L});
        jvmStat1.setName("jvmStat1");
        jvmStat2.setName("jvmStat2");
        jvmStat3.setName("jvmStat3");
        jvm.addChild((TreeNode)jvmStat1);
        jvm.addChild((TreeNode)jvmStat2);
        jvm.addChild((TreeNode)jvmStat3);
        serverRoot.addChild(jvm);
        return serverRoot;
    }
}

