/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.web.WebContainer;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.util.http.mapper.Mapper;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

public class HttpServiceConfigListener
implements ConfigListener,
MapperUpdateListener {
    @Inject
    public HttpService httpService;
    @Inject(optional=true)
    public AccessLog accessLog;
    @Inject(optional=true)
    public List<Property> property;
    @Inject(name="accessLoggingEnabled", optional=true)
    public Property accessLoggingEnabledProperty;
    @Inject(name="docroot", optional=true)
    public Property docroot;
    private WebContainer container;
    private Logger logger;
    volatile boolean received = false;

    public void setContainer(WebContainer container) {
        this.container = container;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch((PropertyChangeEvent[])events, (Changed)new Changed(){

            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> tClass, T t) {
                if (HttpServiceConfigListener.this.logger.isLoggable(Level.FINE)) {
                    HttpServiceConfigListener.this.logger.fine("HttpService config changed " + type + " " + tClass + " " + t);
                }
                try {
                    if (t instanceof VirtualServer) {
                        if (type == Changed.TYPE.ADD) {
                            HttpServiceConfigListener.this.container.createHost((VirtualServer)t, HttpServiceConfigListener.this.httpService, null);
                        } else if (type == Changed.TYPE.REMOVE) {
                            HttpServiceConfigListener.this.container.deleteHost(HttpServiceConfigListener.this.httpService);
                        } else if (type == Changed.TYPE.CHANGE) {
                            HttpServiceConfigListener.this.container.updateHost((VirtualServer)t);
                        }
                        return null;
                    }
                    if (t instanceof NetworkListener) {
                        if (type == Changed.TYPE.ADD) {
                            HttpServiceConfigListener.this.container.addConnector((NetworkListener)t, HttpServiceConfigListener.this.httpService, true);
                        } else if (type == Changed.TYPE.REMOVE) {
                            HttpServiceConfigListener.this.container.deleteConnector((NetworkListener)t);
                        } else if (type == Changed.TYPE.CHANGE) {
                            HttpServiceConfigListener.this.container.updateConnector((NetworkListener)t, HttpServiceConfigListener.this.httpService);
                        }
                        return null;
                    }
                    if (t instanceof AccessLog) {
                        HttpServiceConfigListener.this.container.updateAccessLog(HttpServiceConfigListener.this.httpService);
                    }
                    HttpServiceConfigListener.this.container.updateHttpService(HttpServiceConfigListener.this.httpService);
                }
                catch (LifecycleException le) {
                    HttpServiceConfigListener.this.logger.log(Level.SEVERE, "Exception processing HttpService config change", le);
                }
                return null;
            }
        }, (Logger)this.logger);
    }

    public void update(HttpService httpService, NetworkListener httpListener, Mapper mapper) {
        this.container.updateMapper(httpService, httpListener, mapper);
    }
}

