/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.telemetry;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.client.ProbeClientMethodHandle;
import org.glassfish.flashlight.client.ProbeListener;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.annotations.ProbeParam;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.factory.CounterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolTelemetry {
    private TreeNode threadPoolNode;
    private Collection<ProbeClientMethodHandle> handles;
    private Logger logger;
    private boolean isEnabled = true;
    private String id;
    private String maxTPSize;
    private TreeNode maxThreadsNode;
    private Counter activeThreadsCount = CounterFactory.createCount((long[])new long[0]);
    private Counter threadsUsed = CounterFactory.createCount((long[])new long[0]);
    private Counter activeThreadsHighCount = CounterFactory.createCount((long[])new long[0]);

    ThreadPoolTelemetry(TreeNode threadPoolNode, String id, String maxTPSize, Logger logger) {
        try {
            this.threadPoolNode = threadPoolNode;
            this.logger = logger;
            this.id = id;
            this.maxTPSize = maxTPSize;
            Method m1 = this.maxTPSize.getClass().getMethod("toString", new Class[0]);
            this.maxThreadsNode = TreeNodeFactory.createMethodInvoker((String)"maxthreads-count", (Object)this.maxTPSize, (String)"thread-pool", (Method)m1);
            threadPoolNode.addChild(this.maxThreadsNode);
            this.activeThreadsHighCount.setCategory("thread-pool");
            threadPoolNode.addChild((TreeNode)this.activeThreadsHighCount);
            this.activeThreadsHighCount.setName("peakqueued-count");
            Method m2 = this.getClass().getMethod("getIdleCount", new Class[0]);
            TreeNode idleThreadsNode = TreeNodeFactory.createMethodInvoker((String)"countthreadsidle-count", (Object)this, (String)"thread-pool", (Method)m2);
            threadPoolNode.addChild(idleThreadsNode);
            Method m3 = this.getClass().getMethod("getActiveThreadCount", new Class[0]);
            TreeNode activeThreadsNode = TreeNodeFactory.createMethodInvoker((String)"countthreads-count", (Object)this, (String)"thread-pool", (Method)m3);
            threadPoolNode.addChild(activeThreadsNode);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(ThreadPoolTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ThreadPoolTelemetry.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @ProbeListener(value="core:threadpool::newThreadsAllocatedEvent")
    public void newThreadsAllocatedEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="increment") int increment, @ProbeParam(value="boolean") boolean startThread) {
        this.logger.finest("[TM]newThreadsAllocatedEvent received - : increment = " + increment + " :startThread = " + startThread + ": Thread pool name = " + threadPoolName);
        if (threadPoolName.equals(this.id)) {
            this.activeThreadsCount.setCount(this.activeThreadsCount.getCount() + (long)increment);
        }
    }

    @ProbeListener(value="core:threadpool::maxNumberOfThreadsReachedEvent")
    public void maxNumberOfThreadsReachedEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="maxNumberOfThreads") int maxNumberOfThreads) {
        this.logger.finest("[TM]maxNumberOfThreadsReachedEvent received - : maxNumberOfThreads = " + maxNumberOfThreads + ": Thread pool name = " + threadPoolName);
    }

    @ProbeListener(value="core:threadpool::threadDispatchedFromPoolEvent")
    public void threadDispatchedFromPoolEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") String threadId) {
        this.logger.finest("[TM]threadDispatchedFromPoolEvent received - : threadId = " + threadId + ": Thread pool name = " + threadPoolName);
        if (threadPoolName.equals(this.id)) {
            this.threadsUsed.increment();
            if (this.threadsUsed.getCount() > this.activeThreadsHighCount.getCount()) {
                this.activeThreadsHighCount.setCount(this.threadsUsed.getCount());
            }
        }
    }

    @ProbeListener(value="core:threadpool::threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") String threadId) {
        this.logger.finest("[TM]threadReturnedToPoolEvent received - : threadId = " + threadId + ": Thread pool name = " + threadPoolName);
        if (threadPoolName.equals(this.id)) {
            this.threadsUsed.decrement();
        }
    }

    public void setProbeListenerHandles(Collection<ProbeClientMethodHandle> handles) {
        this.handles = handles;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enableMonitoring(boolean flag) {
        if (this.isEnabled == flag) {
            return;
        }
        for (ProbeClientMethodHandle handle : this.handles) {
            if (flag) {
                handle.enable();
                continue;
            }
            handle.disable();
        }
        this.threadPoolNode.setEnabled(flag);
        if (this.isEnabled) {
            this.resetStats();
        }
        this.isEnabled = flag;
    }

    private void resetStats() {
    }

    public long getIdleCount() {
        return this.activeThreadsCount.getCount() - this.threadsUsed.getCount();
    }

    public long getActiveThreadCount() {
        return this.activeThreadsCount.getCount();
    }
}

