/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationDispatcher;

public class AsyncContextImpl
implements AsyncContext {
    private static final Logger log = Logger.getLogger(AsyncContextImpl.class.getName());
    private static final ExecutorService pool = Executors.newCachedThreadPool();
    private Request origRequest;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private boolean isOriginalRequestAndResponse = false;
    private String dispatchTargetURI = null;

    public AsyncContextImpl(Request origRequest, ServletRequest servletRequest, Response origResponse, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) {
        this.origRequest = origRequest;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = isOriginalRequestAndResponse;
        if (isOriginalRequestAndResponse) {
            this.dispatchTargetURI = origRequest.getRequestURI();
        } else if (servletRequest instanceof HttpServletRequest) {
            this.dispatchTargetURI = ((HttpServletRequest)servletRequest).getRequestURI();
        } else {
            log.warning("Unable to determine target of zero-argument dispatch");
        }
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.isOriginalRequestAndResponse;
    }

    public void dispatch() {
        if (this.dispatchTargetURI == null) {
            log.severe("Unable to determine target of zero-arg dispatch");
        } else {
            this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
            ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(this.dispatchTargetURI);
            if (dispatcher != null) {
                this.origRequest.setOkToReinitializeAsync(true);
                this.origRequest.setAsyncStarted(false);
                pool.execute(new Handler(dispatcher, this.servletRequest, this.servletResponse));
            } else {
                log.warning("Unable to acquire RequestDispatcher for " + this.dispatchTargetURI);
            }
        }
    }

    public void dispatch(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)this.servletRequest.getRequestDispatcher(path);
        if (dispatcher != null) {
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(dispatcher, this.servletRequest, this.servletResponse));
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path);
        }
    }

    public void dispatch(ServletContext context, String path) {
        if (path == null || context == null) {
            throw new IllegalArgumentException("Null context or path");
        }
        this.origRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ASYNC);
        ApplicationDispatcher dispatcher = (ApplicationDispatcher)context.getRequestDispatcher(path);
        if (dispatcher != null) {
            this.origRequest.setOkToReinitializeAsync(true);
            this.origRequest.setAsyncStarted(false);
            pool.execute(new Handler(dispatcher, this.servletRequest, this.servletResponse));
        } else {
            log.warning("Unable to acquire RequestDispatcher for " + path + "in servlet context " + context.getContextPath());
        }
    }

    public void complete() {
        if (!this.origRequest.isAsyncStarted()) {
            throw new IllegalStateException("Request not in async mode");
        }
        this.origRequest.asyncComplete();
    }

    public void start(Runnable run) {
        pool.execute(run);
    }

    void reinitialize(ServletRequest servletRequest, ServletResponse servletResponse, boolean isOriginalRequestAndResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.isOriginalRequestAndResponse = isOriginalRequestAndResponse;
        if (isOriginalRequestAndResponse) {
            this.dispatchTargetURI = this.origRequest.getRequestURI();
        } else if (servletRequest instanceof HttpServletRequest) {
            this.dispatchTargetURI = ((HttpServletRequest)servletRequest).getRequestURI();
        } else {
            log.warning("Unable to determine target of zero-argument dispatch");
        }
    }

    static class Handler
    implements Runnable {
        private final ApplicationDispatcher dispatcher;
        private final ServletRequest request;
        private final ServletResponse response;

        Handler(ApplicationDispatcher dispatcher, ServletRequest request, ServletResponse response) {
            this.dispatcher = dispatcher;
            this.request = request;
            this.response = response;
        }

        public void run() {
            try {
                this.dispatcher.dispatch(this.request, this.response, DispatcherType.ASYNC);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Error during ASYNC dispatch", e);
            }
        }
    }
}

