/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import com.sun.grizzly.util.http.mapper.Mapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Auditor;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.AlternateDocBase;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DynamicFilterRegistrationImpl;
import org.apache.catalina.core.DynamicServletRegistrationImpl;
import org.apache.catalina.core.FilterRegistrationImpl;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.ServletRegistrationImpl;
import org.apache.catalina.core.SessionCookieConfigImpl;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.FilterMaps;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceParams;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.ServletMap;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.naming.ContextBindings;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.glassfish.web.loader.ServletContainerInitializerUtil;
import org.glassfish.web.valve.GlassFishValve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardContext
extends ContainerBase
implements Context,
Serializable {
    private static transient Logger log = Logger.getLogger(StandardContext.class.getName());
    private static final ClassLoader standardContextClassLoader = StandardContext.class.getClassLoader();
    private static final Set<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = EnumSet.of(SessionTrackingMode.COOKIE);
    private Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> servletContainerInitializerInterestList = null;
    protected static final URLEncoder urlEncoder = new URLEncoder();
    private String altDDName = null;
    private String hostName;
    private List<String> applicationListeners = new ArrayList<String>();
    private transient Object[] applicationEventListenersObjects = new Object[0];
    private transient Object[] applicationLifecycleListenersObjects = new Object[0];
    private List<ApplicationParameter> applicationParameters = new ArrayList<ApplicationParameter>();
    private boolean available = false;
    private transient NotificationBroadcasterSupport broadcaster = null;
    private transient CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private String configFile = null;
    private boolean configured = false;
    private List<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();
    protected transient ApplicationContext context = null;
    private boolean isContextInitializedCalled = false;
    private String compilerClasspath = null;
    private boolean cookies = true;
    private boolean enableURLRewriting = true;
    private boolean crossContext = false;
    private boolean delegate = false;
    private String displayName = null;
    private String defaultWebXml;
    private boolean distributable = false;
    private String docBase = null;
    private Map<String, ErrorPage> exceptionPages = new HashMap<String, ErrorPage>();
    private ErrorPage defaultErrorPage;
    private Map<String, FilterConfig> filterConfigs = new HashMap<String, FilterConfig>();
    private Map<String, FilterDef> filterDefs = new HashMap<String, FilterDef>();
    private List<FilterMap> filterMaps = new ArrayList<FilterMap>();
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    private ArrayList<String> instanceListeners = new ArrayList();
    private List<InstanceListener> instanceListenerInstances = new ArrayList<InstanceListener>();
    private LoginConfig loginConfig = null;
    private transient Mapper mapper = new Mapper();
    private transient NamingContextListener namingContextListener = null;
    private NamingResources namingResources = new NamingResources();
    private Map<String, MessageDestination> messageDestinations = new HashMap<String, MessageDestination>();
    private HashMap<String, String> mimeMappings = new HashMap();
    private HashMap<String, String> parameters = new HashMap();
    private boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean unpackWAR = true;
    private boolean override = false;
    private String originalDocBase = null;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private boolean securePagesWithPragma = true;
    private Map<String, String> roleMappings = new HashMap<String, String>();
    private List<String> securityRoles = new ArrayList<String>();
    private final Map<String, String> servletMappings = new HashMap<String, String>();
    private int sessionTimeout = 30;
    private boolean sessionTimeoutOveridden = false;
    private long sequenceNumber = 0L;
    private final Map<Integer, ErrorPage> statusPages = new HashMap<Integer, ErrorPage>();
    private final Map<String, String> taglibs = new HashMap<String, String>();
    private List<String> watchedResources = Collections.synchronizedList(new ArrayList());
    private String[] welcomeFiles = new String[0];
    private ArrayList<String> wrapperLifecycles = new ArrayList();
    private List<String> wrapperListeners = new ArrayList<String>();
    private String workDir = null;
    private String wrapperClassName = StandardWrapper.class.getName();
    private Class wrapperClass = null;
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    private int managerChecksFrequency = 6;
    private int count = 0;
    private boolean cachingAllowed = true;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    protected int cacheTTL = 5000;
    private boolean lazy = true;
    private transient DirContext webappResources = null;
    private long startupTime;
    private long startTimeMillis;
    private long tldScanTime;
    protected boolean caseSensitiveMapping = true;
    private boolean reuseSessionID = false;
    private boolean allowRelativeRedirect = false;
    private String engineName = null;
    private String j2EEApplication = "null";
    private String j2EEServer = "none";
    private transient Auditor[] auditors = null;
    private static int instanceIDCounter;
    private boolean webXmlValidation = false;
    private String jvmRoute;
    private boolean webXmlNamespaceAware = false;
    private boolean tldValidation = false;
    private boolean tldNamespaceAware = false;
    protected boolean isJsfApplication = false;
    private boolean saveConfig = true;
    private boolean isReload = false;
    private ArrayList<AlternateDocBase> alternateDocBases = null;
    private boolean useMyFaces;
    private Set<SessionTrackingMode> sessionTrackingModes;
    private String encodedPath = null;
    private SessionCookieConfig sessionCookieConfig;
    private String sessionCookieName = "JSESSIONID";
    private boolean sessionCookieConfigInitialized = false;
    private ConcurrentHashMap<String, ServletRegistration> servletRegisMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FilterRegistration> filterRegisMap = new ConcurrentHashMap();
    private String server = null;
    private String[] javaVMs = null;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.namingResources.setContainer(this);
        this.broadcaster = new NotificationBroadcasterSupport();
    }

    public void restrictedSetPipeline(Pipeline pl) {
        pl.setBasic(new StandardContextValve());
        this.pipeline = pl;
        this.hasCustomPipeline = true;
    }

    @Override
    public String getEncodedPath() {
        return this.encodedPath;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.encodedPath = urlEncoder.encode(name);
    }

    public boolean isSaveConfig() {
        return this.saveConfig;
    }

    public void setSaveConfig(boolean saveConfig) {
        this.saveConfig = saveConfig;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitiveMapping(boolean caseSensitiveMap) {
        this.caseSensitiveMapping = caseSensitiveMap;
    }

    public boolean isCaseSensitiveMapping() {
        return this.caseSensitiveMapping;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    @Override
    public Object[] getApplicationEventListeners() {
        return this.applicationEventListenersObjects;
    }

    @Override
    public void setApplicationEventListeners(Object[] listeners) {
        this.applicationEventListenersObjects = listeners;
    }

    @Override
    public Object[] getApplicationLifecycleListeners() {
        return this.applicationLifecycleListenersObjects;
    }

    @Override
    public void setApplicationLifecycleListeners(Object[] listeners) {
        this.applicationLifecycleListenersObjects = listeners;
    }

    @Override
    public boolean getAvailable() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        boolean oldAvailable = this.available;
        this.available = available;
        this.support.firePropertyChange("available", (Object)oldAvailable, (Object)this.available);
    }

    @Override
    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    @Override
    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        if (mapper != null) {
            this.charsetMapperClass = mapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    @Override
    public String getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", (Object)oldConfigured, (Object)this.configured);
    }

    @Override
    public boolean getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
        this.support.firePropertyChange("cookies", (Object)oldCookies, (Object)this.cookies);
    }

    @Override
    public boolean isEnableURLRewriting() {
        return this.enableURLRewriting;
    }

    @Override
    public void setEnableURLRewriting(boolean enableURLRewriting) {
        boolean oldEnableURLRewriting = this.enableURLRewriting;
        this.enableURLRewriting = enableURLRewriting;
        this.support.firePropertyChange("enableURLRewriting", (Object)oldEnableURLRewriting, (Object)this.enableURLRewriting);
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", (Object)oldCrossContext, (Object)this.crossContext);
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String defaultWebXml) {
        this.defaultWebXml = defaultWebXml;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long tldScanTime) {
        this.tldScanTime = tldScanTime;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getAltDDName() {
        return this.altDDName;
    }

    @Override
    public void setAltDDName(String altDDName) {
        this.altDDName = altDDName;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", altDDName);
            this.context.setAttributeReadOnly("org.apache.catalina.deploy.alt_dd");
        }
    }

    public String getCompilerClasspath() {
        return this.compilerClasspath;
    }

    public void setCompilerClasspath(String compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", (Object)oldDistributable, (Object)this.distributable);
        if (this.getManager() != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Propagating distributable=" + distributable + " to manager");
            }
            this.getManager().setDistributable(distributable);
        }
    }

    @Override
    public String getDocBase() {
        return this.docBase;
    }

    @Override
    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    public void addAlternateDocBase(String urlPattern, String docBase) {
        if (urlPattern == null || docBase == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.alternateDocBase.missingPathOrUrlPattern"));
        }
        AlternateDocBase alternateDocBase = new AlternateDocBase();
        alternateDocBase.setUrlPattern(urlPattern);
        alternateDocBase.setDocBase(docBase);
        alternateDocBase.setBasePath(this.getBasePath(docBase));
        if (this.alternateDocBases == null) {
            this.alternateDocBases = new ArrayList();
        }
        this.alternateDocBases.add(alternateDocBase);
    }

    public ArrayList<AlternateDocBase> getAlternateDocBases() {
        return this.alternateDocBases;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public int getManagerChecksFrequency() {
        return this.managerChecksFrequency;
    }

    public void setManagerChecksFrequency(int managerChecksFrequency) {
        if (managerChecksFrequency <= 0) {
            return;
        }
        int oldManagerChecksFrequency = this.managerChecksFrequency;
        this.managerChecksFrequency = managerChecksFrequency;
        this.support.firePropertyChange("managerChecksFrequency", (Object)oldManagerChecksFrequency, (Object)this.managerChecksFrequency);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public void setJvmRoute(String jvmRoute) {
        this.jvmRoute = jvmRoute;
    }

    public String getJvmRoute() {
        return this.jvmRoute;
    }

    public String getEngineName() {
        if (this.engineName != null) {
            return this.engineName;
        }
        return this.domain;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String j2EEApplication) {
        this.j2EEApplication = j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String j2EEServer) {
        this.j2EEServer = j2EEServer;
    }

    @Override
    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    @Override
    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.required"));
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(sm.getString("standardContext.loginConfig.loginWarning", loginPage));
                }
                config.setLoginPage("/" + loginPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.loginPage", loginPage));
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(sm.getString("standardContext.loginConfig.errorWarning", errorPage));
                }
                config.setErrorPage("/" + errorPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.errorPage", errorPage));
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public NamingResources getNamingResources() {
        return this.namingResources;
    }

    @Override
    public void setNamingResources(NamingResources namingResources) {
        NamingResources oldNamingResources = this.namingResources;
        this.namingResources = namingResources;
        this.support.firePropertyChange("namingResources", oldNamingResources, this.namingResources);
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public void setPath(String path) {
        this.setName(RequestUtil.URLDecode(path, "UTF-8"));
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Setting deployment descriptor public ID to '" + publicId + "'");
        }
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public boolean getOverride() {
        return this.override;
    }

    public String getOriginalDocBase() {
        return this.originalDocBase;
    }

    public void setOriginalDocBase(String docBase) {
        this.originalDocBase = docBase;
    }

    @Override
    public boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", (Object)oldPrivileged, (Object)this.privileged);
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    @Override
    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", (Object)oldOverride, (Object)this.override);
    }

    @Override
    public boolean isJsfApplication() {
        return this.isJsfApplication;
    }

    @Override
    public boolean hasAdHocPaths() {
        return false;
    }

    @Override
    public String getAdHocServletName(String path) {
        return null;
    }

    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", (Object)oldReplaceWelcomeFiles, (Object)this.replaceWelcomeFiles);
    }

    @Override
    public boolean isSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    @Override
    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        boolean oldSecurePagesWithPragma = this.securePagesWithPragma;
        this.securePagesWithPragma = securePagesWithPragma;
        this.support.firePropertyChange("securePagesWithPragma", (Object)oldSecurePagesWithPragma, (Object)this.securePagesWithPragma);
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
    }

    public boolean isUseMyFaces() {
        return this.useMyFaces;
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this.getBasePath(this.getDocBase()), this.getAlternateDocBases(), this);
            if (this.altDDName != null && this.context.getAttribute("org.apache.catalina.deploy.alt_dd") == null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
                this.context.setAttributeReadOnly("org.apache.catalina.deploy.alt_dd");
            }
        }
        return this.context.getFacade();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isSessionTimeoutOveridden() {
        return this.sessionTimeoutOveridden;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout == 0 ? -1 : timeout;
        this.support.firePropertyChange("sessionTimeout", (Object)oldSessionTimeout, (Object)this.sessionTimeout);
        this.sessionTimeoutOveridden = true;
    }

    public boolean getUnpackWAR() {
        return this.unpackWAR;
    }

    public void setUnpackWAR(boolean unpackWAR) {
        this.unpackWAR = unpackWAR;
    }

    @Override
    public String getWrapperClass() {
        return this.wrapperClassName;
    }

    @Override
    public void setWrapperClass(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
        try {
            this.wrapperClass = Class.forName(wrapperClassName);
            if (!StandardWrapper.class.isAssignableFrom(this.wrapperClass)) {
                throw new IllegalArgumentException(sm.getString("standardContext.invalidWrapperClass", wrapperClassName));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe);
        }
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(sm.getString("standardContext.resources.started"));
        }
        DirContext oldResources = this.webappResources;
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            BaseDirContext baseDirContext = (BaseDirContext)resources;
            baseDirContext.setCached(this.isCachingAllowed());
            baseDirContext.setCacheTTL(this.getCacheTTL());
            baseDirContext.setCacheMaxSize(this.getCacheMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            FileDirContext fileDirContext = (FileDirContext)resources;
            fileDirContext.setCaseSensitive(this.isCaseSensitive());
            fileDirContext.setAllowLinking(this.isAllowLinking());
        }
        this.webappResources = resources;
        this.resources = null;
        this.support.firePropertyChange("resources", oldResources, this.webappResources);
    }

    private synchronized void setAlternateResources(AlternateDocBase alternateDocBase, DirContext resources) {
        if (this.started) {
            throw new IllegalStateException(sm.getString("standardContext.resources.started"));
        }
        DirContext oldResources = alternateDocBase.getWebappResources();
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setCaseSensitive(this.isCaseSensitive());
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        alternateDocBase.setWebappResources(resources);
        alternateDocBase.setResources(null);
    }

    @Override
    public boolean getReuseSessionID() {
        return this.reuseSessionID;
    }

    @Override
    public void setReuseSessionID(boolean reuse) {
        this.reuseSessionID = reuse;
    }

    @Override
    public boolean getAllowRelativeRedirect() {
        return this.allowRelativeRedirect;
    }

    @Override
    public void setAllowRelativeRedirect(boolean allowRelativeURLs) {
        this.allowRelativeRedirect = allowRelativeURLs;
    }

    @Override
    public Auditor[] getAuditors() {
        return this.auditors;
    }

    @Override
    public void setAuditors(Auditor[] auditor) {
        this.auditors = auditor;
    }

    public void setReload(boolean isReload) {
        this.isReload = isReload;
    }

    public boolean isReload() {
        return this.isReload;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getWorkPath() {
        if (this.getWorkDir() == null) {
            return null;
        }
        File workDir = new File(this.getWorkDir());
        if (!workDir.isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                workDir = new File(catalinaHomePath, this.getWorkDir());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return workDir.getAbsolutePath();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        if (this.started) {
            this.postWorkDirectory();
        }
    }

    @Override
    public void addApplicationListener(String listener) {
        if (this.applicationListeners.contains(listener)) {
            if (log.isLoggable(Level.INFO)) {
                log.info(sm.getString("standardContext.duplicateListener", listener));
            }
            return;
        }
        if ("com.sun.faces.config.ConfigureListener".equals(listener)) {
            this.applicationListeners.add(0, listener);
        } else {
            this.applicationListeners.add(listener);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addApplicationListener", listener);
        }
    }

    @Override
    public void addApplicationParameter(ApplicationParameter parameter) {
        String newName = parameter.getName();
        for (ApplicationParameter applicationParameter : this.applicationParameters) {
            if (!newName.equals(applicationParameter.getName())) continue;
            if (applicationParameter.getOverride()) {
                applicationParameter.setValue(parameter.getValue());
            }
            return;
        }
        this.applicationParameters.add(parameter);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addApplicationParameter", parameter);
        }
    }

    @Override
    public void addChild(Container child) {
        this.addChild(child, false);
    }

    protected void addChild(Container child, boolean isProgrammatic) {
        String[] mappings;
        String jspFile;
        boolean isJspServlet;
        Wrapper oldJspServlet = null;
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        Wrapper wrapper = (Wrapper)child;
        String wrapperName = child.getName();
        if ("javax.faces.webapp.FacesServlet".equals(wrapper.getServletClassName())) {
            this.isJsfApplication = true;
        }
        if ((isJspServlet = "jsp".equals(wrapperName)) && (oldJspServlet = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(oldJspServlet);
        }
        if ((jspFile = wrapper.getJspFile()) != null && !jspFile.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(sm.getString("standardContext.wrapper.warning", jspFile));
                }
                wrapper.setJspFile("/" + jspFile);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.wrapper.error", jspFile));
            }
        }
        super.addChild(child);
        for (String mapping : mappings = wrapper.findMappings()) {
            this.addServletMapping(mapping, wrapperName, false);
        }
        if (this.getAvailable() && wrapper instanceof StandardWrapper) {
            ((StandardWrapper)wrapper).registerJMX(this);
        }
        if (isJspServlet && oldJspServlet != null) {
            String[] jspMappings = oldJspServlet.findMappings();
            for (int i = 0; jspMappings != null && i < jspMappings.length; ++i) {
                this.addServletMapping(jspMappings[i], wrapperName);
            }
        }
        ServletRegistrationImpl regis = null;
        regis = isProgrammatic ? new DynamicServletRegistrationImpl((StandardWrapper)wrapper, this) : new ServletRegistrationImpl((StandardWrapper)wrapper, this);
        this.servletRegisMap.put(wrapperName, regis);
    }

    @Override
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections;
        for (SecurityCollection collection : collections = constraint.findCollections()) {
            String[] patterns = collection.findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (this.validateURLPattern(patterns[j])) continue;
                throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.pattern", patterns[j]));
            }
        }
        this.constraints.add(constraint);
    }

    @Override
    public void addEjb(ContextEjb ejb) {
        this.namingResources.addEjb(ejb);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addEjb", ejb.getName());
        }
    }

    @Override
    public void addEnvironment(ContextEnvironment environment) {
        ContextEnvironment env = this.findEnvironment(environment.getName());
        if (env != null && !env.getOverride()) {
            return;
        }
        this.namingResources.addEnvironment(environment);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addEnvironment", environment.getName());
        }
    }

    public void addResourceParams(ResourceParams resourceParameters) {
        this.namingResources.addResourceParams(resourceParameters);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceParams", resourceParameters.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.errorPage.required"));
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(sm.getString("standardContext.errorPage.warning", location));
                }
                errorPage.setLocation("/" + location);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.errorPage.error", location));
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            Map<String, ErrorPage> map = this.exceptionPages;
            synchronized (map) {
                this.exceptionPages.put(exceptionType, errorPage);
            }
        } else if (errorPage.getErrorCode() > 0) {
            Map<Integer, ErrorPage> map = this.statusPages;
            synchronized (map) {
                int errorCode = errorPage.getErrorCode();
                if (errorCode >= 400 && errorCode < 600) {
                    this.statusPages.put(errorCode, errorPage);
                } else {
                    log.severe(sm.getString("standardContext.invalidErrorPageCode", errorCode));
                }
            }
        } else {
            this.defaultErrorPage = errorPage;
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addErrorPage", errorPage);
        }
    }

    @Override
    public void addFilterDef(FilterDef filterDef) {
        this.addFilterDef(filterDef, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterDef(FilterDef filterDef, boolean isProgrammatic) {
        FilterRegistrationImpl regis = null;
        regis = isProgrammatic ? new DynamicFilterRegistrationImpl(filterDef, this) : new FilterRegistrationImpl(filterDef, this);
        this.filterRegisMap.put(filterDef.getFilterName(), regis);
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addFilterDef", filterDef);
        }
    }

    public void addFilterMaps(FilterMaps filterMaps) {
        FilterMap fmap;
        String[] servletNames = filterMaps.getServletNames();
        String[] urlPatterns = filterMaps.getURLPatterns();
        for (String servletName : servletNames) {
            fmap = new FilterMap();
            fmap.setFilterName(filterMaps.getFilterName());
            fmap.setServletName(servletName);
            fmap.setDispatcherTypes(filterMaps.getDispatcherTypes());
            this.addFilterMap(fmap);
        }
        for (String urlPattern : urlPatterns) {
            fmap = new FilterMap();
            fmap.setFilterName(filterMaps.getFilterName());
            fmap.setURLPattern(urlPattern);
            fmap.setDispatcherTypes(filterMaps.getDispatcherTypes());
            this.addFilterMap(fmap);
        }
    }

    @Override
    public void addFilterMap(FilterMap filterMap) {
        this.addFilterMap(filterMap, true);
    }

    public void addFilterMap(FilterMap filterMap, boolean isMatchAfter) {
        String filterName = filterMap.getFilterName();
        String servletName = filterMap.getServletName();
        String urlPattern = filterMap.getURLPattern();
        if (this.findFilterDef(filterName) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.name", filterName));
        }
        if (servletName == null && urlPattern == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        if (servletName != null && urlPattern != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        if (urlPattern != null && !this.validateURLPattern(urlPattern)) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.pattern", urlPattern));
        }
        if (isMatchAfter) {
            this.filterMaps.add(filterMap);
        } else {
            this.filterMaps.add(0, filterMap);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addFilterMap", filterMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getServletNameFilterMappings(String filterName) {
        HashSet<String> mappings = new HashSet<String>();
        List<FilterMap> list = this.filterMaps;
        synchronized (list) {
            for (FilterMap fm : this.filterMaps) {
                if (!filterName.equals(fm.getFilterName()) || fm.getServletName() == null) continue;
                mappings.add(fm.getServletName());
            }
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getUrlPatternFilterMappings(String filterName) {
        HashSet<String> mappings = new HashSet<String>();
        List<FilterMap> list = this.filterMaps;
        synchronized (list) {
            for (FilterMap fm : this.filterMaps) {
                if (!filterName.equals(fm.getFilterName()) || fm.getURLPattern() == null) continue;
                mappings.add(fm.getURLPattern());
            }
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            if (this.findFilterDef(filterName) != null) {
                return null;
            }
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClassName(className);
            this.addFilterDef(filterDef, true);
            return (FilterRegistration.Dynamic)this.filterRegisMap.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (filterName == null || filter == null) {
            throw new NullPointerException("Null filter instance or name");
        }
        Container host = this.getParent();
        if (host != null) {
            for (Container child : host.findChildren()) {
                if (child == this || !((StandardContext)child).hasFilter(filter)) continue;
                return null;
            }
        }
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            for (Map.Entry<String, FilterDef> e : this.filterDefs.entrySet()) {
                if (!filterName.equals(e.getKey()) && filter != e.getValue().getFilter()) continue;
                return null;
            }
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilter(filter);
            this.addFilterDef(filterDef, true);
            return (FilterRegistration.Dynamic)this.filterRegisMap.get(filterName);
        }
    }

    public boolean hasFilter(Filter filter) {
        for (Map.Entry<String, FilterDef> e : this.filterDefs.entrySet()) {
            if (filter != e.getValue().getFilter()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            if (this.findFilterDef(filterName) != null) {
                return null;
            }
            FilterDef filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClass(filterClass);
            this.addFilterDef(filterDef, true);
            return (FilterRegistration.Dynamic)this.filterRegisMap.get(filterName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        Filter filter = null;
        boolean beforeInitCalled = false;
        try {
            try {
                filter = (Filter)c.newInstance();
                this.fireContainerEvent("beforeFilterInitialized", filter);
                beforeInitCalled = true;
            }
            catch (Throwable t) {
                throw new ServletException("Unable to create Filter from class " + c.getName(), t);
            }
            Object var6_4 = null;
            if (!beforeInitCalled) return (T)filter;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (!beforeInitCalled) throw throwable;
            this.fireContainerEvent("afterFilterInitialized", filter);
            throw throwable;
        }
        this.fireContainerEvent("afterFilterInitialized", filter);
        return (T)filter;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.filterRegisMap.get(filterName);
    }

    public Map<String, FilterRegistration> getFilterRegistrations() {
        return Collections.unmodifiableMap(this.filterRegisMap);
    }

    @Override
    public synchronized SessionCookieConfig getSessionCookieConfig() {
        if (this.sessionCookieConfig == null) {
            this.sessionCookieConfig = new SessionCookieConfigImpl(this);
        }
        return this.sessionCookieConfig;
    }

    public void setSessionCookieConfigInitialized(boolean initialized) {
        this.sessionCookieConfigInitialized = initialized;
    }

    @Override
    public boolean isSessionCookieConfigInitialized() {
        return this.sessionCookieConfigInitialized;
    }

    void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    @Override
    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            throw new IllegalArgumentException(sm.getString("applicationContext.sessionTrackingModes.iae.unsupported", (Object)SessionTrackingMode.SSL, this.getName()));
        }
        if (this.isContextInitializedCalled) {
            throw new IllegalStateException(sm.getString("applicationContext.sessionTrackingModes.initialized", this.getName()));
        }
        this.sessionTrackingModes = sessionTrackingModes;
        if (sessionTrackingModes.contains(SessionTrackingMode.COOKIE)) {
            this.setCookies(true);
        } else {
            this.setCookies(false);
        }
        if (sessionTrackingModes.contains(SessionTrackingMode.URL)) {
            this.setEnableURLRewriting(true);
        } else {
            this.setEnableURLRewriting(false);
        }
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return DEFAULT_SESSION_TRACKING_MODES;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.sessionTrackingModes != null ? this.sessionTrackingModes : DEFAULT_SESSION_TRACKING_MODES;
    }

    @Override
    public void addInstanceListener(String listener) {
        this.instanceListeners.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addInstanceListener", listener);
        }
    }

    public void addInstanceListener(InstanceListener listener) {
        this.instanceListenerInstances.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addInstanceListener", listener);
        }
    }

    @Override
    public void addJspMapping(String pattern) {
        String servletName = this.findServletMapping("*.jsp");
        if (servletName == null) {
            servletName = "jsp";
        }
        if (this.findChild(servletName) != null) {
            this.addServletMapping(pattern, servletName, true);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Skipping " + pattern + " , no servlet " + servletName);
        }
    }

    @Override
    public void addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(locale, encoding);
    }

    @Override
    public void addLocalEjb(ContextLocalEjb ejb) {
        this.namingResources.addLocalEjb(ejb);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addLocalEjb", ejb.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestination(MessageDestination md) {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            this.messageDestinations.put(md.getName(), md);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMessageDestination", md.getName());
        }
    }

    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        this.namingResources.addMessageDestinationRef(mdr);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMessageDestinationRef", mdr.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMimeMapping(String extension, String mimeType) {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.put(extension, mimeType);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addMimeMapping", extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", name));
        }
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addParameter", name);
        }
    }

    @Override
    public void addResource(ContextResource resource) {
        this.namingResources.addResource(resource);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResource", resource.getName());
        }
    }

    @Override
    public void addResourceEnvRef(String name, String type) {
        this.namingResources.addResourceEnvRef(name, type);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceEnvRef", name);
        }
    }

    @Override
    public void addResourceLink(ContextResourceLink resourceLink) {
        this.namingResources.addResourceLink(resourceLink);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addResourceLink", resourceLink.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoleMapping(String role, String link) {
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            this.roleMappings.put(role, link);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addRoleMapping", role);
        }
    }

    @Override
    public void addSecurityRole(String role) {
        this.securityRoles.add(role);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addSecurityRole", role);
        }
    }

    public Set<String> addServletMapping(ServletMap servletMap) {
        return this.addServletMapping(servletMap.getServletName(), servletMap.getUrlPatterns());
    }

    public Set<String> addServletMapping(String name, String[] urlPatterns) {
        HashSet<String> conflicts = null;
        for (String urlPattern : urlPatterns) {
            if (!this.hasServletMapping(urlPattern)) continue;
            if (conflicts == null) {
                conflicts = new HashSet<String>();
            }
            conflicts.add(urlPattern);
        }
        if (conflicts == null) {
            for (String urlPattern : urlPatterns) {
                this.addServletMapping(urlPattern, name, false);
            }
            return Collections.EMPTY_SET;
        }
        return conflicts;
    }

    @Override
    public void addServletMapping(String pattern, String name) {
        this.addServletMapping(pattern, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletMapping(String pattern, String name, boolean jspWildCard) {
        if (this.findChild(name) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.name", name));
        }
        if (!this.validateURLPattern(pattern = this.adjustURLPattern(RequestUtil.URLDecode(pattern)))) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.pattern", pattern));
        }
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            String name2 = this.servletMappings.get(pattern);
            if (name2 != null && !name.equals("default")) {
                Wrapper wrapper = (Wrapper)this.findChild(name2);
                wrapper.removeMapping(pattern);
                this.mapper.removeWrapper(pattern);
            }
            if (name2 == null || !name.equals("default")) {
                this.servletMappings.put(pattern, name);
            }
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        wrapper.addMapping(pattern);
        this.mapper.addWrapper(pattern, (Object)wrapper, jspWildCard);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addServletMapping", pattern);
        }
    }

    private boolean hasServletMapping(String pattern) {
        return this.servletMappings.get(pattern) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        Map map = this.children;
        synchronized (map) {
            if (this.findChild(servletName) == null) {
                Wrapper wrapper = this.createWrapper();
                wrapper.setName(servletName);
                wrapper.setServletClassName(className);
                this.addChild(wrapper, true);
                return (ServletRegistration.Dynamic)this.servletRegisMap.get(servletName);
            }
            return null;
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.addServlet(servletName, servlet, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        Map map = this.children;
        synchronized (map) {
            if (this.findChild(servletName) == null) {
                Wrapper wrapper = this.createWrapper();
                wrapper.setName(servletName);
                wrapper.setServletClass(servletClass);
                this.addChild(wrapper, true);
                return (ServletRegistration.Dynamic)this.servletRegisMap.get(servletName);
            }
            return null;
        }
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet instance, Map<String, String> initParams) {
        return this.addServlet(servletName, instance, initParams, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet, Map<String, String> initParams, String ... urlPatterns) {
        if (servletName == null || servlet == null) {
            throw new NullPointerException("Null servlet instance or name");
        }
        if (servlet instanceof SingleThreadModel) {
            throw new IllegalArgumentException("Servlet implements " + SingleThreadModel.class.getName());
        }
        Container host = this.getParent();
        if (host != null) {
            for (Container child : host.findChildren()) {
                if (child == this || !((StandardContext)child).hasServlet(servlet)) continue;
                return null;
            }
        }
        Map map = this.children;
        synchronized (map) {
            for (Map.Entry e : this.children.entrySet()) {
                if (!servletName.equals(e.getKey()) && servlet != ((StandardWrapper)e.getValue()).getServlet()) continue;
                return null;
            }
            StandardWrapper wrapper = (StandardWrapper)this.createWrapper();
            if (initParams != null) {
                for (Map.Entry<String, String> e : initParams.entrySet()) {
                    wrapper.addInitParameter(e.getKey(), e.getValue());
                }
            }
            wrapper.setName(servletName);
            wrapper.setServlet(servlet);
            if (urlPatterns != null) {
                for (String urlPattern : urlPatterns) {
                    wrapper.addMapping(urlPattern);
                }
            }
            this.addChild(wrapper, true);
            return (ServletRegistration.Dynamic)this.servletRegisMap.get(servletName);
        }
    }

    public boolean hasServlet(Servlet servlet) {
        for (Map.Entry e : this.children.entrySet()) {
            if (servlet != ((StandardWrapper)e.getValue()).getServlet()) continue;
            return true;
        }
        return false;
    }

    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        Servlet servlet = null;
        boolean beforeInitCalled = false;
        StandardWrapper wrapper = null;
        try {
            try {
                servlet = (Servlet)c.newInstance();
                wrapper = (StandardWrapper)this.createWrapper();
                wrapper.setServlet(servlet);
                wrapper.getInstanceSupport().fireInstanceEvent(InstanceEvent.EventType.BEFORE_INIT_EVENT, servlet);
                beforeInitCalled = true;
            }
            catch (Throwable t) {
                throw new ServletException("Unable to create Servlet from class " + c.getName(), t);
            }
            Object var7_5 = null;
            if (beforeInitCalled) {
                wrapper.getInstanceSupport().fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet);
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (beforeInitCalled) {
                wrapper.getInstanceSupport().fireInstanceEvent(InstanceEvent.EventType.AFTER_INIT_EVENT, servlet);
            }
            throw throwable;
        }
        return (T)servlet;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.servletRegisMap.get(servletName);
    }

    public Map<String, ServletRegistration> getServletRegistrations() {
        return Collections.unmodifiableMap(this.servletRegisMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaglib(String uri, String location) {
        Map<String, String> map = this.taglibs;
        synchronized (map) {
            this.taglibs.put(uri, location);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addTaglib", uri);
        }
    }

    @Override
    public void addWatchedResource(String name) {
        this.watchedResources.add(name);
        this.fireContainerEvent("addWatchedResource", name);
    }

    @Override
    public void addWelcomeFile(String name) {
        if (this.replaceWelcomeFiles) {
            this.welcomeFiles = new String[0];
            this.setReplaceWelcomeFiles(false);
        }
        String[] results = new String[this.welcomeFiles.length + 1];
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            results[i] = this.welcomeFiles[i];
        }
        results[this.welcomeFiles.length] = name;
        this.welcomeFiles = results;
        this.postWelcomeFiles();
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addWelcomeFile", name);
        }
    }

    @Override
    public void addWrapperLifecycle(String listener) {
        this.wrapperLifecycles.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addWrapperLifecycle", listener);
        }
    }

    @Override
    public void addWrapperListener(String listener) {
        this.wrapperListeners.add(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("addWrapperListener", listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wrapper createWrapper() {
        Class<?> clazz;
        Wrapper wrapper = null;
        if (this.wrapperClass != null) {
            try {
                wrapper = (Wrapper)this.wrapperClass.newInstance();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, sm.getString("standardContext.createWrapperInstance", this.wrapperClassName), t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        List<Object> t = this.instanceListeners;
        synchronized (t) {
            for (String instanceListener : this.instanceListeners) {
                try {
                    Class<?> clazz2 = Class.forName(instanceListener);
                    wrapper.addInstanceListener((InstanceListener)clazz2.newInstance());
                }
                catch (Throwable t2) {
                    log.log(Level.SEVERE, sm.getString("standardContext.instanceListener", instanceListener), t2);
                    return null;
                }
            }
        }
        t = this.instanceListenerInstances;
        synchronized (t) {
            for (InstanceListener instanceListenerInstance : this.instanceListenerInstances) {
                wrapper.addInstanceListener(instanceListenerInstance);
            }
        }
        for (String wrapperLifecycle : this.wrapperLifecycles) {
            try {
                clazz = Class.forName(wrapperLifecycle);
                if (!(wrapper instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)wrapper)).addLifecycleListener((LifecycleListener)clazz.newInstance());
            }
            catch (Throwable t3) {
                log.log(Level.SEVERE, sm.getString("standardContext.lifecycleListener", wrapperLifecycle), t3);
                return null;
            }
        }
        for (String wrapperListener : this.wrapperListeners) {
            try {
                clazz = Class.forName(wrapperListener);
                wrapper.addContainerListener((ContainerListener)clazz.newInstance());
            }
            catch (Throwable t4) {
                log.log(Level.SEVERE, sm.getString("standardContext.containerListener", wrapperListener), t4);
                return null;
            }
        }
        return wrapper;
    }

    @Override
    public List<String> findApplicationListeners() {
        return this.applicationListeners;
    }

    @Override
    public List<ApplicationParameter> findApplicationParameters() {
        return this.applicationParameters;
    }

    @Override
    public List<SecurityConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    @Override
    public ContextEjb findEjb(String name) {
        return this.namingResources.findEjb(name);
    }

    @Override
    public ContextEjb[] findEjbs() {
        return this.namingResources.findEjbs();
    }

    @Override
    public ContextEnvironment findEnvironment(String name) {
        return this.namingResources.findEnvironment(name);
    }

    @Override
    public ContextEnvironment[] findEnvironments() {
        return this.namingResources.findEnvironments();
    }

    @Override
    public ErrorPage findErrorPage(int errorCode) {
        if (errorCode >= 400 && errorCode < 600) {
            return this.statusPages.get(errorCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage findErrorPage(String exceptionType) {
        Map<String, ErrorPage> map = this.exceptionPages;
        synchronized (map) {
            return this.exceptionPages.get(exceptionType);
        }
    }

    @Override
    public ErrorPage getDefaultErrorPage() {
        return this.defaultErrorPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage[] findErrorPages() {
        Map<String, ErrorPage> map = this.exceptionPages;
        synchronized (map) {
            Map<Integer, ErrorPage> map2 = this.statusPages;
            synchronized (map2) {
                int i;
                ErrorPage[] results1 = new ErrorPage[this.exceptionPages.size()];
                results1 = this.exceptionPages.values().toArray(results1);
                ErrorPage[] results2 = new ErrorPage[this.statusPages.size()];
                results2 = this.statusPages.values().toArray(results2);
                ErrorPage[] results = new ErrorPage[results1.length + results2.length];
                for (i = 0; i < results1.length; ++i) {
                    results[i] = results1[i];
                }
                for (i = results1.length; i < results.length; ++i) {
                    results[i] = results2[i - results1.length];
                }
                return results;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef findFilterDef(String filterName) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            return this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef[] findFilterDefs() {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    @Override
    public List<FilterMap> findFilterMaps() {
        return this.filterMaps;
    }

    @Override
    public List<String> findInstanceListeners() {
        return this.instanceListeners;
    }

    @Override
    public ContextLocalEjb findLocalEjb(String name) {
        return this.namingResources.findLocalEjb(name);
    }

    @Override
    public ContextLocalEjb[] findLocalEjbs() {
        return this.namingResources.findLocalEjbs();
    }

    public Context findMappingObject() {
        return (Context)this.getMappingObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination findMessageDestination(String name) {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            return this.messageDestinations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination[] findMessageDestinations() {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            return this.messageDestinations.values().toArray(new MessageDestination[this.messageDestinations.size()]);
        }
    }

    public MessageDestinationRef findMessageDestinationRef(String name) {
        return this.namingResources.findMessageDestinationRef(name);
    }

    public MessageDestinationRef[] findMessageDestinationRefs() {
        return this.namingResources.findMessageDestinationRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findMimeMapping(String extension) {
        String mimeType = this.mimeMappings.get(extension);
        if (mimeType == null) {
            HashMap<String, String> hashMap = this.mimeMappings;
            synchronized (hashMap) {
                for (String ext : this.mimeMappings.keySet()) {
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    mimeType = this.mimeMappings.get(ext);
                    this.mimeMappings.put(extension, mimeType);
                    break;
                }
            }
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findMimeMappings() {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            return this.mimeMappings.keySet().toArray(new String[this.mimeMappings.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            return this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findParameters() {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            return this.parameters.keySet().toArray(new String[this.parameters.size()]);
        }
    }

    @Override
    public ContextResource findResource(String name) {
        return this.namingResources.findResource(name);
    }

    @Override
    public String findResourceEnvRef(String name) {
        return this.namingResources.findResourceEnvRef(name);
    }

    @Override
    public String[] findResourceEnvRefs() {
        return this.namingResources.findResourceEnvRefs();
    }

    @Override
    public ContextResourceLink findResourceLink(String name) {
        return this.namingResources.findResourceLink(name);
    }

    @Override
    public ContextResourceLink[] findResourceLinks() {
        return this.namingResources.findResourceLinks();
    }

    @Override
    public ContextResource[] findResources() {
        return this.namingResources.findResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findRoleMapping(String role) {
        String realRole = null;
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            realRole = this.roleMappings.get(role);
        }
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    @Override
    public boolean hasSecurityRole(String role) {
        return this.securityRoles.contains(role);
    }

    @Override
    public void removeSecurityRoles() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.securityRoles.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeSecurityRole", i.next());
            }
        }
        this.securityRoles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findServletMapping(String pattern) {
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            return this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findServletMappings() {
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            String[] results = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(results);
        }
    }

    @Override
    public ErrorPage findStatusPage(int status) {
        return this.statusPages.get(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] findStatusPages() {
        Map<Integer, ErrorPage> map = this.statusPages;
        synchronized (map) {
            int[] results = new int[this.statusPages.size()];
            Iterator<Integer> elements = this.statusPages.keySet().iterator();
            int i = 0;
            while (elements.hasNext()) {
                results[i++] = elements.next();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findTaglib(String uri) {
        Map<String, String> map = this.taglibs;
        synchronized (map) {
            return this.taglibs.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findTaglibs() {
        Map<String, String> map = this.taglibs;
        synchronized (map) {
            String[] results = new String[this.taglibs.size()];
            return this.taglibs.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findWelcomeFile(String name) {
        String[] stringArray = this.welcomeFiles;
        synchronized (this.welcomeFiles) {
            for (String welcomeFile : this.welcomeFiles) {
                if (!name.equals(welcomeFile)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public List<String> getWatchedResources() {
        return this.watchedResources;
    }

    @Override
    public String[] findWelcomeFiles() {
        return this.welcomeFiles;
    }

    @Override
    public List<String> findWrapperLifecycles() {
        return this.wrapperLifecycles;
    }

    @Override
    public List<String> findWrapperListeners() {
        return this.wrapperListeners;
    }

    @Override
    public Authenticator getAuthenticator() {
        Pipeline p = this.getPipeline();
        if (p != null) {
            for (GlassFishValve valve : p.getValves()) {
                if (!(valve instanceof Authenticator)) continue;
                return (Authenticator)((Object)valve);
            }
        }
        return null;
    }

    @Override
    public synchronized void reload() {
        if (!this.started) {
            throw new IllegalStateException(sm.getString("containerBase.notStarted", this.logName()));
        }
        log.info(sm.getString("standardContext.reloadingStarted"));
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            log.log(Level.SEVERE, sm.getString("standardContext.stoppingContext", this), e);
        }
        try {
            this.start();
        }
        catch (LifecycleException e) {
            log.log(Level.SEVERE, sm.getString("standardContext.startingContext", this), e);
        }
        this.setPaused(false);
    }

    @Override
    public void removeApplicationListeners() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.applicationListeners.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeApplicationListener", i.next());
            }
        }
        this.applicationListeners.clear();
    }

    @Override
    public void removeApplicationParameter(String name) {
        ApplicationParameter match = null;
        for (ApplicationParameter applicationParameter : this.applicationParameters) {
            if (!name.equals(applicationParameter.getName())) continue;
            match = applicationParameter;
            break;
        }
        if (match != null) {
            this.applicationParameters.remove(match);
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeApplicationParameter", name);
            }
        }
    }

    @Override
    public void removeChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        super.removeChild(child);
    }

    @Override
    public void removeConstraints() {
        if (this.notifyContainerListeners) {
            Iterator<SecurityConstraint> i = this.constraints.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeConstraint", i.next());
            }
        }
        this.constraints.clear();
    }

    @Override
    public void removeEjb(String name) {
        this.namingResources.removeEjb(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeEjb", name);
        }
    }

    @Override
    public void removeEnvironment(String name) {
        if (this.namingResources == null) {
            return;
        }
        ContextEnvironment env = this.namingResources.findEnvironment(name);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + name + "'");
        }
        this.namingResources.removeEnvironment(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeEnvironment", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeErrorPage(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType != null) {
            Map<String, ErrorPage> map = this.exceptionPages;
            synchronized (map) {
                this.exceptionPages.remove(exceptionType);
            }
        }
        Map<Integer, ErrorPage> map = this.statusPages;
        synchronized (map) {
            this.statusPages.remove(errorPage.getErrorCode());
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeErrorPage", errorPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterDef(FilterDef filterDef) {
        Map<String, FilterDef> map = this.filterDefs;
        synchronized (map) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeFilterDef", filterDef);
        }
    }

    @Override
    public void removeFilterMaps() {
        if (this.notifyContainerListeners) {
            Iterator<FilterMap> i = this.filterMaps.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeFilterMap", i.next());
            }
        }
        this.filterMaps.clear();
    }

    @Override
    public void removeInstanceListener(String listener) {
        this.instanceListeners.remove(listener);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeInstanceListener", listener);
        }
    }

    @Override
    public void removeLocalEjb(String name) {
        this.namingResources.removeLocalEjb(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeLocalEjb", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestination(String name) {
        Map<String, MessageDestination> map = this.messageDestinations;
        synchronized (map) {
            this.messageDestinations.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMessageDestination", name);
        }
    }

    public void removeMessageDestinationRef(String name) {
        this.namingResources.removeMessageDestinationRef(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMessageDestinationRef", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMimeMapping(String extension) {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.remove(extension);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeMimeMapping", extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeParameter", name);
        }
    }

    @Override
    public void removeResource(String resourceName) {
        String decoded = URLDecoder.decode(resourceName);
        if (this.namingResources == null) {
            return;
        }
        ContextResource resource = this.namingResources.findResource(decoded);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + decoded + "'");
        }
        this.namingResources.removeResource(decoded);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResource", decoded);
        }
    }

    @Override
    public void removeResourceEnvRef(String name) {
        this.namingResources.removeResourceEnvRef(name);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResourceEnvRef", name);
        }
    }

    @Override
    public void removeResourceLink(String link) {
        String decoded = URLDecoder.decode(link);
        if (this.namingResources == null) {
            return;
        }
        ContextResourceLink resource = this.namingResources.findResourceLink(decoded);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + decoded + "'");
        }
        this.namingResources.removeResourceLink(decoded);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeResourceLink", decoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoleMapping(String role) {
        Map<String, String> map = this.roleMappings;
        synchronized (map) {
            this.roleMappings.remove(role);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeRoleMapping", role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServletMapping(String pattern) {
        String name = null;
        Map<String, String> map = this.servletMappings;
        synchronized (map) {
            name = this.servletMappings.remove(pattern);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper != null) {
            wrapper.removeMapping(pattern);
        }
        this.mapper.removeWrapper(pattern);
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeServletMapping", pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaglib(String uri) {
        Map<String, String> map = this.taglibs;
        synchronized (map) {
            this.taglibs.remove(uri);
        }
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeTaglib", uri);
        }
    }

    @Override
    public boolean hasWatchedResources() {
        return !this.watchedResources.isEmpty();
    }

    @Override
    public void removeWatchedResources() {
        this.watchedResources.clear();
    }

    @Override
    public void removeWatchedResource(String name) {
        String match = null;
        for (String watchedResource : this.watchedResources) {
            if (!name.equals(watchedResource)) continue;
            match = watchedResource;
            break;
        }
        if (match != null) {
            this.watchedResources.remove(match);
            if (this.notifyContainerListeners) {
                this.fireContainerEvent("removeWatchedResource", name);
            }
        }
    }

    @Override
    public void removeWelcomeFile(String name) {
        int n = -1;
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            if (!this.welcomeFiles[i].equals(name)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.welcomeFiles.length - 1];
        for (int i = 0; i < this.welcomeFiles.length; ++i) {
            if (i == n) continue;
            results[j++] = this.welcomeFiles[i];
        }
        this.welcomeFiles = results;
        this.postWelcomeFiles();
        if (this.notifyContainerListeners) {
            this.fireContainerEvent("removeWelcomeFile", name);
        }
    }

    @Override
    public void removeWrapperLifecycles() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.wrapperLifecycles.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeWrapperLifecycle", i.next());
            }
        }
        this.wrapperLifecycles.clear();
    }

    @Override
    public void removeWrapperListeners() {
        if (this.notifyContainerListeners) {
            Iterator<String> i = this.wrapperListeners.iterator();
            while (i.hasNext()) {
                this.fireContainerEvent("removeWrapperListener", i.next());
            }
        }
        this.wrapperListeners.clear();
    }

    public long getProcessingTimeMillis() {
        long result = 0L;
        for (Container child : this.findChildren()) {
            result += ((StandardWrapper)child).getProcessingTimeMillis();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting filters");
        }
        boolean ok = true;
        Map<String, FilterConfig> map = this.filterConfigs;
        synchronized (map) {
            this.filterConfigs.clear();
            for (String name : this.filterDefs.keySet()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(" Starting filter '" + name + "'");
                }
                try {
                    this.filterConfigs.put(name, new ApplicationFilterConfig(this, this.filterDefs.get(name)));
                }
                catch (Throwable t) {
                    this.getServletContext().log(sm.getString("standardContext.filterStart", name), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stopping filters");
        }
        Map<String, FilterConfig> map = this.filterConfigs;
        synchronized (map) {
            for (String filterName : this.filterConfigs.keySet()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(" Stopping filter '" + filterName + "'");
                }
                ApplicationFilterConfig filterConfig = (ApplicationFilterConfig)this.filterConfigs.get(filterName);
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return this.filterConfigs.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean listenerStart() {
        Object[] instances;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Configuring application event listeners");
        }
        ClassLoader loader = this.getLoader().getClassLoader();
        List<String> listeners = this.findApplicationListeners();
        Object[] results = new Object[listeners.size()];
        boolean ok = true;
        Iterator<String> iter = listeners.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String listener = iter.next();
            try {
                results[i++] = this.loadListener(loader, listener);
            }
            catch (Throwable t) {
                this.getServletContext().log(sm.getString("standardContext.applicationListener", listener), t);
                ok = false;
            }
        }
        if (!ok) {
            log.severe(sm.getString("standardContext.applicationSkipped"));
            return false;
        }
        ArrayList<EventListener> eventListeners = new ArrayList<EventListener>();
        ArrayList<EventListener> lifecycleListeners = new ArrayList<EventListener>();
        for (Object result : results) {
            if (result instanceof ServletContextAttributeListener || result instanceof ServletRequestAttributeListener || result instanceof ServletRequestListener || result instanceof HttpSessionAttributeListener) {
                eventListeners.add((EventListener)result);
            }
            if (!(result instanceof ServletContextListener) && !(result instanceof HttpSessionListener)) continue;
            lifecycleListeners.add((EventListener)result);
        }
        this.setApplicationEventListeners(eventListeners.toArray());
        this.setApplicationLifecycleListeners(lifecycleListeners.toArray());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending application start events");
        }
        if ((instances = this.getApplicationLifecycleListeners()) == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (Object instance : instances) {
            Object var17_20;
            if (instance == null || !(instance instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)instance;
            try {
                this.fireContainerEvent("beforeContextInitialized", listener);
                listener.contextInitialized(event);
                var17_20 = null;
            }
            catch (Throwable throwable) {
                var17_20 = null;
                this.fireContainerEvent("afterContextInitialized", listener);
                throw throwable;
            }
            this.fireContainerEvent("afterContextInitialized", listener);
            {
            }
        }
        this.isContextInitializedCalled = true;
        return ok;
    }

    protected Object loadListener(ClassLoader loader, String listenerClassName) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine(" Configuring event listener class '" + listenerClassName + "'");
        }
        Class<?> clazz = loader.loadClass(listenerClassName);
        Object listener = clazz.newInstance();
        this.fireContainerEvent("afterListenerInstantiated", listener);
        return listener;
    }

    private boolean lifecycleListenerStop() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Sending application stop events");
        }
        boolean ok = true;
        Object[] listeners = this.getApplicationLifecycleListeners();
        if (listeners == null) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        for (int i = 0; i < listeners.length; ++i) {
            int j = listeners.length - 1 - i;
            if (listeners[j] == null) continue;
            if (!(listeners[j] instanceof ServletContextListener)) {
                this.fireContainerEvent("predestroy", listeners[j]);
                continue;
            }
            ServletContextListener listener = (ServletContextListener)listeners[j];
            try {
                this.fireContainerEvent("beforeContextDestroyed", listener);
                listener.contextDestroyed(event);
                this.fireContainerEvent("afterContextDestroyed", listener);
                continue;
            }
            catch (Throwable t) {
                this.fireContainerEvent("afterContextDestroyed", listener);
                this.getServletContext().log(sm.getString("standardContext.listenerStop", listeners[j].getClass().getName()), t);
                ok = false;
            }
        }
        this.setApplicationLifecycleListeners(null);
        return ok;
    }

    private boolean eventListenerStop() {
        boolean ok = true;
        Object[] eventListeners = this.getApplicationEventListeners();
        if (eventListeners == null) {
            return ok;
        }
        for (Object eventListener : eventListeners) {
            if (eventListener == null) continue;
            this.fireContainerEvent("predestroy", eventListener);
        }
        this.setApplicationEventListeners(null);
        return ok;
    }

    public boolean resourcesStart() {
        boolean ok = true;
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        try {
            ProxyDirContext proxyDirContext = new ProxyDirContext(env, this.webappResources);
            if (this.webappResources instanceof BaseDirContext) {
                ((BaseDirContext)this.webappResources).setDocBase(this.getBasePath(this.getDocBase()));
                ((BaseDirContext)this.webappResources).allocate();
            }
            if (this.isCachingAllowed()) {
                ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.encodedPath) ? "/" : this.encodedPath));
                Registry.getRegistry(null, null).registerComponent((Object)proxyDirContext.getCache(), resourcesName, null);
            }
            this.resources = proxyDirContext;
        }
        catch (Throwable t) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.SEVERE, sm.getString("standardContext.resourcesStart", this.getName()), t);
            } else {
                log.log(Level.SEVERE, sm.getString("standardContext.resourcesStart", this.getName()) + ": " + t.getMessage());
            }
            ok = false;
        }
        return ok;
    }

    public boolean alternateResourcesStart() {
        boolean ok = true;
        if (this.alternateDocBases == null || this.alternateDocBases.isEmpty()) {
            return ok;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        for (AlternateDocBase alternateDocBase : this.alternateDocBases) {
            String basePath = alternateDocBase.getBasePath();
            DirContext alternateWebappResources = alternateDocBase.getWebappResources();
            try {
                ProxyDirContext proxyDirContext = new ProxyDirContext(env, alternateWebappResources);
                if (alternateWebappResources instanceof BaseDirContext) {
                    ((BaseDirContext)alternateWebappResources).setDocBase(basePath);
                    ((BaseDirContext)alternateWebappResources).allocate();
                }
                alternateDocBase.setResources(proxyDirContext);
            }
            catch (Throwable t) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.SEVERE, sm.getString("standardContext.resourcesStart", this.getName()), t);
                } else {
                    log.log(Level.SEVERE, sm.getString("standardContext.resourcesStart", this.getName()) + ": " + t.getMessage());
                }
                ok = false;
            }
        }
        return ok;
    }

    public boolean resourcesStop() {
        boolean ok = true;
        try {
            if (this.resources != null) {
                if (this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).stop();
                }
                if (this.webappResources instanceof BaseDirContext) {
                    ((BaseDirContext)this.webappResources).release();
                }
                if (this.isCachingAllowed()) {
                    ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",path=" + ("".equals(this.getPath()) ? "/" : this.getPath()));
                    Registry.getRegistry(null, null).unregisterComponent(resourcesName);
                }
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, sm.getString("standardContext.resourcesStop"), t);
            ok = false;
        }
        this.resources = null;
        return ok;
    }

    public boolean alternateResourcesStop() {
        boolean ok = true;
        if (this.alternateDocBases == null || this.alternateDocBases.isEmpty()) {
            return ok;
        }
        for (AlternateDocBase alternateDocBase : this.alternateDocBases) {
            DirContext alternateWebappResources;
            ProxyDirContext alternateResources = alternateDocBase.getResources();
            if (alternateResources instanceof Lifecycle) {
                try {
                    ((Lifecycle)alternateResources).stop();
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, sm.getString("standardContext.resourcesStop"), t);
                    ok = false;
                }
            }
            if (!((alternateWebappResources = alternateDocBase.getWebappResources()) instanceof BaseDirContext)) continue;
            try {
                ((BaseDirContext)alternateWebappResources).release();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, sm.getString("standardContext.resourcesStop"), t);
                ok = false;
            }
        }
        this.alternateDocBases = null;
        return ok;
    }

    public void loadOnStartup(Container[] children) throws LifecycleException {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (Container aChildren : children) {
            Wrapper wrapper = (Wrapper)aChildren;
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            Integer key = loadOnStartup;
            ArrayList<Wrapper> list = (ArrayList<Wrapper>)map.get(key);
            if (list == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (Integer key : map.keySet()) {
            List list = (List)map.get(key);
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    this.getServletContext().log(sm.getString("standardWrapper.loadException", this.getName()), StandardWrapper.getRootCause(e));
                    throw new LifecycleException(StandardWrapper.getRootCause(e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws LifecycleException {
        String useNamingProperty;
        boolean ok;
        long startupTimeStart;
        block81: {
            Container host;
            if (this.started) {
                if (log.isLoggable(Level.INFO)) {
                    log.info(sm.getString("containerBase.alreadyStarted", this.logName()));
                }
                return;
            }
            startupTimeStart = System.currentTimeMillis();
            if (!this.initialized) {
                try {
                    this.init();
                }
                catch (Exception ex) {
                    throw new LifecycleException("Error initializaing ", ex);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Starting " + ("".equals(this.getName()) ? "ROOT" : this.getName()));
            }
            this.preRegisterJMX();
            if (this.oname != null && Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            this.lifecycle.fireLifecycleEvent("before_start", null);
            this.setAvailable(false);
            this.setConfigured(false);
            ok = true;
            File configBase = this.getConfigBase();
            if (configBase != null && this.saveConfig) {
                if (this.getConfigFile() == null) {
                    File file = new File(configBase, this.getDefaultConfigFile());
                    this.setConfigFile(file.getPath());
                    try {
                        File appBaseFile = new File(this.getAppBase());
                        if (!appBaseFile.isAbsolute()) {
                            appBaseFile = new File(this.engineBase(), this.getAppBase());
                        }
                        String appBase = appBaseFile.getCanonicalPath();
                        String basePath = new File(this.getBasePath(this.getDocBase())).getCanonicalPath();
                        if (!basePath.startsWith(appBase)) {
                            Server server = ServerFactory.getServer();
                            ((StandardServer)server).storeContext(this);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error storing config file", e);
                    }
                } else {
                    try {
                        File file;
                        String canConfigFile = new File(this.getConfigFile()).getCanonicalPath();
                        if (!canConfigFile.startsWith(configBase.getCanonicalPath()) && this.copy(new File(canConfigFile), file = new File(configBase, this.getDefaultConfigFile()))) {
                            this.setConfigFile(file.getPath());
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Error setting config file", e);
                    }
                }
            }
            if (!this.getOverride() && (host = this.getParent()) instanceof StandardHost) {
                ((StandardHost)host).installDefaultContext(this);
                Container engine = host.getParent();
                if (engine instanceof StandardEngine) {
                    ((StandardEngine)engine).installDefaultContext(this);
                }
            }
            if (this.webappResources == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Configuring default Resources");
                }
                try {
                    if (this.docBase != null && this.docBase.endsWith(".war") && !new File(this.docBase).isDirectory()) {
                        this.setResources((DirContext)new WARDirContext());
                    } else {
                        this.setResources((DirContext)new FileDirContext());
                    }
                }
                catch (IllegalArgumentException e) {
                    log.log(Level.SEVERE, sm.getString("standardContext.resourcesInit"), e);
                    ok = false;
                }
            }
            if (ok && !this.resourcesStart()) {
                ok = false;
            }
            if (this.alternateDocBases != null && !this.alternateDocBases.isEmpty()) {
                for (AlternateDocBase alternateDocBase : this.alternateDocBases) {
                    String docBase = alternateDocBase.getDocBase();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Configuring alternate resources");
                    }
                    try {
                        if (docBase != null && docBase.endsWith(".war") && !new File(docBase).isDirectory()) {
                            this.setAlternateResources(alternateDocBase, (DirContext)new WARDirContext());
                            continue;
                        }
                        this.setAlternateResources(alternateDocBase, (DirContext)new FileDirContext());
                    }
                    catch (IllegalArgumentException e) {
                        log.log(Level.SEVERE, sm.getString("standardContext.resourcesInit"), e);
                        ok = false;
                    }
                }
                if (ok && !this.alternateResourcesStart()) {
                    ok = false;
                }
            }
            if (this.realm == null) {
                ObjectName realmName = null;
                try {
                    realmName = new ObjectName(this.getEngineName() + ":type=Realm,host=" + this.getHostname() + ",path=" + this.getPath());
                    if (this.mserver.isRegistered(realmName)) {
                        this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                    }
                }
                catch (Throwable t) {
                    if (!log.isLoggable(Level.FINE)) break block81;
                    log.fine("No realm for this host " + realmName);
                }
            }
        }
        if (this.getLoader() == null) {
            this.createLoader();
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        boolean dependencyCheck = true;
        try {
            dependencyCheck = ExtensionValidator.validateApplication(this.getResources(), this);
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, sm.getString("standardContext.dependencyCheck", this), ioe);
            dependencyCheck = false;
        }
        if (!dependencyCheck) {
            ok = false;
        }
        if ((useNamingProperty = System.getProperty("catalina.useNaming")) != null && "false".equals(useNamingProperty)) {
            this.useNaming = false;
        }
        if (ok && this.isUseNaming() && this.namingContextListener == null) {
            this.namingContextListener = new NamingContextListener();
            this.namingContextListener.setDebug(this.getDebug());
            this.namingContextListener.setName(this.getNamingContextName());
            this.addLifecycleListener(this.namingContextListener);
        }
        ClassLoader oldCCL = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing standard container startup");
        }
        boolean mainOk = false;
        try {
            if (ok) {
                this.started = true;
                if (this.loader != null && this.loader instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.loader)).start();
                }
                if (this.logger != null && this.logger instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.logger)).start();
                }
                oldCCL = this.bindThread();
                if (this.realm != null && this.realm instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.realm)).start();
                }
                if (this.resources != null && this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).start();
                }
                for (Container child : this.findChildren()) {
                    if (!(child instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)child)).start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.pipeline)).start();
                }
                this.lifecycle.fireLifecycleEvent("start", null);
                TldConfig tldConfig = new TldConfig();
                tldConfig.setContext(this);
                tldConfig.setTldValidation(this.tldValidation);
                tldConfig.setTldNamespaceAware(this.tldNamespaceAware);
                if (!this.tldValidation) {
                    tldConfig.setTldValidation(((StandardHost)this.getParent()).getXmlValidation());
                }
                try {
                    tldConfig.execute();
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, sm.getString("standardContext.tldConfig"), ex);
                }
                mainOk = true;
            }
            Object var14_24 = null;
            this.unbindThread(oldCCL);
            if (!mainOk) {
                this.registerJMX();
            }
        }
        catch (Throwable throwable) {
            Object var14_25 = null;
            this.unbindThread(oldCCL);
            if (!mainOk) {
                this.registerJMX();
            }
            throw throwable;
        }
        if (!this.getConfigured()) {
            ok = false;
        }
        if (ok) {
            this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
            this.context.setAttributeReadOnly("org.apache.catalina.resources");
            this.getServletContext().setAttribute("org.apache.catalina.alternateResources", this.getAlternateDocBases());
            this.context.setAttributeReadOnly("org.apache.catalina.alternateResources");
        }
        this.mapper.setContext(this.getPath(), this.welcomeFiles, (javax.naming.Context)this.resources);
        oldCCL = this.bindThread();
        try {
            if (ok) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Posting standard context attributes");
                }
                this.postWelcomeFiles();
            }
            if (ok) {
                this.lifecycle.fireLifecycleEvent("after_start", null);
            }
            if (ok && !this.callServletContainerInitializers()) {
                ok = false;
            }
            if (ok && !this.listenerStart()) {
                ok = false;
            }
            try {
                if (this.manager != null && this.manager instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.getManager())).start();
                }
                super.threadStart();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sm.getString("standardContext.startManager.error"), e);
                ok = false;
            }
            if (ok && !this.filterStart()) {
                ok = false;
            }
            if (ok) {
                this.loadOnStartup(this.findChildren());
            }
            Object var16_27 = null;
            this.unbindThread(oldCCL);
        }
        catch (Throwable throwable) {
            Object var16_28 = null;
            this.unbindThread(oldCCL);
            throw throwable;
        }
        if (ok) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Starting completed");
            }
            this.setAvailable(true);
        } else {
            log.severe(sm.getString("standardContext.startFailed", this.getName()));
            try {
                this.stop();
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, sm.getString("standardContext.startCleanup"), t);
            }
            this.setAvailable(false);
        }
        this.registerJMX();
        this.startTimeMillis = System.currentTimeMillis();
        this.startupTime = this.startTimeMillis - startupTimeStart;
        if (ok && this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.getLoader() instanceof WebappLoader) {
            ((WebappLoader)this.getLoader()).closeJARs(true);
        }
        if (!ok && this.started) {
            this.stop();
        }
    }

    private boolean callServletContainerInitializers() {
        Map initializerList = ServletContainerInitializerUtil.getInitializerList(this.servletContainerInitializerInterestList, (ClassLoader)this.getLoader().getClassLoader());
        if (initializerList == null) {
            return true;
        }
        ServletContext ctxt = this.getServletContext();
        for (Class initializer : initializerList.keySet()) {
            try {
                ServletContainerInitializer iniInstance = (ServletContainerInitializer)initializer.newInstance();
                iniInstance.onStartup((Set)initializerList.get(initializer), ctxt);
            }
            catch (Exception iex) {
                log.warning(sm.getString("standardContext.pluggability.CNFWarning", initializer.getCanonicalName()));
            }
        }
        return true;
    }

    public void setServletContainerInitializerInterestList(Map<Class<?>, ArrayList<Class<? extends ServletContainerInitializer>>> interestList) {
        this.servletContainerInitializerInterestList = interestList;
    }

    public void createLoader() {
        ClassLoader parent = null;
        if (this.getPrivileged()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Configuring privileged default Loader");
            }
            parent = this.getClass().getClassLoader();
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Configuring non-privileged default Loader");
            }
            parent = this.getParentClassLoader();
        }
        WebappLoader webappLoader = new WebappLoader(parent);
        webappLoader.setDelegate(this.getDelegate());
        webappLoader.setUseMyFaces(this.useMyFaces);
        this.setLoader(webappLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheContext() {
        try {
            FileOutputStream fos;
            block7: {
                File workDir = new File(this.getWorkPath());
                File ctxSer = new File(workDir, "_tomcat_context.ser");
                ObjectOutputStream oos = null;
                fos = null;
                try {
                    fos = new FileOutputStream(ctxSer);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(this);
                    Object var6_6 = null;
                    if (oos == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (oos != null) {
                        oos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    throw throwable;
                }
                oos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        catch (Throwable t) {
            log.log(Level.INFO, "Error saving context.ser ", t);
        }
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        this.stop(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(boolean isShutdown) throws LifecycleException {
        if (!this.started) {
            if (log.isLoggable(Level.INFO)) {
                log.info(sm.getString("containerBase.notStarted", this.logName()));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.setAvailable(false);
        ClassLoader oldCCL = this.bindThread();
        try {
            for (Container child : this.findChildren()) {
                if (!(child instanceof Lifecycle)) continue;
                ((Lifecycle)((Object)child)).stop();
            }
            this.filterStop();
            super.threadStop();
            if (this.manager != null && this.manager instanceof Lifecycle) {
                if (this.manager instanceof StandardManager) {
                    ((StandardManager)this.manager).stop(isShutdown);
                } else {
                    ((Lifecycle)((Object)this.manager)).stop();
                }
            }
            this.lifecycleListenerStop();
            this.setCharsetMapper(null);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing standard container shutdown");
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            this.started = false;
            if (this.pipeline instanceof Lifecycle) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            if (this.context != null) {
                this.context.clearAttributes();
            }
            this.eventListenerStop();
            this.resourcesStop();
            this.alternateResourcesStop();
            if (this.realm != null && this.realm instanceof Lifecycle) {
                ((Lifecycle)((Object)this.realm)).stop();
            }
            if (this.logger != null && this.logger instanceof Lifecycle) {
                ((Lifecycle)((Object)this.logger)).stop();
            }
            Object var8_8 = null;
            this.unbindThread(oldCCL);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.unbindThread(oldCCL);
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).stop();
            }
            throw throwable;
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, sm.getString("standardContext.reset", this), ex);
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stopping complete");
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.oname != null) {
            Notification notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.destroy();
        if (this.getManager() instanceof ManagerBase) {
            ((ManagerBase)this.getManager()).release();
        }
        this.instanceListeners.clear();
        this.instanceListenerInstances.clear();
    }

    private void resetContext() throws Exception, MBeanRegistrationException {
        this.children = new HashMap();
        this.startupTime = 0L;
        this.startTimeMillis = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.applicationListeners.clear();
        this.applicationEventListenersObjects = new Object[0];
        this.applicationLifecycleListenersObjects = new Object[0];
        if (log.isLoggable(Level.FINE)) {
            log.fine("resetContext " + this.oname + " " + this.mserver);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundProcess() {
        if (!this.started) {
            return;
        }
        this.count = (this.count + 1) % this.managerChecksFrequency;
        if (this.getManager() != null && this.count == 0) {
            if (this.getManager() instanceof StandardManager) {
                ((StandardManager)this.getManager()).processExpires();
            } else if (this.getManager() instanceof PersistentManagerBase) {
                PersistentManagerBase pManager = (PersistentManagerBase)this.getManager();
                pManager.backgroundProcess();
            }
        }
        if (this.isReload() && this.getLoader() != null) {
            if (this.reloadable && this.getLoader().modified()) {
                try {
                    Thread.currentThread().setContextClassLoader(standardContextClassLoader);
                    this.reload();
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.getLoader() != null) {
                        Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
                    }
                    throw throwable;
                }
                if (this.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
                }
            }
            if (this.getLoader() instanceof WebappLoader) {
                ((WebappLoader)this.getLoader()).closeJARs(false);
            }
        }
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(sm.getString("standardContext.urlPattern.patternWarning", urlPattern));
        }
        return "/" + urlPattern;
    }

    protected boolean isServlet22() {
        return this.publicId != null && this.publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
    }

    protected File engineBase() {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)this.getParent().getParent();
            base = eng.getBaseDir();
        }
        return new File(base);
    }

    private ClassLoader bindThread() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread((Object)this, (Object)this);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return oldContextClassLoader;
    }

    private void unbindThread(ClassLoader oldContextClassLoader) {
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        if (this.isUseNaming()) {
            ContextBindings.unbindThread((Object)this, (Object)this);
        }
    }

    private String getBasePath(String docBase) {
        Container container;
        String basePath = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(docBase);
        if (!file.isAbsolute()) {
            if (container == null) {
                basePath = new File(this.engineBase(), docBase).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                basePath = new File(file, docBase).getPath();
            }
        } else {
            basePath = file.getPath();
        }
        return basePath;
    }

    private String getAppBase() {
        Container container;
        String appBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        if (container != null) {
            appBase = ((Host)container).getAppBase();
        }
        return appBase;
    }

    private File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        StandardContext host = null;
        Container engine = null;
        for (Container container = this; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            configBase = new File(configBase, engine.getName());
        }
        if (host != null) {
            configBase = new File(configBase, host.getName());
        }
        configBase.mkdirs();
        return configBase;
    }

    protected String getDefaultConfigFile() {
        String basename = null;
        String path = this.getPath();
        basename = "".equals(path) ? "ROOT" : path.substring(1).replace('/', '_');
        return basename + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean copy(File src, File dest) {
        block20: {
            int len;
            FileInputStream is = null;
            FileOutputStream os = null;
            is = new FileInputStream(src);
            os = new FileOutputStream(dest);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
            Object var8_9 = null;
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                if (os != null) {
                    os.close();
                }
                break block20;
            }
            catch (Exception e2) {}
            break block20;
            {
                catch (IOException e) {
                    boolean bl = false;
                    Object var8_10 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuilder buff = new StringBuilder();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/").append((String)stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
            this.namingContextName = this.namingContextName + instanceIDCounter++;
        }
        return this.namingContextName;
    }

    public boolean getPaused() {
        return this.paused;
    }

    private void postResources() {
        this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
        this.context.setAttributeReadOnly("org.apache.catalina.resources");
    }

    private void postWelcomeFiles() {
        this.getServletContext().setAttribute("org.apache.catalina.WELCOME_FILES", (Object)this.welcomeFiles);
        this.context.setAttributeReadOnly("org.apache.catalina.WELCOME_FILES");
    }

    public String getHostname() {
        Container parentHost = this.getParent();
        if (parentHost != null) {
            this.hostName = parentHost.getName();
        }
        if (this.hostName == null || this.hostName.length() < 1) {
            this.hostName = "_";
        }
        return this.hostName;
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null || workDir.length() == 0) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getPath()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        dir.mkdirs();
        this.getServletContext().setAttribute("javax.servlet.context.tempdir", (Object)dir);
        this.context.setAttributeReadOnly("javax.servlet.context.tempdir");
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            log.warning(sm.getString("standardContext.crlfinurl", urlPattern));
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf(47) < 0) {
                this.checkUnusualURLPattern(urlPattern);
                return true;
            }
            return false;
        }
        if (urlPattern.startsWith("/") && !urlPattern.contains("*.")) {
            this.checkUnusualURLPattern(urlPattern);
            return true;
        }
        return false;
    }

    private void checkUnusualURLPattern(String urlPattern) {
        if (log.isLoggable(Level.INFO) && urlPattern.endsWith("*") && (urlPattern.length() < 2 || urlPattern.charAt(urlPattern.length() - 2) != '/')) {
            log.info("Suspicious url pattern: \"" + urlPattern + "\"" + " in context [" + this.getName() + "] - see" + " section SRV.11.2 of the Servlet specification");
        }
    }

    public String[] getEnvironments() {
        ContextEnvironment[] envs = this.getNamingResources().findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        for (ContextEnvironment env : envs) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getEngineName(), env);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for environment " + env);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceNames() {
        ContextResource[] resources = this.getNamingResources().findResources();
        ArrayList<String> results = new ArrayList<String>();
        for (ContextResource resource : resources) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getEngineName(), resource);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + resource);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] links = this.getNamingResources().findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        for (ContextResourceLink link : links) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.getEngineName(), link);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for resource " + link);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type);
        nresources.addEnvironment(env);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextEnvironment");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), env);
        return oname.toString();
    }

    public String addResource(String resourceName, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type);
        nresources.addResource(resource);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextResource");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resource);
        return oname.toString();
    }

    public String addResourceLink(String resourceLinkName, String global, String name, String type) throws MalformedObjectNameException {
        NamingResources nresources = this.getNamingResources();
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setGlobal(global);
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type);
        nresources.addResourceLink(resourceLink);
        ManagedBean managed = Registry.getRegistry(null, null).findManagedBean("ContextResourceLink");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resourceLink);
        return oname.toString();
    }

    public String getDeploymentDescriptor() {
        InputStream stream = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        String strRead = "";
        try {
            while (strRead != null) {
                sb.append(strRead);
                strRead = br.readLine();
            }
        }
        catch (IOException e) {
            return "";
        }
        return sb.toString();
    }

    public String[] getServlets() {
        String[] result = null;
        Container[] children = this.findChildren();
        if (children != null) {
            result = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = ((StandardWrapper)children[i]).getObjectName();
            }
        }
        return result;
    }

    @Override
    public ObjectName createObjectName(String hostDomain, ObjectName parentName) throws MalformedObjectNameException {
        StandardHost hst = (StandardHost)this.getParent();
        String hostName = this.getParent().getName();
        String name = "//" + (hostName == null ? "DEFAULT" : hostName) + ("".equals(this.encodedPath) ? "/" : this.encodedPath);
        String suffix = ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer();
        String onameStr = "j2eeType=WebModule,name=" + name + suffix;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Registering " + onameStr + " for " + this.oname);
        }
        if (this.getDomain() == null) {
            this.domain = hst.getDomain();
        }
        return new ObjectName(this.getDomain() + ":" + onameStr);
    }

    private void preRegisterJMX() {
        try {
            StandardHost host = (StandardHost)this.getParent();
            if (this.oname == null || this.oname.getKeyProperty("j2eeType") == null) {
                this.controller = this.oname = this.createObjectName(host.getDomain(), host.getJmxName());
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error registering ctx with jmx " + this + " " + this.oname + " " + ex.toString(), ex);
        }
    }

    private void registerJMX() {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Checking for " + this.oname);
            }
            if (!Registry.getRegistry(null, null).getMBeanServer().isRegistered(this.oname)) {
                this.controller = this.oname;
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
                if (this.getObjectName() != null) {
                    Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                    this.broadcaster.sendNotification(notification);
                }
            }
            for (Container child : this.findChildren()) {
                ((StandardWrapper)child).registerJMX(this);
            }
        }
        catch (Exception ex) {
            log.log(Level.INFO, "Error registering wrapper with jmx " + this + " " + this.oname + " " + ex.toString(), ex);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.oname != null) {
            return name;
        }
        ObjectName result = super.preRegister(server, name);
        return name;
    }

    @Override
    public void preDeregister() throws Exception {
        if (this.started) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, sm.getString("standardContext.stoppingContext", this), ex);
            }
        }
    }

    @Override
    public void init() throws Exception {
        if (this.getParent() == null) {
            ObjectName parentName = this.getParentName();
            if (!this.mserver.isRegistered(parentName)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No host, creating one " + parentName);
                }
                StandardHost host = new StandardHost();
                host.setName(this.hostName);
                Registry.getRegistry(null, null).registerComponent((Object)host, parentName, null);
                this.mserver.invoke(parentName, "init", new Object[0], new String[0]);
            }
            ContextConfig config = new ContextConfig();
            this.addLifecycleListener(config);
            if (log.isLoggable(Level.FINE)) {
                log.fine("AddChild " + parentName + " " + this);
            }
            try {
                this.mserver.invoke(parentName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
            }
            catch (Exception e) {
                this.destroy();
                throw e;
            }
        }
        if (this.initialized) {
            return;
        }
        super.init();
        this.lifecycle.fireLifecycleEvent("init", null);
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public ObjectName getParentName() throws MalformedObjectNameException {
        String path = this.oname.getKeyProperty("name");
        if (path == null) {
            log.severe(sm.getString("standardContext.missingNameAttributeInName", this.getName()));
            return null;
        }
        if (!path.startsWith("//")) {
            log.severe(sm.getString("standardContext.malformedName", this.getName()));
        }
        path = path.substring(2);
        int delim = path.indexOf("/");
        this.hostName = "localhost";
        if (delim > 0) {
            this.hostName = path.substring(0, delim);
            if ("/".equals(path = path.substring(delim))) {
                this.setName("");
            } else {
                this.setName(path);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Setting path " + path);
            }
            this.setName(path);
        }
        String parentDomain = this.getEngineName();
        if (parentDomain == null) {
            parentDomain = this.domain;
        }
        return new ObjectName(parentDomain + ":" + "type=Host,host=" + this.hostName);
    }

    public void create() throws Exception {
        this.init();
    }

    public DirContext getStaticResources() {
        return this.getResources();
    }

    public DirContext findStaticResources() {
        return this.getResources();
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    public boolean isStateManageable() {
        return true;
    }

    @Override
    public void setXmlValidation(boolean webXmlValidation) {
        this.webXmlValidation = webXmlValidation;
    }

    @Override
    public boolean getXmlValidation() {
        return this.webXmlValidation;
    }

    @Override
    public boolean getXmlNamespaceAware() {
        return this.webXmlNamespaceAware;
    }

    @Override
    public void setXmlNamespaceAware(boolean webXmlNamespaceAware) {
        this.webXmlNamespaceAware = webXmlNamespaceAware;
    }

    @Override
    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    @Override
    public boolean getTldValidation() {
        return this.tldValidation;
    }

    @Override
    public boolean getTldNamespaceAware() {
        return this.tldNamespaceAware;
    }

    @Override
    public void setTldNamespaceAware(boolean tldNamespaceAware) {
        this.tldNamespaceAware = tldNamespaceAware;
    }

    public void startRecursive() throws LifecycleException {
        this.start();
    }

    public int getState() {
        if (this.started) {
            return 1;
        }
        if (this.initialized) {
            return 0;
        }
        if (!this.available) {
            return 4;
        }
        return 3;
    }

    boolean isContextInitializedCalled() {
        return this.isContextInitializedCalled;
    }

    public String getServer() {
        return this.server;
    }

    public String setServer(String server) {
        this.server = server;
        return this.server;
    }

    public String[] getJavaVMs() {
        return this.javaVMs;
    }

    public String[] setJavaVMs(String[] javaVMs) {
        this.javaVMs = javaVMs;
        return javaVMs;
    }

    public ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        ClassLoader classLoader;
        ObjectInputStream ois = null;
        Loader loader = this.getLoader();
        if (loader != null && (classLoader = loader.getClassLoader()) != null) {
            try {
                ois = new CustomObjectInputStream(is, classLoader);
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Unable to create custom ObjectInputStream", ioe);
            }
        }
        if (ois == null) {
            ois = new ObjectInputStream(is);
        }
        return ois;
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream os) throws IOException {
        return new ObjectOutputStream(os);
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public void sessionCreatedEvent(HttpSession session) {
    }

    public void sessionDestroyedEvent(HttpSession session) {
    }

    public void sessionRejectedEvent(int maxSessions) {
    }

    public void sessionExpiredEvent(HttpSession session) {
    }

    public void sessionPersistedStartEvent(HttpSession session) {
    }

    public void sessionPersistedEndEvent(HttpSession session) {
    }

    public void sessionActivatedStartEvent(HttpSession session) {
    }

    public void sessionActivatedEndEvent(HttpSession session) {
    }

    public void sessionPassivatedStartEvent(HttpSession session) {
    }

    public void sessionPassivatedEndEvent(HttpSession session) {
    }

    static {
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        instanceIDCounter = 1;
    }
}

