/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.glassfish.api.statistics.CountStatistic;
import org.glassfish.api.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;

@ManagedObject
@Description(value="Web Container Servlet Statistics")
public class ServletStatsProvider {
    private String moduleName;
    private String vsName;
    private Logger logger;
    private CountStatisticImpl activeServletsLoadedCount = new CountStatisticImpl("ActiveServletsLoaded", "count", "Number of currently loaded servlets");
    private CountStatisticImpl maxServletsLoadedCount = new CountStatisticImpl("MaxServletsLoaded", "count", "Maximum number of servlets loaded which were active");
    private CountStatisticImpl totalServletsLoadedCount = new CountStatisticImpl("TotalServletsLoaded", "count", "Cumulative number of servlets that have been loaded into the web module");

    public ServletStatsProvider(String moduleName, String vsName, Logger logger) {
        this.logger = logger;
        this.moduleName = moduleName;
        this.vsName = vsName;
    }

    @ManagedAttribute(id="activeservletsloadedcount")
    @Description(value="Number of currently loaded servlets")
    public CountStatistic getActiveServletsLoaded() {
        return this.activeServletsLoadedCount;
    }

    @ManagedAttribute(id="maxservletsloadedcount")
    @Description(value="Maximum number of servlets loaded which were active")
    public CountStatistic getMaxServletsLoaded() {
        return this.maxServletsLoadedCount;
    }

    @ManagedAttribute(id="totalservletsloadedcount")
    @Description(value="Cumulative number of servlets that have been loaded into the web module")
    public CountStatistic getTotalServletsLoaded() {
        return this.totalServletsLoadedCount;
    }

    @ProbeListener(value="web:servlet::servletInitializedEvent")
    public void servletInitializedEvent(@ProbeParam(value="servlet") Servlet servlet, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("Servlet Loaded event received - servletName = " + servlet.getServletConfig().getServletName() + ": appName = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeServletsLoadedCount.increment();
        this.totalServletsLoadedCount.increment();
        if (this.activeServletsLoadedCount.getCount() > this.maxServletsLoadedCount.getCount()) {
            this.maxServletsLoadedCount.setCount(this.activeServletsLoadedCount.getCount());
        }
    }

    @ProbeListener(value="web:servlet::servletDestroyedEvent")
    public void servletDestroyedEvent(@ProbeParam(value="servlet") Servlet servlet, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("Servlet Destroyed event received - servletName = " + servlet.getServletConfig().getServletName() + ": appName = " + appName + ": hostName = " + hostName);
        if (!this.isValidEvent(appName, hostName)) {
            return;
        }
        this.activeServletsLoadedCount.decrement();
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    private void resetStats() {
        this.activeServletsLoadedCount.setCount(0L);
        this.maxServletsLoadedCount.setCount(0L);
        this.totalServletsLoadedCount.setCount(0L);
    }
}

