/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.probe.provider.PluginPoint;
import org.glassfish.probe.provider.StatsProviderManager;
import org.glassfish.web.admin.monitor.JspStatsProvider;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.SessionStatsProvider;
import org.glassfish.web.admin.monitor.WebRequestStatsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.PostConstruct;

public class WebStatsProviderBootstrap
implements PostConstruct {
    @Inject
    Logger logger;
    @Inject
    private static Domain domain;
    private TreeNode serverNode;
    private static HttpService httpService;
    private static NetworkConfig networkConfig;

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the WebStatsProviderBootstrap.postConstruct ************");
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        networkConfig = config.getNetworkConfig();
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/jsp", (Object)new JspStatsProvider(null, null, this.logger));
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/request", (Object)new WebRequestStatsProvider(null, null, this.logger));
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/servlet", (Object)new ServletStatsProvider(null, null, this.logger));
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/session", (Object)new SessionStatsProvider(null, null, this.logger));
        TreeNode appsNode = this.serverNode.getNode("applications");
        Collection appNodes = appsNode.getChildNodes();
        for (TreeNode appNode : appNodes) {
            Collection vsNodes = appNode.getChildNodes();
            for (TreeNode vsNode : vsNodes) {
                StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)(appNode.getName() + "/" + vsNode.getName()), (Object)new JspStatsProvider(appNode.getName(), vsNode.getName(), this.logger));
                StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)(appNode.getName() + "/" + vsNode.getName()), (Object)new ServletStatsProvider(appNode.getName(), vsNode.getName(), this.logger));
                StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)(appNode.getName() + "/" + vsNode.getName()), (Object)new SessionStatsProvider(appNode.getName(), vsNode.getName(), this.logger));
                StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)(appNode.getName() + "/" + vsNode.getName()), (Object)new WebRequestStatsProvider(appNode.getName(), vsNode.getName(), this.logger));
            }
        }
    }

    public static String getAppName(String contextRoot) {
        if (contextRoot == null) {
            return null;
        }
        List lm = domain.getApplications().getModules(WebModule.class);
        for (WebModule wm : lm) {
            if (!contextRoot.equals(wm.getContextRoot())) continue;
            return wm.getName();
        }
        List la = domain.getApplications().getModules(Application.class);
        for (Application sapp : la) {
            if (!contextRoot.equals(sapp.getContextRoot())) continue;
            return sapp.getName();
        }
        return null;
    }

    public static String getVirtualServerName(String hostName, String listenerPort) {
        try {
            if (hostName == null) {
                return null;
            }
            if (hostName.equals("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            NetworkListener listener = null;
            for (NetworkListener hl : networkConfig.getNetworkListeners().getNetworkListener()) {
                if (!hl.getPort().equals(listenerPort)) continue;
                listener = hl;
                break;
            }
            VirtualServer virtualServer = null;
            for (VirtualServer vs : httpService.getVirtualServer()) {
                if (!vs.getHosts().contains(hostName) || !vs.getNetworkListeners().contains(listener.getName())) continue;
                virtualServer = vs;
                break;
            }
            return virtualServer.getId();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(WebStatsProviderBootstrap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    static {
        httpService = null;
        networkConfig = null;
    }
}

