/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.ClassLoader;
import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModuleConfig;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.RequestDispatcher;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.jsp.JSPCompiler;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebDeployer
extends JavaEEDeployer<WebContainer, WebApplication> {
    @Inject
    ServerContext sc;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    RequestDispatcher dispatcher;

    protected String getModuleType() {
        return "web";
    }

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{WebBundleDescriptor.class});
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext dc) {
        WebBundleDescriptor wbd = (WebBundleDescriptor)dc.getModuleMetaData(WebBundleDescriptor.class);
        if (wbd.isStandalone()) {
            DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            String contextRoot = params.contextroot;
            if (contextRoot == null && "".equals(contextRoot = wbd.getContextRoot())) {
                contextRoot = null;
            }
            if (contextRoot == null) {
                contextRoot = params.previousContextRoot;
            }
            if (contextRoot == null) {
                contextRoot = params.name();
            }
            if (contextRoot == null) {
                contextRoot = dc.getSource().getName();
            }
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            wbd.setContextRoot(contextRoot);
            wbd.setName(params.name());
            dc.getAppProps().setProperty("context-root", contextRoot);
        }
        return null;
    }

    private WebModuleConfig loadWebModuleConfig(DeploymentContext dc) {
        WebModuleConfig wmInfo = null;
        try {
            DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
            wmInfo = new WebModuleConfig();
            wmInfo.setDescriptor((WebBundleDescriptor)dc.getModuleMetaData(WebBundleDescriptor.class));
            wmInfo.setVirtualServers(params.virtualservers);
            wmInfo.setLocation(dc.getSourceDir());
            wmInfo.setObjectType(dc.getAppProps().getProperty("object-type"));
        }
        catch (Exception ex) {
            dc.getLogger().log(Level.WARNING, "loadWebModuleConfig", ex);
        }
        return wmInfo;
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (params.precompilejsp.booleanValue()) {
            this.runJSPC(dc);
        }
    }

    public WebApplication load(WebContainer container, DeploymentContext dc) {
        super.load((Container)container, dc);
        WebModuleConfig wmInfo = this.loadWebModuleConfig(dc);
        com.sun.enterprise.config.serverbeans.Application config = (com.sun.enterprise.config.serverbeans.Application)this.domain.getApplications().getModule(com.sun.enterprise.config.serverbeans.Application.class, dc.getCommandParameters(OpsParams.class).name());
        Module moduleConfig = null;
        if (config != null) {
            moduleConfig = config.getModule(wmInfo.getDescriptor().getName());
        }
        WebApplication webApp = new WebApplication(container, wmInfo, moduleConfig, Boolean.parseBoolean(dc.getAppProps().getProperty("keepSessions")) ? dc.getAppProps() : null);
        return webApp;
    }

    public void unload(WebApplication webApplication, DeploymentContext dc) {
        if (webApplication.props != null && dc.getAppProps().get("ActionReportProperties") != null) {
            ((Properties)dc.getAppProps().get("ActionReportProperties")).putAll((Map<?, ?>)webApplication.props);
        }
    }

    void runJSPC(DeploymentContext dc) throws DeploymentException {
        WebBundleDescriptor wbd = (WebBundleDescriptor)((Application)dc.getModuleMetaData(Application.class)).getStandaloneBundleDescriptor();
        try {
            File outDir = dc.getScratchDir("jsp");
            File inDir = dc.getSourceDir();
            boolean delegate = true;
            ClassLoader clBean = wbd.getSunDescriptor().getClassLoader();
            if (clBean != null) {
                String value = clBean.getAttributeValue("Delegate");
                delegate = ConfigBeansUtilities.toBoolean((String)value);
            }
            StringBuilder classpath = new StringBuilder(super.getCommonClassPath());
            classpath.append(File.pathSeparatorChar);
            classpath.append(ASClassLoaderUtil.getModuleClassPath((Habitat)this.sc.getDefaultHabitat(), (String)wbd.getApplication().getName(), (String)((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).libraries));
            JSPCompiler.compile(inDir, outDir, wbd, classpath.toString(), this.sc);
        }
        catch (DeploymentException de) {
            dc.getLogger().log(Level.SEVERE, "Error compiling JSP", de);
            throw de;
        }
    }
}

