/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.fileupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.fileupload.LimitedInputStream;
import org.apache.catalina.fileupload.Multipart;
import org.apache.catalina.fileupload.MultipartStream;
import org.apache.catalina.fileupload.ParameterParser;
import org.apache.catalina.fileupload.PartHeaders;
import org.apache.catalina.fileupload.RequestItem;
import org.apache.catalina.fileupload.SizeException;

class RequestItemIterator {
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_LENGTH = "Content-length";
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String FORM_DATA = "form-data";
    private static final String ATTACHMENT = "attachment";
    private static final String MULTIPART = "multipart/";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private Multipart multipart;
    private final MultipartStream multiStream;
    private final MultipartStream.ProgressNotifier notifier;
    private final byte[] boundary;
    private RequestItem currentItem;
    private String currentFieldName;
    private boolean itemValid;
    private boolean eof;

    RequestItemIterator(Multipart multipart, HttpServletRequest request) throws IOException, ServletException {
        this.multipart = multipart;
        String contentType = request.getContentType();
        if (null == contentType || !contentType.toLowerCase().startsWith(MULTIPART)) {
            throw new ServletException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        Object input = request.getInputStream();
        long sizeMax = multipart.getMaxRequestSize();
        if (sizeMax >= 0L) {
            int requestSize = request.getContentLength();
            if (requestSize == -1) {
                input = new LimitedInputStream((InputStream)input, sizeMax){

                    protected void raiseError(long pSizeMax, long pCount) throws SizeException {
                        throw new SizeException("the request was rejected because its size (" + pCount + ") exceeds the configured maximum" + " (" + pSizeMax + ")");
                    }
                };
            } else if ((long)requestSize > sizeMax) {
                throw new ServletException("the request was rejected because its size (" + requestSize + ") exceeds the configured maximum (" + sizeMax + ")");
            }
        }
        this.boundary = this.getBoundary(contentType);
        if (this.boundary == null) {
            throw new ServletException("the request was rejected because no multipart boundary was found");
        }
        this.notifier = new MultipartStream.ProgressNotifier(multipart.getProgressListener(), request.getContentLength());
        this.multiStream = new MultipartStream((InputStream)input, this.boundary, this.notifier);
        this.multiStream.setHeaderEncoding(request.getCharacterEncoding());
        this.findNextItem();
    }

    private boolean findNextItem() throws IOException, ServletException {
        if (this.eof) {
            return false;
        }
        if (this.currentItem != null) {
            this.currentItem.close();
            this.currentItem = null;
        }
        while (true) {
            if (!this.multiStream.skipPreamble()) {
                if (this.currentFieldName == null) {
                    this.eof = true;
                    return false;
                }
                this.multiStream.setBoundary(this.boundary);
                this.currentFieldName = null;
                continue;
            }
            PartHeaders headers = this.getParsedHeaders(this.multiStream.readHeaders());
            if (this.currentFieldName == null) {
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = headers.getHeader(CONTENT_TYPE);
                    if (subContentType != null && subContentType.toLowerCase().startsWith(MULTIPART_MIXED)) {
                        this.currentFieldName = fieldName;
                        byte[] subBoundary = this.getBoundary(subContentType);
                        this.multiStream.setBoundary(subBoundary);
                        continue;
                    }
                    String fileName = this.getFileName(headers);
                    this.currentItem = new RequestItemImpl(headers, fileName, fieldName, headers.getHeader(CONTENT_TYPE), fileName == null, this.getContentLength(headers));
                    this.notifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            } else {
                String fileName = this.getFileName(headers);
                if (fileName != null) {
                    this.currentItem = new RequestItemImpl(headers, fileName, this.currentFieldName, headers.getHeader(CONTENT_TYPE), false, this.getContentLength(headers));
                    this.notifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            }
            this.multiStream.discardBodyData();
        }
    }

    private long getContentLength(PartHeaders pHeaders) {
        try {
            return Long.parseLong(pHeaders.getHeader(CONTENT_LENGTH));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    protected String getFileName(PartHeaders headers) {
        return this.getFileName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFileName(String pContentDisposition) {
        String cdl;
        String fileName = null;
        if (pContentDisposition != null && ((cdl = pContentDisposition.toLowerCase()).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(pContentDisposition, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                fileName = fileName != null ? fileName.trim() : "";
            }
        }
        return fileName;
    }

    protected String getFieldName(PartHeaders headers) {
        return this.getFieldName(headers.getHeader(CONTENT_DISPOSITION));
    }

    private String getFieldName(String pContentDisposition) {
        String fieldName = null;
        if (pContentDisposition != null && pContentDisposition.toLowerCase().startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(pContentDisposition, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected PartHeaders getParsedHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        PartHeaders headers = new PartHeaders();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            int colonOffset;
            String header = headerPart.substring(start, end);
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header = header + " " + headerPart.substring(nonWs, end);
                start = end + 2;
            }
            if ((colonOffset = header.indexOf(58)) == -1) continue;
            String headerName = header.substring(0, colonOffset).trim();
            String headerValue = header.substring(header.indexOf(58) + 1).trim();
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    public boolean hasNext() throws ServletException, IOException {
        if (this.eof) {
            return false;
        }
        if (this.itemValid) {
            return true;
        }
        return this.findNextItem();
    }

    public RequestItem next() throws ServletException, IOException {
        this.itemValid = false;
        return this.currentItem;
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, new char[]{';', ','});
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    private class RequestItemImpl
    implements RequestItem {
        private final String contentType;
        private final String fieldName;
        private final String name;
        private final boolean formField;
        private InputStream stream;
        private PartHeaders headers;

        RequestItemImpl(PartHeaders pHeaders, String pName, String pFieldName, String pContentType, boolean pFormField, long pContentLength) throws ServletException {
            this.headers = pHeaders;
            this.name = pName;
            this.fieldName = pFieldName;
            this.contentType = pContentType;
            this.formField = pFormField;
            this.stream = RequestItemIterator.this.multiStream.newInputStream();
            long fileSizeMax = RequestItemIterator.this.multipart.getMaxFileSize();
            if (fileSizeMax != -1L) {
                if (pContentLength != -1L) {
                    if (pContentLength > fileSizeMax) {
                        throw new ServletException("The field " + this.fieldName + " exceeds its maximum permitted " + " size of " + fileSizeMax + " characters.");
                    }
                } else {
                    this.stream = new LimitedInputStream(this.stream, fileSizeMax){

                        protected void raiseError(long pSizeMax, long pCount) throws SizeException {
                            throw new SizeException("The field " + RequestItemImpl.this.fieldName + " exceeds its maximum permitted " + " size of " + pSizeMax + " characters.");
                        }
                    };
                }
            }
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getName() {
            return this.name;
        }

        public boolean isFormField() {
            return this.formField;
        }

        public InputStream openStream() throws IOException {
            return this.stream;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public PartHeaders getHeaders() {
            return this.headers;
        }

        public void setHeaders(PartHeaders pHeaders) {
            this.headers = pHeaders;
        }
    }
}

