/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import com.sun.grizzly.util.IntrospectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tomcat.util.digester.ArrayStack;
import org.apache.tomcat.util.digester.CallMethodRule;
import org.apache.tomcat.util.digester.CallParamRule;
import org.apache.tomcat.util.digester.FactoryCreateRule;
import org.apache.tomcat.util.digester.ObjectCreateRule;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.digester.ObjectParamRule;
import org.apache.tomcat.util.digester.ParserFeatureSetterFactory;
import org.apache.tomcat.util.digester.PathCallParamRule;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.digester.Rules;
import org.apache.tomcat.util.digester.RulesBase;
import org.apache.tomcat.util.digester.SetNextRule;
import org.apache.tomcat.util.digester.SetPropertiesRule;
import org.apache.tomcat.util.digester.SetPropertyRule;
import org.apache.tomcat.util.digester.SetRootRule;
import org.apache.tomcat.util.digester.SetTopRule;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digester
extends DefaultHandler {
    protected static IntrospectionUtils.PropertySource[] source = new IntrospectionUtils.PropertySource[]{new SystemPropertySource()};
    protected StringBuffer bodyText = new StringBuffer();
    protected ArrayStack<StringBuffer> bodyTexts = new ArrayStack();
    protected ArrayStack<List<Rule>> matches = new ArrayStack(10);
    protected ClassLoader classLoader = null;
    protected boolean configured = false;
    protected EntityResolver entityResolver;
    protected HashMap<String, String> entityValidator = new HashMap();
    protected ErrorHandler errorHandler = null;
    protected SAXParserFactory factory = null;
    protected String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected Locator locator = null;
    protected String match = "";
    protected boolean namespaceAware = false;
    protected HashMap<String, ArrayStack<String>> namespaces = new HashMap();
    protected ArrayStack<Object> params = new ArrayStack();
    protected SAXParser parser = null;
    protected String publicId = null;
    protected XMLReader reader = null;
    protected Object root = null;
    protected Rules rules = null;
    protected String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    protected String schemaLocation = null;
    protected ArrayStack<Object> stack = new ArrayStack();
    protected boolean useContextClassLoader = false;
    protected boolean validating = false;
    protected boolean rulesValidation = false;
    protected Map<Class<?>, List<String>> fakeAttributes = null;
    protected Logger log = Logger.getLogger(Digester.class.getName());
    protected Logger saxLog = Logger.getLogger("org.apache.tomcat.util.digester.Digester.sax");
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private HashMap<String, ArrayStack<Object>> stacksByName = new HashMap();

    public Digester() {
    }

    public Digester(SAXParser parser) {
        this.parser = parser;
    }

    public Digester(XMLReader reader) {
        this.reader = reader;
    }

    public String findNamespaceURI(String prefix) {
        ArrayStack<String> stack = this.namespaces.get(prefix);
        if (stack == null) {
            return null;
        }
        try {
            return stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getCount() {
        return this.stack.size();
    }

    public String getCurrentElementName() {
        String elementName = this.match;
        int lastSlash = elementName.lastIndexOf(47);
        if (lastSlash >= 0) {
            elementName = elementName.substring(lastSlash + 1);
        }
        return elementName;
    }

    public int getDebug() {
        return 0;
    }

    public void setDebug(int debug) {
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SAXParserFactory getFactory() {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(this.namespaceAware);
            this.factory.setValidating(this.validating);
        }
        return this.factory;
    }

    public boolean getFeature(String feature) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.getFactory().getFeature(feature);
    }

    public void setFeature(String feature, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(feature, value);
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public Logger getSAXLogger() {
        return this.saxLog;
    }

    public void setSAXLogger(Logger saxLog) {
        this.saxLog = saxLog;
    }

    public String getMatch() {
        return this.match;
    }

    public boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getRuleNamespaceURI() {
        return this.getRules().getNamespaceURI();
    }

    public void setRuleNamespaceURI(String ruleNamespaceURI) {
        this.getRules().setNamespaceURI(ruleNamespaceURI);
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            if (this.validating) {
                Properties properties = new Properties();
                properties.put("SAXParserFactory", this.getFactory());
                if (this.schemaLocation != null) {
                    properties.put("schemaLocation", this.schemaLocation);
                    properties.put("schemaLanguage", this.schemaLanguage);
                }
                this.parser = ParserFeatureSetterFactory.newSAXParser(properties);
            } else {
                this.parser = this.getFactory().newSAXParser();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Digester.getParser: ", e);
            return null;
        }
        return this.parser;
    }

    public Object getProperty(String property) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(property);
    }

    public void setProperty(String property, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getParser().setProperty(property, value);
    }

    public XMLReader getReader() {
        try {
            return this.getXMLReader();
        }
        catch (SAXException e) {
            this.log.log(Level.SEVERE, "Cannot get XMLReader", e);
            return null;
        }
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new RulesBase();
            this.rules.setDigester(this);
        }
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public String getSchema() {
        return this.schemaLocation;
    }

    public void setSchema(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean getRulesValidation() {
        return this.rulesValidation;
    }

    public void setRulesValidation(boolean rulesValidation) {
        this.rulesValidation = rulesValidation;
    }

    public Map<Class<?>, List<String>> getFakeAttributes() {
        return this.fakeAttributes;
    }

    public boolean isFakeAttribute(Object object, String name) {
        if (this.fakeAttributes == null) {
            return false;
        }
        List<String> result = this.fakeAttributes.get(object.getClass());
        if (result == null) {
            result = this.fakeAttributes.get(Object.class);
        }
        if (result == null) {
            return false;
        }
        return result.contains(name);
    }

    public void setFakeAttributes(Map<Class<?>, List<String>> fakeAttributes) {
        this.fakeAttributes = fakeAttributes;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
        }
        this.reader.setDTDHandler(this);
        this.reader.setContentHandler(this);
        if (this.entityResolver == null) {
            this.reader.setEntityResolver(this);
        } else {
            this.reader.setEntityResolver(this.entityResolver);
        }
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    @Override
    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("characters(" + new String(buffer, start, length) + ")");
        }
        this.bodyText.append(buffer, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            if (this.getCount() > 1) {
                this.saxLog.fine("endDocument():  " + this.getCount() + " elements left");
            } else {
                this.saxLog.fine("endDocument()");
            }
        }
        while (this.getCount() > 1) {
            this.pop();
        }
        for (Rule rule : this.getRules().rules()) {
            try {
                rule.finish();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Finish event threw exception", e);
                throw this.createSAXException(e);
            }
            catch (Error e) {
                this.log.log(Level.SEVERE, "Finish event threw error", e);
                throw e;
            }
        }
        this.clear();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        int slash;
        Rule rule;
        List<Rule> rules;
        boolean debug = this.log.isLoggable(Level.FINE);
        if (debug) {
            if (this.saxLog.isLoggable(Level.FINE)) {
                this.saxLog.fine("endElement(" + namespaceURI + "," + localName + "," + qName + ")");
            }
            this.log.fine("  match='" + this.match + "'");
            this.log.fine("  bodyText='" + this.bodyText + "'");
        }
        this.bodyText = this.updateBodyText(this.bodyText);
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        if ((rules = this.matches.pop()) != null && rules.size() > 0) {
            String bodyText = this.bodyText.toString();
            for (int i = 0; i < rules.size(); ++i) {
                try {
                    rule = rules.get(i);
                    if (debug) {
                        this.log.fine("  Fire body() for " + rule);
                    }
                    rule.body(namespaceURI, name, bodyText);
                    continue;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Body event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.log(Level.SEVERE, "Body event threw error", e);
                    throw e;
                }
            }
        } else {
            if (debug) {
                this.log.fine("  No rules found matching '" + this.match + "'.");
            }
            if (this.rulesValidation) {
                this.log.warning("  No rules found matching '" + this.match + "'.");
            }
        }
        this.bodyText = this.bodyTexts.pop();
        if (debug) {
            this.log.fine("  Popping body text '" + this.bodyText.toString() + "'");
        }
        if (rules != null) {
            for (int i = 0; i < rules.size(); ++i) {
                int j = rules.size() - i - 1;
                try {
                    rule = rules.get(j);
                    if (debug) {
                        this.log.fine("  Fire end() for " + rule);
                    }
                    rule.end(namespaceURI, name);
                    continue;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "End event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.log(Level.SEVERE, "End event threw error", e);
                    throw e;
                }
            }
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        ArrayStack<String> stack;
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("endPrefixMapping(" + prefix + ")");
        }
        if ((stack = this.namespaces.get(prefix)) == null) {
            return;
        }
        try {
            stack.pop();
            if (stack.empty()) {
                this.namespaces.remove(prefix);
            }
        }
        catch (EmptyStackException e) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    @Override
    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("ignorableWhitespace(" + new String(buffer, start, len) + ")");
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("processingInstruction('" + target + "','" + data + "')");
        }
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("setDocumentLocator(" + locator + ")");
        }
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("skippedEntity(" + name + ")");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("startDocument()");
        }
        this.configure();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        boolean debug = this.log.isLoggable(Level.FINE);
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("startElement(" + namespaceURI + "," + localName + "," + qName + ")");
        }
        list = this.updateAttributes(list);
        this.bodyTexts.push(this.bodyText);
        if (debug) {
            this.log.fine("  Pushing body text '" + this.bodyText.toString() + "'");
        }
        this.bodyText = new StringBuffer();
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        StringBuffer sb = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            sb.append('/');
        }
        sb.append(name);
        this.match = sb.toString();
        if (debug) {
            this.log.fine("  New match='" + this.match + "'");
        }
        List<Rule> rules = this.getRules().match(namespaceURI, this.match);
        this.matches.push(rules);
        if (rules != null && rules.size() > 0) {
            for (int i = 0; i < rules.size(); ++i) {
                try {
                    Rule rule = rules.get(i);
                    if (debug) {
                        this.log.fine("  Fire begin() for " + rule);
                    }
                    rule.begin(namespaceURI, name, list);
                    continue;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Begin event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.log(Level.SEVERE, "Begin event threw error", e);
                    throw e;
                }
            }
        } else if (debug) {
            this.log.fine("  No rules found matching '" + this.match + "'.");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        ArrayStack<String> stack;
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("startPrefixMapping(" + prefix + "," + namespaceURI + ")");
        }
        if ((stack = this.namespaces.get(prefix)) == null) {
            stack = new ArrayStack();
            this.namespaces.put(prefix, stack);
        }
        stack.push(namespaceURI);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("notationDecl(" + name + "," + publicId + "," + systemId + ")");
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("unparsedEntityDecl(" + name + "," + publicId + "," + systemId + "," + notation + ")");
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.saxLog.isLoggable(Level.FINE)) {
            this.saxLog.fine("resolveEntity('" + publicId + "', '" + systemId + "')");
        }
        if (publicId != null) {
            this.publicId = publicId;
        }
        String entityURL = null;
        if (publicId != null) {
            entityURL = this.entityValidator.get(publicId);
        }
        if (this.schemaLocation != null && entityURL == null && systemId != null) {
            entityURL = this.entityValidator.get(systemId);
        }
        if (entityURL == null) {
            if (systemId == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(" Cannot resolve entity: '" + entityURL + "'");
                }
                return null;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(" Trying to resolve using system ID '" + systemId + "'");
            }
            entityURL = systemId;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(" Resolving to alternate DTD '" + entityURL + "'");
        }
        try {
            return new InputSource(entityURL);
        }
        catch (Exception e) {
            throw this.createSAXException(e);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log.log(Level.SEVERE, "Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log.log(Level.SEVERE, "Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.log.warning("Parse Warning Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage());
            this.errorHandler.warning(exception);
        }
    }

    public void log(String message) {
        this.log.info(message);
    }

    public void log(String message, Throwable exception) {
        this.log.log(Level.SEVERE, message, exception);
    }

    public Object parse(File file) throws IOException, SAXException {
        this.configure();
        InputSource input = new InputSource(new FileInputStream(file));
        input.setSystemId("file://" + file.getAbsolutePath());
        this.getXMLReader().parse(input);
        return this.root;
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        this.configure();
        this.getXMLReader().parse(input);
        return this.root;
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        this.configure();
        InputSource is = new InputSource(input);
        this.getXMLReader().parse(is);
        return this.root;
    }

    public Object parse(Reader reader) throws IOException, SAXException {
        this.configure();
        InputSource is = new InputSource(reader);
        this.getXMLReader().parse(is);
        return this.root;
    }

    public Object parse(String uri) throws IOException, SAXException {
        this.configure();
        InputSource is = new InputSource(uri);
        this.getXMLReader().parse(is);
        return this.root;
    }

    public void register(String publicId, String entityURL) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("register('" + publicId + "', '" + entityURL + "'");
        }
        this.entityValidator.put(publicId, entityURL);
    }

    public void addRule(String pattern, Rule rule) {
        rule.setDigester(this);
        this.getRules().add(pattern, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        String oldNamespaceURI = this.getRuleNamespaceURI();
        String newNamespaceURI = ruleSet.getNamespaceURI();
        if (this.log.isLoggable(Level.FINE)) {
            if (newNamespaceURI == null) {
                this.log.fine("addRuleSet() with no namespace URI");
            } else {
                this.log.fine("addRuleSet() with namespace URI " + newNamespaceURI);
            }
        }
        this.setRuleNamespaceURI(newNamespaceURI);
        ruleSet.addRuleInstances(this);
        this.setRuleNamespaceURI(oldNamespaceURI);
    }

    public void addCallMethod(String pattern, String methodName) {
        this.addRule(pattern, new CallMethodRule(methodName));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, String[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount, paramTypes));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, Class<?>[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount, paramTypes));
    }

    public void addCallParam(String pattern, int paramIndex) {
        this.addRule(pattern, new CallParamRule(paramIndex));
    }

    public void addCallParam(String pattern, int paramIndex, String attributeName) {
        this.addRule(pattern, new CallParamRule(paramIndex, attributeName));
    }

    public void addCallParam(String pattern, int paramIndex, boolean fromStack) {
        this.addRule(pattern, new CallParamRule(paramIndex, fromStack));
    }

    public void addCallParam(String pattern, int paramIndex, int stackIndex) {
        this.addRule(pattern, new CallParamRule(paramIndex, stackIndex));
    }

    public void addCallParamPath(String pattern, int paramIndex) {
        this.addRule(pattern, new PathCallParamRule(paramIndex));
    }

    public void addObjectParam(String pattern, int paramIndex, Object paramObj) {
        this.addRule(pattern, new ObjectParamRule(paramIndex, paramObj));
    }

    public void addFactoryCreate(String pattern, String className) {
        this.addFactoryCreate(pattern, className, false);
    }

    public void addFactoryCreate(String pattern, Class<?> clazz) {
        this.addFactoryCreate(pattern, clazz, false);
    }

    public void addFactoryCreate(String pattern, String className, String attributeName) {
        this.addFactoryCreate(pattern, className, attributeName, false);
    }

    public void addFactoryCreate(String pattern, Class<?> clazz, String attributeName) {
        this.addFactoryCreate(pattern, clazz, attributeName, false);
    }

    public void addFactoryCreate(String pattern, ObjectCreationFactory creationFactory) {
        this.addFactoryCreate(pattern, creationFactory, false);
    }

    public void addFactoryCreate(String pattern, String className, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(className, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, Class<?> clazz, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(clazz, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, String className, String attributeName, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(className, attributeName, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, Class clazz, String attributeName, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(clazz, attributeName, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, ObjectCreationFactory creationFactory, boolean ignoreCreateExceptions) {
        creationFactory.setDigester(this);
        this.addRule(pattern, new FactoryCreateRule(creationFactory, ignoreCreateExceptions));
    }

    public void addObjectCreate(String pattern, String className) {
        this.addRule(pattern, new ObjectCreateRule(className));
    }

    public void addObjectCreate(String pattern, Class<?> clazz) {
        this.addRule(pattern, new ObjectCreateRule(clazz));
    }

    public void addObjectCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new ObjectCreateRule(className, attributeName));
    }

    public void addObjectCreate(String pattern, String attributeName, Class<?> clazz) {
        this.addRule(pattern, new ObjectCreateRule(attributeName, clazz));
    }

    public void addSetNext(String pattern, String methodName) {
        this.addRule(pattern, new SetNextRule(methodName));
    }

    public void addSetNext(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetNextRule(methodName, paramType));
    }

    public void addSetRoot(String pattern, String methodName) {
        this.addRule(pattern, new SetRootRule(methodName));
    }

    public void addSetRoot(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetRootRule(methodName, paramType));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new SetPropertiesRule());
    }

    public void addSetProperties(String pattern, String attributeName, String propertyName) {
        this.addRule(pattern, new SetPropertiesRule(attributeName, propertyName));
    }

    public void addSetProperties(String pattern, String[] attributeNames, String[] propertyNames) {
        this.addRule(pattern, new SetPropertiesRule(attributeNames, propertyNames));
    }

    public void addSetProperty(String pattern, String name, String value) {
        this.addRule(pattern, new SetPropertyRule(name, value));
    }

    public void addSetTop(String pattern, String methodName) {
        this.addRule(pattern, new SetTopRule(methodName));
    }

    public void addSetTop(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetTopRule(methodName, paramType));
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.params.clear();
        this.publicId = null;
        this.stack.clear();
        this.log = null;
        this.saxLog = null;
        this.configured = false;
    }

    public void reset() {
        this.root = null;
        this.setErrorHandler(null);
        this.clear();
    }

    public Object peek() {
        try {
            return this.stack.peek();
        }
        catch (EmptyStackException e) {
            this.log.warning("Empty stack (returning null)");
            return null;
        }
    }

    public Object peek(int n) {
        try {
            return this.stack.peek(n);
        }
        catch (EmptyStackException e) {
            this.log.warning("Empty stack (returning null)");
            return null;
        }
    }

    public Object pop() {
        try {
            return this.stack.pop();
        }
        catch (EmptyStackException e) {
            this.log.warning("Empty stack (returning null)");
            return null;
        }
    }

    public void push(Object object) {
        if (this.stack.size() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    public void push(String stackName, Object value) {
        ArrayStack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack == null) {
            namedStack = new ArrayStack();
            this.stacksByName.put(stackName, namedStack);
        }
        namedStack.push(value);
    }

    public Object pop(String stackName) {
        Object result = null;
        ArrayStack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack == null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Stack '" + stackName + "' is empty");
            }
            throw new EmptyStackException();
        }
        result = namedStack.pop();
        return result;
    }

    public Object peek(String stackName) {
        Object result = null;
        ArrayStack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack == null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Stack '" + stackName + "' is empty");
            }
            throw new EmptyStackException();
        }
        result = namedStack.peek();
        return result;
    }

    public boolean isEmpty(String stackName) {
        boolean result = true;
        ArrayStack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack != null) {
            result = namedStack.isEmpty();
        }
        return result;
    }

    public Object getRoot() {
        return this.root;
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.log = Logger.getLogger("org.apache.tomcat.util.digester.Digester");
        this.saxLog = Logger.getLogger("org.apache.tomcat.util.digester.Digester.sax");
        this.initialize();
        this.configured = true;
    }

    protected void initialize() {
    }

    Map<String, String> getRegistrations() {
        return this.entityValidator;
    }

    public Object peekParams() {
        try {
            return this.params.peek();
        }
        catch (EmptyStackException e) {
            this.log.warning("Empty stack (returning null)");
            return null;
        }
    }

    public Object peekParams(int n) {
        try {
            return this.params.peek(n);
        }
        catch (EmptyStackException e) {
            this.log.warning("Empty stack (returning null)");
            return null;
        }
    }

    public Object popParams() {
        try {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Popping params");
            }
            return this.params.pop();
        }
        catch (EmptyStackException e) {
            this.log.warning("Empty stack (returning null)");
            return null;
        }
    }

    public void pushParams(Object object) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Pushing params");
        }
        this.params.push(object);
    }

    public SAXException createSAXException(String message, Exception e) {
        Throwable t;
        if (e != null && e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) != null && t instanceof Exception) {
            e = (Exception)t;
        }
        if (this.locator != null) {
            String error = "Error at (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + ": " + message;
            if (e != null) {
                return new SAXParseException(error, this.locator, e);
            }
            return new SAXParseException(error, this.locator);
        }
        this.log.log(Level.SEVERE, "No Locator!");
        if (e != null) {
            return new SAXException(message, e);
        }
        return new SAXException(message);
    }

    public SAXException createSAXException(Exception e) {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) != null && t instanceof Exception) {
            e = (Exception)t;
        }
        return this.createSAXException(e.getMessage(), e);
    }

    public SAXException createSAXException(String message) {
        return this.createSAXException(message, null);
    }

    private Attributes updateAttributes(Attributes list) {
        if (list.getLength() == 0) {
            return list;
        }
        AttributesImpl newAttrs = new AttributesImpl(list);
        int nAttributes = newAttrs.getLength();
        for (int i = 0; i < nAttributes; ++i) {
            String value = newAttrs.getValue(i);
            try {
                String newValue = IntrospectionUtils.replaceProperties((String)value, null, (IntrospectionUtils.PropertySource[])source);
                if (value == newValue) continue;
                newAttrs.setValue(i, newValue);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return newAttrs;
    }

    private StringBuffer updateBodyText(StringBuffer bodyText) {
        String out;
        String in = bodyText.toString();
        try {
            out = IntrospectionUtils.replaceProperties((String)in, null, (IntrospectionUtils.PropertySource[])source);
        }
        catch (Exception e) {
            return bodyText;
        }
        if (out.equals(in)) {
            return bodyText;
        }
        return new StringBuffer(out);
    }

    private static class SystemPropertySource
    implements IntrospectionUtils.PropertySource {
        private SystemPropertySource() {
        }

        public String getProperty(String key) {
            return System.getProperty(key);
        }
    }
}

