/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.api.statistics.CountStatistic;
import org.glassfish.api.statistics.TimeStatistic;
import org.glassfish.api.statistics.impl.CountStatisticImpl;
import org.glassfish.api.statistics.impl.TimeStatisticImpl;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;
import org.jvnet.hk2.component.PostConstruct;

@ManagedObject
@Description(value="Web Container HTTP Service Statistics")
public class HttpServiceStatsProvider
implements PostConstruct {
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Number of responses with a status code greater than 400");
    private CountStatisticImpl error200Count = new CountStatisticImpl("Count200", "count", "Number of responses with a status code equal to 200");
    private CountStatisticImpl error2xxCount = new CountStatisticImpl("Count2xx", "count", "Number of responses with a status code in the 2xx range");
    private CountStatisticImpl error302Count = new CountStatisticImpl("Count302", "count", "Number of responses with a status code equal to 302");
    private CountStatisticImpl error304Count = new CountStatisticImpl("Count304", "count", "Number of responses with a status code equal to 304");
    private CountStatisticImpl error3xxCount = new CountStatisticImpl("Count3xx", "count", "Number of responses with a status code in the 3xx range");
    private CountStatisticImpl error400Count = new CountStatisticImpl("Count400", "count", "Number of responses with a status code equal to 400");
    private CountStatisticImpl error401Count = new CountStatisticImpl("Count401", "count", "Number of responses with a status code equal to 401");
    private CountStatisticImpl error403Count = new CountStatisticImpl("Count403", "count", "Number of responses with a status code equal to 403");
    private CountStatisticImpl error404Count = new CountStatisticImpl("Count404", "count", "Number of responses with a status code equal to 404");
    private CountStatisticImpl error4xxCount = new CountStatisticImpl("Count4xx", "count", "Number of responses with a status code in the 4xx range");
    private CountStatisticImpl error503Count = new CountStatisticImpl("Count503", "count", "Number of responses with a status code equal to 503");
    private CountStatisticImpl error5xxCount = new CountStatisticImpl("Count5xx", "count", "Number of responses with a status code in the 5xx range");
    private CountStatisticImpl errorOtherCount = new CountStatisticImpl("CountOther", "count", "Number of responses with other status codes");
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Logger logger = Logger.getLogger(HttpServiceStatsProvider.class.getName());
    private String virtualServerName = null;
    private HashMap<String, CountStatisticImpl> errorMap = new HashMap();

    public HttpServiceStatsProvider(String vsName) {
        this.virtualServerName = vsName;
        this.errorMap.put("200", this.error200Count);
        this.errorMap.put("2", this.error2xxCount);
        this.errorMap.put("302", this.error302Count);
        this.errorMap.put("304", this.error304Count);
        this.errorMap.put("3", this.error3xxCount);
        this.errorMap.put("400", this.error400Count);
        this.errorMap.put("401", this.error401Count);
        this.errorMap.put("403", this.error403Count);
        this.errorMap.put("404", this.error404Count);
        this.errorMap.put("4", this.error4xxCount);
        this.errorMap.put("503", this.error503Count);
        this.errorMap.put("5", this.error5xxCount);
        this.errorMap.put("9", this.errorOtherCount);
    }

    public void postConstruct() {
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Provides the longest response time for a response - not a cumulative value, but the largest response time from among response times.")
    public TimeStatistic getMaximumTime() {
        TimeStatisticImpl maxTime = new TimeStatisticImpl(this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "MaxTime", "milliseconds", "Provides the longest response time for a response - not a cumulative value, but the largest response time from among response times.", this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
        return maxTime;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Provides cumulative number of requests processed so far")
    public CountStatistic getCount() {
        CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Provides cumulative number of requests processed so far.");
        requestCount.setCount(this.requestProcessTime.getCount());
        return requestCount;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Provides cumulative value of the times taken to process each request The processing time is the average request processing times over the request count.")
    public TimeStatistic getTime() {
        TimeStatisticImpl processingTime = new TimeStatisticImpl((long)this.requestProcessTime.getTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "ProcessingTime", "milliseconds", "Provides cumulative value of the times taken to process each request The processing time is the average request processing times over the request count.", this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
        return processingTime;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="")
    public CountStatistic getErrorCount() {
        return this.errorCount.getStatistic();
    }

    @ManagedAttribute(id="count200")
    @Description(value="")
    public CountStatistic getError200Count() {
        return this.error200Count.getStatistic();
    }

    @ManagedAttribute(id="count2xx")
    @Description(value="")
    public CountStatistic getError2xxCount() {
        return this.error2xxCount.getStatistic();
    }

    @ManagedAttribute(id="count302")
    @Description(value="")
    public CountStatistic getError302Count() {
        return this.error302Count.getStatistic();
    }

    @ManagedAttribute(id="count304")
    @Description(value="")
    public CountStatistic getError304Count() {
        return this.error304Count.getStatistic();
    }

    @ManagedAttribute(id="count3xx")
    @Description(value="")
    public CountStatistic getError3xxCount() {
        return this.error3xxCount.getStatistic();
    }

    @ManagedAttribute(id="count400")
    @Description(value="")
    public CountStatistic getError400Count() {
        return this.error400Count.getStatistic();
    }

    @ManagedAttribute(id="count401")
    @Description(value="")
    public CountStatistic getError401Count() {
        return this.error401Count.getStatistic();
    }

    @ManagedAttribute(id="count403")
    @Description(value="")
    public CountStatistic getError403Count() {
        return this.error403Count.getStatistic();
    }

    @ManagedAttribute(id="count404")
    @Description(value="")
    public CountStatistic getError404Count() {
        return this.error404Count.getStatistic();
    }

    @ManagedAttribute(id="count4xx")
    @Description(value="")
    public CountStatistic getError4xxCount() {
        return this.error4xxCount.getStatistic();
    }

    @ManagedAttribute(id="count503")
    @Description(value="")
    public CountStatistic getError503Count() {
        return this.error503Count.getStatistic();
    }

    @ManagedAttribute(id="count5xx")
    @Description(value="")
    public CountStatistic getError5xxCount() {
        return this.error5xxCount.getStatistic();
    }

    @ManagedAttribute(id="countother")
    @Description(value="")
    public CountStatistic getErrorOtherCount() {
        return this.errorOtherCount.getStatistic();
    }

    @ProbeListener(value="glassfish:web:httpService:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="hostName") String hostName) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.requestProcessTime.entry();
            Logger.getLogger(HttpServiceStatsProvider.class.getName()).finest("[TM]requestStartEvent received - virtual-server = " + request.getServerName() + " : port = " + request.getServerPort());
            this.logger.finest("[TM]requestStartEvent received - virtual-server = " + request.getServerName() + " : port = " + request.getServerPort());
        }
    }

    @ProbeListener(value="glassfish:web:httpService:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="statusCode") int statusCode) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.requestProcessTime.exit();
            this.incrementStatsCounter(statusCode);
            this.logger.finest("[TM]requestEndEvent received - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    private void incrementStatsCounter(int statusCode) {
        CountStatisticImpl errorCounter = this.errorMap.get(Integer.toString(statusCode));
        if (errorCounter == null) {
            errorCounter = this.errorMap.get(Integer.toString(Math.round(statusCode / 100)));
        }
        if (errorCounter == null) {
            errorCounter = this.errorMap.get("9");
        }
        errorCounter.increment();
        if (statusCode > 400) {
            this.errorCount.increment();
        }
    }
}

