/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.web.plugin.common.WebModuleConfig;
import org.glassfish.web.plugin.common.WebModuleConfigCommand;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="set-web-context-param")
@I18n(value="setWebContextParam.command")
@Scoped(value=PerLookup.class)
public class SetWebContextParamCommand
extends WebModuleConfigCommand {
    @Param(name="name")
    private String name;
    @Param(name="value", optional=true)
    private String value;
    @Param(name="description", optional=true)
    private String description;
    @Param(name="ignoreDescriptorItem", optional=true)
    private Boolean ignoreDescriptorItem;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            WebModuleConfig config = this.webModuleConfigCreateIfNeeded(report);
            if (config == null) {
                return;
            }
            WebModuleConfig.Duck.setContextParam(config, this.name, this.value, this.description, this.ignoreDescriptorItem);
        }
        catch (Exception e) {
            this.fail(report, e, "errSetContextParam", "Error setting context param", new Object[0]);
        }
    }
}

