/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor.statistics;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.admin.monitor.cli.MonitorContract;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.statistics.StringStatistic;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.j2ee.statistics.CountStatistic;
import org.glassfish.j2ee.statistics.Statistic;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class WebModuleVirtualServerStatsImpl
implements MonitorContract {
    @Param(optional=true)
    String appName;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebModuleVirtualServerStatsImpl.class);
    private final String name = "webmodule";
    private final String displayFormat = "%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s";

    public String getName() {
        return "webmodule";
    }

    public ActionReport process(ActionReport report, String filter) {
        if (this.mrdr == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry is null"));
            return report;
        }
        TreeNode serverNode = this.mrdr.get("server");
        if (serverNode == null) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(this.localStrings.getLocalString("mrdr.null", "MonitoringRuntimeDataRegistry server node is null"));
            return report;
        }
        String[] patternArr = this.appName != null ? new String[]{"server.applications." + this.appName + ".*.*"} : new String[]{"server.web.session.*", "server.web.servlet.*", "server.web.jsp.*"};
        long activeSessionsCurrent = 0L;
        long activatedSessionsTotal = 0L;
        long rejectedSessionsTotal = 0L;
        long sessionsTotal = 0L;
        long activeJspsLoadedCount = 0L;
        long maxJspsLoadedCount = 0L;
        long totalJspsLoadedCount = 0L;
        long activeServletsLoadedCount = 0L;
        long maxServletsLoadedCount = 0L;
        long totalServletsLoadedCount = 0L;
        long lval = 0L;
        for (String pattern : patternArr) {
            List tnL = serverNode.getNodes(pattern);
            for (TreeNode tn : tnL) {
                if (tn.hasChildNodes() || tn.getName() == null || tn.getValue() == null) continue;
                lval = (Long)tn.getValue();
                if ("activeSessionsCurrent".equals(tn.getName())) {
                    activeSessionsCurrent = lval;
                    continue;
                }
                if ("activatedSessionsTotal".equals(tn.getName())) {
                    activatedSessionsTotal = lval;
                    continue;
                }
                if ("rejectedSessionsTotal".equals(tn.getName())) {
                    rejectedSessionsTotal = lval;
                    continue;
                }
                if ("sessionsTotal".equals(tn.getName())) {
                    sessionsTotal = lval;
                    continue;
                }
                if ("activeJspsLoadedCount".equals(tn.getName())) {
                    activeJspsLoadedCount = lval;
                    continue;
                }
                if ("maxJspsLoadedCount".equals(tn.getName())) {
                    maxJspsLoadedCount = lval;
                    continue;
                }
                if ("totalJspsLoadedCount".equals(tn.getName())) {
                    totalJspsLoadedCount = lval;
                    continue;
                }
                if ("activeServletsLoadedCount".equals(tn.getName())) {
                    activeServletsLoadedCount = lval;
                    continue;
                }
                if ("maxServletsLoadedCount".equals(tn.getName())) {
                    maxServletsLoadedCount = lval;
                    continue;
                }
                if (!"totalServletsLoadedCount".equals(tn.getName())) continue;
                totalServletsLoadedCount = lval;
            }
        }
        report.setMessage(String.format("%1$-5s %2$-5s %3$-5s %4$-5s %5$-5s %6$-5s %7$-5s %8$-8s %9$-10s %10$-5s", activeSessionsCurrent, activatedSessionsTotal, rejectedSessionsTotal, sessionsTotal, activeJspsLoadedCount, maxJspsLoadedCount, totalJspsLoadedCount, activeServletsLoadedCount, maxServletsLoadedCount, totalServletsLoadedCount));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        return report;
    }

    public CountStatistic getRejectedSessionsTotal() {
        return null;
    }

    public CountStatistic getExpiredSessionsTotal() {
        return null;
    }

    public CountStatistic getActiveSessionsHigh() {
        return null;
    }

    public CountStatistic getActiveSessionsCurrent() {
        return null;
    }

    public CountStatistic getSessionsTotal() {
        return null;
    }

    public CountStatistic getJSPCount() {
        return null;
    }

    public CountStatistic getJSPReloadCount() {
        return null;
    }

    public CountStatistic getJSPErrorCount() {
        return null;
    }

    public CountStatistic getPassivatedSessionsCurrent() {
        return null;
    }

    public CountStatistic getServletProcessingTimes() {
        return null;
    }

    public StringStatistic getSessions() {
        return null;
    }

    public Statistic[] getStatistics() {
        return null;
    }

    public String[] getStatisticNames() {
        return null;
    }

    public Statistic getStatistic(String statisticName) {
        return null;
    }
}

