/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.embed.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Embedded;
import org.glassfish.api.container.Sniffer;
import org.glassfish.web.embed.ConfigException;
import org.glassfish.web.embed.Context;
import org.glassfish.web.embed.VirtualServer;
import org.glassfish.web.embed.WebBuilder;
import org.glassfish.web.embed.WebListener;
import org.glassfish.web.embed.config.WebContainerConfig;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EmbeddedWebContainer
implements org.glassfish.web.embed.EmbeddedWebContainer {
    @Inject
    Habitat habitat;
    private static Logger log = Logger.getLogger(EmbeddedWebContainer.class.getName());
    private org.glassfish.web.embed.impl.VirtualServer defaultVirtualServer = null;
    private Embedded embedded = new Embedded();
    private File path = null;

    public EmbeddedWebContainer() {
        this.embedded.setUseNaming(false);
    }

    public void setConfiguration(WebBuilder builder) {
        this.setPath(builder.getDocRootDir());
    }

    public List<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "web"));
        sniffers.add((Sniffer)this.habitat.getComponent(Sniffer.class, "webbeans"));
        Sniffer security = (Sniffer)this.habitat.getComponent(Sniffer.class, "Security");
        if (security != null) {
            sniffers.add(security);
        }
        return sniffers;
    }

    public void start() throws org.glassfish.api.embedded.LifecycleException {
        int port = 8080;
        String webListenerId = "http-listener-1";
        String virtualServerId = "server";
        String hostName = "localhost";
        String defaultDomain = "com.sun.appserv";
        try {
            Engine engine = this.embedded.createEngine();
            engine.setName(defaultDomain);
            ((StandardEngine)engine).setDomain(defaultDomain);
            engine.setDefaultHost(virtualServerId);
            engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
            org.glassfish.web.embed.impl.WebListener webListener = this.createWebListener(webListenerId, org.glassfish.web.embed.impl.WebListener.class);
            webListener.setPort(port);
            webListener.setDefaultHost(virtualServerId);
            webListener.setDomain(defaultDomain);
            WebListener[] webListeners = new org.glassfish.web.embed.impl.WebListener[]{webListener};
            File docRoot = this.getPath();
            this.defaultVirtualServer = (org.glassfish.web.embed.impl.VirtualServer)this.createVirtualServer(virtualServerId, docRoot, webListeners);
            this.defaultVirtualServer.addAlias(hostName);
            engine.addChild((Container)this.defaultVirtualServer);
            org.glassfish.web.embed.impl.Context context = (org.glassfish.web.embed.impl.Context)this.createContext(docRoot, null);
            this.defaultVirtualServer.addChild((Container)context);
            this.embedded.addEngine(engine);
            this.addWebListener(webListener);
            this.embedded.start();
        }
        catch (Exception e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    public void start(WebContainerConfig config) throws org.glassfish.api.embedded.LifecycleException {
        String defaultDomain = "com.sun.appserv";
        try {
            Engine engine = this.embedded.createEngine();
            engine.setName(defaultDomain);
            ((StandardEngine)engine).setDomain(defaultDomain);
            engine.setDefaultHost(config.getVirtualServerId());
            engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
            org.glassfish.web.embed.impl.WebListener webListener = this.createWebListener(config.getWebListenerId(), org.glassfish.web.embed.impl.WebListener.class);
            webListener.setPort(config.getPort());
            webListener.setDefaultHost(config.getVirtualServerId());
            webListener.setDomain(defaultDomain);
            WebListener[] webListeners = new org.glassfish.web.embed.impl.WebListener[]{webListener};
            File docRoot = this.getPath();
            this.defaultVirtualServer = (org.glassfish.web.embed.impl.VirtualServer)this.createVirtualServer(config.getVirtualServerId(), docRoot, webListeners);
            for (String alias : config.getHostNames()) {
                this.defaultVirtualServer.addAlias(alias);
            }
            engine.addChild((Container)this.defaultVirtualServer);
            org.glassfish.web.embed.impl.Context context = (org.glassfish.web.embed.impl.Context)this.createContext(docRoot, null);
            this.defaultVirtualServer.addChild((Container)context);
            this.embedded.addEngine(engine);
            this.addWebListener(webListener);
            this.embedded.start();
        }
        catch (Exception e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    public void stop() throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.embedded.stop();
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    public Context createContext(File docRoot, String contextRoot, ClassLoader classLoader) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating context '" + contextRoot + "' with docBase '" + docRoot.getPath() + "'");
        }
        org.glassfish.web.embed.impl.Context context = new org.glassfish.web.embed.impl.Context();
        context.setDocBase(docRoot.getPath());
        context.setPath(contextRoot);
        if (classLoader != null) {
            context.setParentClassLoader(classLoader);
        } else {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener((LifecycleListener)config);
        this.defaultVirtualServer.addChild((Container)context);
        return context;
    }

    public Context createContext(File docRoot, ClassLoader classLoader) {
        String contextRoot = "";
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating context '" + contextRoot + "' with docBase '" + docRoot.getPath() + "'");
        }
        org.glassfish.web.embed.impl.Context context = new org.glassfish.web.embed.impl.Context();
        context.setDocBase(docRoot.getPath());
        context.setPath(contextRoot);
        if (classLoader != null) {
            context.setParentClassLoader(classLoader);
        } else {
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        ContextConfig config = new ContextConfig();
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }

    public <T extends WebListener> T createWebListener(String id, Class<T> c) throws InstantiationException, IllegalAccessException {
        WebListener webListener = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating connector " + id);
        }
        try {
            webListener = (WebListener)c.newInstance();
            webListener.setId(id);
        }
        catch (Exception e) {
            log.severe("Couldn't create connector");
        }
        return (T)webListener;
    }

    public void addWebListener(WebListener webListener) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        if (this.findWebListener(webListener.getId()) != null) {
            throw new ConfigException("Connector with name '" + webListener.getId() + "' already exsits");
        }
        this.embedded.addConnector((Connector)webListener);
    }

    public WebListener findWebListener(String id) {
        org.glassfish.web.embed.impl.WebListener webListener = null;
        for (Connector connector : this.embedded.findConnectors()) {
            if (!connector.getName().equals(id)) continue;
            webListener = (org.glassfish.web.embed.impl.WebListener)connector;
        }
        return webListener;
    }

    public Collection<WebListener> getWebListeners() {
        WebListener[] connectors = (WebListener[])this.embedded.findConnectors();
        return Arrays.asList(connectors);
    }

    public void removeWebListener(WebListener webListener) throws org.glassfish.api.embedded.LifecycleException {
        try {
            this.embedded.removeConnector((Connector)webListener);
        }
        catch (LifecycleException e) {
            throw new org.glassfish.api.embedded.LifecycleException((Throwable)e);
        }
    }

    public VirtualServer createVirtualServer(String id, File docRoot, WebListener ... webListeners) {
        org.glassfish.web.embed.impl.VirtualServer virtualServer = new org.glassfish.web.embed.impl.VirtualServer();
        virtualServer.setName(id);
        virtualServer.setAppBase(docRoot.getPath());
        int[] ports = new int[webListeners.length];
        for (int i = 0; i < webListeners.length; ++i) {
            ports[i] = webListeners[i].getPort();
        }
        virtualServer.setPorts(ports);
        return virtualServer;
    }

    public void addVirtualServer(VirtualServer virtualServer) throws ConfigException, org.glassfish.api.embedded.LifecycleException {
        Engine[] engines = this.embedded.getEngines();
        if (engines[0].findChild(virtualServer.getId()) != null) {
            throw new ConfigException("VirtualServer with id " + virtualServer.getId() + " is already registered");
        }
        engines[0].addChild((Container)virtualServer);
    }

    public org.glassfish.web.embed.impl.VirtualServer findVirtualServer(String id) {
        Engine[] engines = this.embedded.getEngines();
        return (org.glassfish.web.embed.impl.VirtualServer)engines[0].findChild(id);
    }

    public Collection<VirtualServer> getVirtualServers() {
        Engine[] engines = this.embedded.getEngines();
        VirtualServer[] virtualServers = (VirtualServer[])engines[0].findChildren();
        return Arrays.asList(virtualServers);
    }

    public void removeVirtualServer(VirtualServer virtualServer) throws org.glassfish.api.embedded.LifecycleException {
        Engine[] engines = this.embedded.getEngines();
        engines[0].removeChild((Container)virtualServer);
    }

    public void setPath(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }
}

