/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.Version;
import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.JavaEEObjectStreamFactory;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebBundleVisitor;
import com.sun.enterprise.deployment.util.WebValidatorWithoutCL;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.util.Result;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.MapperUpdateListener;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.AdHocWebModule;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebDeployer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebPipeline;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.logger.FileLoggerHandler;
import com.sun.enterprise.web.logger.IASLogger;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.web.reconfig.HttpServiceConfigListener;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.hk2.component.ConstructorWomb;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspFactory;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.ServerInfo;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.xmlparser.ParserUtils;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.container.Container;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.glassfish.web.admin.monitor.JspProbeProvider;
import org.glassfish.web.admin.monitor.RequestProbeProvider;
import org.glassfish.web.admin.monitor.ServletProbeProvider;
import org.glassfish.web.admin.monitor.SessionProbeProvider;
import org.glassfish.web.admin.monitor.WebModuleProbeProvider;
import org.glassfish.web.admin.monitor.WebStatsProviderBootstrap;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ObservableBean;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="com.sun.enterprise.web.WebContainer")
public class WebContainer
implements Container,
PostConstruct,
PreDestroy,
EventListener {
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    static final int DEFAULT_REAP_INTERVAL = 60;
    public static final String JWS_APPCLIENT_EAR_NAME = "__JWSappclients";
    public static final String JWS_APPCLIENT_WAR_NAME = "sys";
    private static final String JWS_APPCLIENT_MODULE_NAME = "__JWSappclients:sys.war";
    private static final String DOL_DEPLOYMENT = "com.sun.enterprise.web.deployment.backend";
    protected static final Logger _logger = LogDomains.getLogger(WebContainer.class, (String)"javax.enterprise.system.container.web");
    protected static final ResourceBundle rb = _logger.getResourceBundle();
    protected static WebContainer webContainer;
    protected static boolean useDOLforDeployment;
    @Inject
    Domain domain;
    @Inject
    ServerContext _serverContext;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ComponentEnvManager componentEnvManager;
    @Inject(optional=true)
    DasConfig dasConfig;
    @Inject
    Events events;
    @Inject
    ClassLoaderHierarchy clh;
    @Inject
    GrizzlyService grizzlyService;
    @Inject
    LoggingConfigImpl logConfig;
    @Inject
    JavaEEObjectStreamFactory javaEEObjectStreamFactory;
    @Inject
    FileLoggerHandler logHandler;
    HashMap<String, Integer> portMap = new HashMap();
    HashMap<String, WebConnector> connectorMap = new HashMap();
    EmbeddedWebContainer _embedded;
    Engine engine;
    String instanceName;
    private String logLevel;
    private WebConnector jkConnector;
    protected boolean globalAccessLoggingEnabled = true;
    protected String globalAccessLogBufferSize = null;
    protected String globalAccessLogWriteInterval = null;
    protected int defaultRedirectPort = -1;
    protected boolean catalinaCachingAllowed = true;
    @Inject
    protected ServerEnvironment instance = null;
    private Server _serverBean = null;
    protected int _debug = 0;
    private String _modulesWorkRoot = null;
    private String modulesStubRoot = null;
    protected File _modulesRoot = null;
    private String _appsWorkRoot = null;
    private String appsStubRoot = null;
    private boolean _reloadingEnabled = false;
    private int _pollInterval = 2;
    protected boolean _started = false;
    protected boolean globalSSOEnabled = true;
    protected WebContainerFeatureFactory webContainerFeatureFactory;
    boolean instanceEnableCookies = true;
    private ServerConfigLookup serverConfigLookup;
    protected JspProbeProvider jspProbeProvider = null;
    protected RequestProbeProvider requestProbeProvider = null;
    protected ServletProbeProvider servletProbeProvider = null;
    protected SessionProbeProvider sessionProbeProvider = null;
    protected WebModuleProbeProvider webModuleProbeProvider = null;
    protected Habitat habitat;
    protected HttpServiceConfigListener configListener = null;
    private boolean isShutdown = false;
    private final Object mapperUpdateSync = new Object();
    private SecurityService securityService = null;

    public void postConstruct() {
        this.createProbeProviders();
        this.habitat = this._serverContext.getDefaultHabitat();
        this.createStatsProviders();
        WebContainer.setJspFactory();
        this._modulesWorkRoot = this.instance.getWebModuleCompileJspPath().getAbsolutePath();
        this._appsWorkRoot = this.instance.getApplicationCompileJspPath().getAbsolutePath();
        this._modulesRoot = this.instance.getApplicationRepositoryPath();
        this.modulesStubRoot = this.instance.getModuleStubPath();
        this.appsStubRoot = this.instance.getApplicationStubPath().getAbsolutePath();
        File root = this._serverContext.getInstallRoot();
        File libRoot = new File(root, "lib");
        File schemas = new File(libRoot, "schemas");
        File dtds = new File(libRoot, "dtds");
        try {
            ParserUtils.setSchemaResourcePrefix(schemas.toURI().toURL().toString());
            ParserUtils.setDtdResourcePrefix(dtds.toURI().toURL().toString());
            ParserUtils.setEntityResolver((EntityResolver)this.habitat.getComponent(EntityResolver.class, "web"));
        }
        catch (MalformedURLException e) {
            _logger.log(Level.SEVERE, "Exception setting the schemas/dtds location", e);
        }
        this.instanceName = this._serverContext.getInstanceName();
        this.webContainerFeatureFactory = (WebContainerFeatureFactory)this.habitat.getComponent(PEWebContainerFeatureFactoryImpl.class);
        Config cfg = (Config)this.habitat.getComponent(Config.class);
        this.serverConfigLookup = new ServerConfigLookup(cfg, this.clh);
        this.configureDynamicReloadingSettings();
        this.setDebugLevel();
        String maxDepth = null;
        if (cfg.getWebContainer() != null) {
            maxDepth = cfg.getWebContainer().getPropertyValue(DISPATCHER_MAX_DEPTH);
        }
        if (maxDepth != null) {
            int depth = -1;
            try {
                depth = Integer.parseInt(maxDepth);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (depth > 0) {
                Request.setMaxDispatchDepth((int)depth);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Maximum depth for nested request dispatches set to " + maxDepth);
                }
            }
        }
        String logServiceFile = null;
        Map logProps = null;
        try {
            logProps = this.logConfig.getLoggingProperties();
            if (logProps != null) {
                logServiceFile = (String)logProps.get("com.sun.enterprise.server.logging.GFFileHandler.file");
                this.logLevel = (String)logProps.get("org.apache.catalina.level");
            }
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "Unable to determine location of server.log file", ioe);
        }
        this._embedded = new EmbeddedWebContainer(this._serverContext, this, logServiceFile, this.logLevel, this.logHandler);
        this._embedded.setCatalinaHome(this.instance.getDomainRoot().getAbsolutePath());
        this._embedded.setCatalinaBase(this.instance.getDomainRoot().getAbsolutePath());
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        this.engine = this._embedded.createEngine();
        this.engine.setParentClassLoader(EmbeddedWebContainer.class.getClassLoader());
        this._embedded.addEngine(this.engine);
        ((StandardEngine)this.engine).setDomain(this._serverContext.getDefaultDomainName());
        this.engine.setName(this._serverContext.getDefaultDomainName());
        String serverInfo = System.getProperty("product.name");
        if (serverInfo == null) {
            ServerInfo.setServerInfo((String)Version.getVersion());
            ServerInfo.setPublicServerInfo((String)Version.getVersion());
        } else if (serverInfo.isEmpty()) {
            ServerInfo.setServerInfo((String)Version.getVersion());
            ServerInfo.setPublicServerInfo((String)serverInfo);
        } else {
            ServerInfo.setServerInfo((String)serverInfo);
            ServerInfo.setPublicServerInfo((String)serverInfo);
        }
        this.initInstanceSessionProperties();
        ConstructorWomb womb = new ConstructorWomb(HttpServiceConfigListener.class, this.habitat, null);
        this.configListener = (HttpServiceConfigListener)womb.get(null);
        ObservableBean httpServiceBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)this.configListener.httpService);
        httpServiceBean.addListener((ConfigListener)this.configListener);
        this.configListener.setContainer(this);
        this.configListener.setLogger(_logger);
        this.events.register((EventListener)this);
        this.grizzlyService.addMapperUpdateListener((MapperUpdateListener)this.configListener);
        List configs = this.domain.getConfigs().getConfig();
        for (Config aConfig : configs) {
            HttpService httpService = aConfig.getHttpService();
            NetworkConfig networkConfig = aConfig.getNetworkConfig();
            this.securityService = aConfig.getSecurityService();
            List listeners = networkConfig.getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : listeners) {
                if (ConfigBeansUtilities.toBoolean((String)listener.getJkEnabled())) {
                    this.createJKConnector(listener, httpService);
                    continue;
                }
                this.createHttpListener(listener, httpService);
            }
            this.createJKConnector(null, httpService);
            this.setDefaultRedirectPort(this.defaultRedirectPort);
            this.createHosts(httpService, this.securityService);
        }
        this.loadSystemDefaultWebModules();
        this._started = true;
        try {
            this._embedded.start();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to start web container", le);
            return;
        }
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.ALL_APPLICATIONS_PROCESSED)) {
            this.loadDefaultWebModulesAfterAllAppsProcessed();
        } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
            this.isShutdown = true;
        }
    }

    public void preDestroy() {
        try {
            this._embedded.stop();
        }
        catch (LifecycleException le) {
            _logger.log(Level.SEVERE, "Unable to stop web container", le);
            return;
        }
    }

    JavaEEObjectStreamFactory getJavaEEObjectStreamFactory() {
        return this.javaEEObjectStreamFactory;
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public ServletProbeProvider getServletProbeProvider() {
        return this.servletProbeProvider;
    }

    public JspProbeProvider getJspProbeProvider() {
        return this.jspProbeProvider;
    }

    public SessionProbeProvider getSessionProbeProvider() {
        return this.sessionProbeProvider;
    }

    public RequestProbeProvider getRequestProbeProvider() {
        return this.requestProbeProvider;
    }

    public WebModuleProbeProvider getWebModuleProbeProvider() {
        return this.webModuleProbeProvider;
    }

    public String getName() {
        return "Web";
    }

    public Class<? extends WebDeployer> getDeployer() {
        return WebDeployer.class;
    }

    public WebConnector getJkConnector() {
        return this.jkConnector;
    }

    protected WebConnector createHttpListener(NetworkListener listener, HttpService httpService) {
        return this.createHttpListener(listener, httpService, null);
    }

    protected WebConnector createHttpListener(NetworkListener listener, HttpService httpService, Mapper mapper) {
        String address;
        if (!Boolean.valueOf(listener.getEnabled()).booleanValue()) {
            return null;
        }
        int port = 8080;
        this.checkHostnameUniqueness(listener.getName(), httpService);
        try {
            port = Integer.parseInt(listener.getPort());
        }
        catch (NumberFormatException nfe) {
            String msg = rb.getString("pewebcontainer.http_listener.invalid_port");
            msg = MessageFormat.format(msg, listener.getPort(), listener.getName());
            throw new IllegalArgumentException(msg);
        }
        boolean isSecure = Boolean.valueOf(listener.findProtocol().getSecurityEnabled());
        if (isSecure && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = listener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        WebConnector connector = (WebConnector)this._embedded.createConnector(address, port, isSecure);
        if (mapper != null) {
            connector.setMapper(mapper);
        } else {
            for (Mapper m : this.habitat.getAllByContract(Mapper.class)) {
                if (m.getPort() != port) continue;
                connector.setMapper(m);
                break;
            }
        }
        _logger.info("Created HTTP listener " + listener.getName() + " on port " + listener.getPort());
        connector.setName(listener.getName());
        connector.setInstanceName(this.instanceName);
        connector.configure(listener, isSecure, httpService);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "create.listenerport", new Object[]{port, connector});
        }
        this._embedded.addConnector((Connector)connector);
        this.portMap.put(listener.getName(), Integer.valueOf(listener.getPort()));
        this.connectorMap.put(listener.getName(), connector);
        if (this.defaultRedirectPort != -1) {
            connector.setRedirectPort(this.defaultRedirectPort);
        }
        ObservableBean httpListenerBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)listener);
        httpListenerBean.addListener((ConfigListener)this.configListener);
        return connector;
    }

    protected WebConnector createJKConnector(NetworkListener networkListener, HttpService httpService) {
        String address;
        boolean isSecure;
        int port = 8009;
        if (networkListener == null) {
            String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
            if (portString == null) {
                return null;
            }
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                port = 8009;
            }
        } else {
            port = Integer.parseInt(networkListener.getPort());
        }
        if ((isSecure = Boolean.valueOf(networkListener.findProtocol().getSecurityEnabled()).booleanValue()) && this.defaultRedirectPort == -1) {
            this.defaultRedirectPort = port;
        }
        if ("any".equals(address = networkListener.getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
            address = null;
        }
        this.jkConnector = (WebConnector)this._embedded.createConnector(address, port, "ajp");
        this.jkConnector.configureJKProperties();
        String defaultHost = "server";
        String jkConnectorName = "jk-connector";
        if (networkListener != null) {
            defaultHost = networkListener.findProtocol().getHttp().getDefaultVirtualServer();
            jkConnectorName = networkListener.getName();
        }
        this.jkConnector.setDefaultHost(defaultHost);
        this.jkConnector.setName(jkConnectorName);
        this.jkConnector.setDomain(this._serverContext.getDefaultDomainName());
        this.jkConnector.setInstanceName(this.instanceName);
        this.jkConnector.configure(networkListener, isSecure, httpService);
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + port);
        for (Mapper m : this.habitat.getAllByContract(Mapper.class)) {
            if (m.getPort() != port) continue;
            this.jkConnector.setMapper(m);
            break;
        }
        this._embedded.addConnector((Connector)this.jkConnector);
        return this.jkConnector;
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors;
            for (Connector connector : connectors = this._embedded.getConnectors()) {
                if (connector.getRedirectPort() != -1) continue;
                connector.setRedirectPort(defaultRedirectPort);
            }
        }
    }

    public void configureHttpServiceProperties(HttpService httpService, PECoyoteConnector connector) {
        List httpServiceProps = httpService.getProperty();
        connector.setProxyHandler(new ProxyHandlerImpl());
        this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)httpService.getAccessLoggingEnabled());
        this.globalAccessLogWriteInterval = httpService.getAccessLog().getWriteIntervalSeconds();
        this.globalAccessLogBufferSize = httpService.getAccessLog().getBufferSizeBytes();
        if (httpServiceProps != null) {
            for (Property httpServiceProp : httpServiceProps) {
                String propValue;
                String propName = httpServiceProp.getName();
                if (connector.configureHttpListenerProperty(propName, propValue = httpServiceProp.getValue())) continue;
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBeansUtilities.toBoolean((String)propValue));
                    continue;
                }
                if ("ssl-session-timeout".equals(propName)) {
                    connector.setSSLSessionTimeout(propValue);
                    continue;
                }
                if ("ssl3-session-timeout".equals(propName)) {
                    connector.setSSL3SessionTimeout(propValue);
                    continue;
                }
                if ("ssl-cache-entries".equals(propName)) {
                    connector.setSSLSessionCacheSize(propValue);
                    continue;
                }
                if ("proxyHandler".equals(propName)) {
                    connector.setProxyHandler(propValue);
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProp.getName());
            }
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int j;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
            List vsListeners = StringUtils.parseStringList((String)vse.getNetworkListeners(), (String)",");
            for (j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals(vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vse);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (int i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List hosts = StringUtils.parseStringList((String)vs.getHosts(), (String)",");
            for (j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = (String)hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List otherHosts = StringUtils.parseStringList((String)otherVs.getHosts(), (String)",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals(otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    protected void createHosts(HttpService httpService, SecurityService securityService) {
        List virtualServers = httpService.getVirtualServer();
        for (com.sun.enterprise.config.serverbeans.VirtualServer vs : virtualServers) {
            this.createHost(vs, httpService, securityService);
            _logger.info("Created virtual server " + vs.getId());
        }
    }

    public VirtualServer createHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpService httpService, SecurityService securityService) {
        PEAccessLogValve accessLogValve;
        boolean startAccessLog;
        MimeMap mm = null;
        String vs_id = vsBean.getId();
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        this.validateDocroot(docroot, vs_id, vsBean.getDefaultWebModule());
        VirtualServer vs = this.createHost(vs_id, vsBean, docroot, mm);
        Property cacheProp = vsBean.getProperty("setCacheControl");
        if (cacheProp != null) {
            vs.configureCacheControl(cacheProp.getValue());
        }
        if ((startAccessLog = (accessLogValve = vs.getAccessLogValve()).configure(vs_id, vsBean, httpService, this.domain, this.habitat, this.webContainerFeatureFactory, this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval)) && vs.isAccessLoggingEnabled(this.globalAccessLoggingEnabled)) {
            vs.addValve((GlassFishValve)accessLogValve);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Created virtual server " + vs_id);
        }
        this.configureHost(vs, securityService);
        this.engine.addChild((org.apache.catalina.Container)vs);
        ObservableBean virtualServerBean = (ObservableBean)ConfigSupport.getImpl((ConfigBeanProxy)vsBean);
        virtualServerBean.addListener((ConfigListener)this.configListener);
        return vs;
    }

    protected void validateDocroot(String docroot, String vs_id, String defaultWebModule) {
        if (docroot == null) {
            return;
        }
        boolean isValid = new File(docroot).exists();
        if (!isValid) {
            String msg = rb.getString("pewebcontainer.virtual_server.invalid_docroot");
            msg = MessageFormat.format(msg, vs_id, docroot);
            throw new IllegalArgumentException(msg);
        }
    }

    protected void configureHost(VirtualServer vs, SecurityService securityService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        vs.configureAliases();
        List listeners = StringUtils.parseStringList((String)vsBean.getNetworkListeners(), (String)",");
        if (listeners == null) {
            return;
        }
        HashSet<NetworkListener> httpListeners = new HashSet<NetworkListener>();
        for (String listener : listeners) {
            boolean found = false;
            for (NetworkListener httpListener : this.habitat.getAllByContract(NetworkListener.class)) {
                if (!httpListener.getName().equals(listener)) continue;
                httpListeners.add(httpListener);
                found = true;
                break;
            }
            if (found) continue;
            _logger.log(Level.SEVERE, "Listener " + listener + " referenced by virtual server " + vs.getName() + " does not exist");
        }
        this.configureHostPortNumbers(vs, httpListeners);
        vs.configureCatalinaProperties();
        vs.configureAuthRealm(securityService);
    }

    protected void configureHostPortNumbers(VirtualServer vs, HashSet<NetworkListener> listeners) {
        boolean addJkListenerPort = this.jkConnector != null && !vs.getName().equalsIgnoreCase("__asadmin");
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        for (NetworkListener listener : listeners) {
            if (Boolean.valueOf(listener.getEnabled()).booleanValue()) {
                Integer port = this.portMap.get(listener.getName());
                if (port == null) continue;
                portsList.add(port);
                continue;
            }
            if (!vs.getName().equalsIgnoreCase("__asadmin")) continue;
            String msg = rb.getString("pewebcontainer.httpListener.mustNotDisable");
            msg = MessageFormat.format(msg, listener.getName(), vs.getName());
            throw new IllegalArgumentException(msg);
        }
        int numPorts = portsList.size();
        if (addJkListenerPort) {
            ++numPorts;
        }
        if (numPorts > 0) {
            int[] ports = new int[numPorts];
            int i = 0;
            for (i = 0; i < portsList.size(); ++i) {
                ports[i] = (Integer)portsList.get(i);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("Virtual Server " + vs.getID() + " set port " + ports[i]);
            }
            if (addJkListenerPort) {
                ports[i] = this.jkConnector.getPort();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Virtual Server " + vs.getID() + " set jk port " + ports[i]);
                }
            }
            vs.setPorts(ports);
        }
    }

    public VirtualServer createHost(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String docroot, MimeMap mimeMap) {
        VirtualServer vs = (VirtualServer)this._embedded.createHost(vsID, vsBean, docroot, vsBean.getLogFile(), mimeMap);
        vs.configureState();
        vs.configureRemoteAddressFilterValve();
        vs.configureRemoteHostFilterValve();
        vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory);
        vs.configureRedirect();
        vs.configureErrorPage();
        vs.configureErrorReportValve();
        return vs;
    }

    public void stop() throws LifecycleException {
        block3: {
            if (!this._started) {
                String msg = rb.getString("webcontainer.notStarted");
                throw new LifecycleException(msg);
            }
            this._started = false;
            try {
                this._embedded.stop();
            }
            catch (LifecycleException ex) {
                if (ex.getMessage().contains("has not been started")) break block3;
                throw ex;
            }
        }
    }

    public void loadSystemDefaultWebModules() {
        org.apache.catalina.Container[] vsArray;
        WebModuleConfig wmInfo = null;
        String defaultPath = null;
        for (org.apache.catalina.Container aVsArray : vsArray = this.getEngine().findChildren()) {
            VirtualServer vs;
            if (!(aVsArray instanceof VirtualServer) || "__asadmin".equals((vs = (VirtualServer)aVsArray).getName())) continue;
            wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebArchivist)this.habitat.getComponent(WebArchivist.class));
            if (wmInfo != null) {
                defaultPath = wmInfo.getContextPath();
                this.loadStandaloneWebModule(vs, wmInfo);
            }
            _logger.info("Virtual server " + vs.getName() + " loaded system default web module");
        }
    }

    public void loadDefaultWebModulesAfterAllAppsProcessed() {
        org.apache.catalina.Container[] vsArray;
        String defaultPath = null;
        for (org.apache.catalina.Container aVsArray : vsArray = this.getEngine().findChildren()) {
            WebModuleConfig wmInfo;
            VirtualServer vs;
            if (!(aVsArray instanceof VirtualServer) || "__asadmin".equals((vs = (VirtualServer)aVsArray).getName()) || (wmInfo = vs.getDefaultWebModule(this.domain, (WebArchivist)this.habitat.getComponent(WebArchivist.class), this.appRegistry)) == null) continue;
            defaultPath = wmInfo.getContextPath();
            try {
                this.updateDefaultWebModule(vs, vs.getPorts(), wmInfo);
            }
            catch (LifecycleException le) {
                String msg = rb.getString("webcontainer.defaultWebModuleError");
                msg = MessageFormat.format(msg, defaultPath, vs.getName());
                _logger.log(Level.SEVERE, msg, le);
            }
            _logger.info("Virtual server " + vs.getName() + " loaded default web module " + defaultPath);
        }
    }

    public void loadDefaultWebModule(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        VirtualServer virtualServer = (VirtualServer)this.getEngine().findChild(vsBean.getId());
        if (virtualServer != null) {
            this.loadDefaultWebModule(virtualServer);
        }
    }

    public void loadDefaultWebModule(VirtualServer vs) {
        String defaultPath = null;
        WebModuleConfig wmInfo = vs.getDefaultWebModule(this.domain, (WebArchivist)this.habitat.getComponent(WebArchivist.class), this.appRegistry);
        if (wmInfo != null) {
            defaultPath = wmInfo.getContextPath();
            try {
                this.updateDefaultWebModule(vs, vs.getPorts(), wmInfo);
            }
            catch (LifecycleException le) {
                String msg = rb.getString("webcontainer.defaultWebModuleError");
                msg = MessageFormat.format(msg, defaultPath, vs.getName());
                _logger.log(Level.SEVERE, msg, le);
            }
        } else {
            wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebArchivist)this.habitat.getComponent(WebArchivist.class));
            if (wmInfo != null) {
                defaultPath = wmInfo.getContextPath();
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
        _logger.info("Virtual server " + vs.getName() + " loaded default web module " + defaultPath);
    }

    protected void loadStandaloneWebModule(VirtualServer vs, WebModuleConfig wmInfo) {
        try {
            this.loadWebModule(vs, wmInfo, "null", null);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error loading web module " + wmInfo.getName(), t);
        }
    }

    protected boolean isEnabled(String moduleName) {
        return true;
    }

    public List<Result<WebModule>> loadWebModule(WebModuleConfig wmInfo, String j2eeApplication, Properties deploymentProperties) {
        org.apache.catalina.Container[] vsArray;
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList((String)vsIDs, (String)" ,");
        boolean loadToAll = vsList == null || vsList.size() == 0;
        ArrayList<Result<WebModule>> results = new ArrayList<Result<WebModule>>();
        for (org.apache.catalina.Container aVsArray : vsArray = this.getEngine().findChildren()) {
            VirtualServer vs;
            if (!(aVsArray instanceof VirtualServer) || (vs = (VirtualServer)aVsArray).getID().equals("__asadmin") && loadToAll || !loadToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
            WebModule ctx = null;
            try {
                ctx = this.loadWebModule(vs, wmInfo, j2eeApplication, deploymentProperties);
                results.add((Result<WebModule>)new Result((Object)ctx));
            }
            catch (Throwable t) {
                if (ctx != null) {
                    ctx.setAvailable(false);
                }
                results.add((Result<WebModule>)new Result(t));
            }
        }
        return results;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    private WebModule loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication, Properties deploymentProperties) throws Exception {
        ClassLoader parentLoader;
        WebBundleDescriptor wbd;
        String wmName = wmInfo.getName();
        String wmContextPath = wmInfo.getContextPath();
        if (wmContextPath.length() == 0 && vs.getDefaultWebModuleID() != null) {
            String msg = rb.getString("webcontainer.defaultWebModuleConflict");
            msg = MessageFormat.format(msg, wmName, wmContextPath, vs.getID());
            throw new Exception(msg);
        }
        if (wmName.indexOf(":") != -1) {
            wmInfo.setWorkDirBase(this._appsWorkRoot);
            wmInfo.setStubBaseDir(this.appsStubRoot);
        } else {
            wmInfo.setWorkDirBase(this._modulesWorkRoot);
            wmInfo.setStubBaseDir(this.modulesStubRoot);
        }
        String displayContextPath = null;
        displayContextPath = wmContextPath.length() == 0 ? "/" : wmContextPath;
        Map<String, AdHocServletInfo> adHocPaths = null;
        Map<String, AdHocServletInfo> adHocSubtrees = null;
        WebModule ctx = (WebModule)vs.findChild(wmContextPath);
        if (ctx != null) {
            if (ctx instanceof AdHocWebModule) {
                if (ctx.hasAdHocPaths()) {
                    adHocPaths = ctx.getAdHocPaths();
                }
                if (ctx.hasAdHocSubtrees()) {
                    adHocSubtrees = ctx.getAdHocSubtrees();
                }
                vs.removeChild((org.apache.catalina.Container)ctx);
            } else if ("__default-web-module".equals(ctx.getModuleName())) {
                this.unloadWebModule(wmContextPath, ctx.getJ2EEApplication(), vs.getName(), true, null);
            } else {
                if (!ctx.getAvailable()) {
                    ctx.setAvailable(true);
                    return ctx;
                }
                String msg = rb.getString("webcontainer.duplicateContextRoot");
                throw new Exception(MessageFormat.format(msg, vs.getID(), ctx.getModuleName(), displayContextPath, wmName));
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            Object[] params = new Object[]{wmName, vs.getID(), displayContextPath};
            _logger.log(Level.FINEST, "webcontainer.loadModule", params);
        }
        File docBase = null;
        docBase = JWS_APPCLIENT_MODULE_NAME.equals(wmName) ? new File(System.getProperty("com.sun.aas.installRoot")) : wmInfo.getLocation();
        ctx = (WebModule)this._embedded.createContext(wmName, wmContextPath, docBase, vs.getDefaultContextXmlLocation(), vs.getDefaultWebXmlLocation(), useDOLforDeployment, wmInfo);
        ctx.setUseNaming(false);
        Engine engine = (Engine)vs.getParent();
        if (engine != null) {
            ctx.setEngineName(engine.getName());
            ctx.setJvmRoute(engine.getJvmRoute());
        }
        String j2eeServer = this._serverContext.getInstanceName();
        String domain = this._serverContext.getDefaultDomainName();
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        ctx.setDomain(domain);
        ctx.setJ2EEServer(j2eeServer);
        ctx.setJ2EEApplication(j2eeApplication);
        ctx.setCachingAllowed(false);
        ctx.setCacheControls(vs.getCacheControls());
        ctx.setBean(wmInfo.getBean());
        if (adHocPaths != null) {
            ctx.addAdHocPaths(adHocPaths);
        }
        if (adHocSubtrees != null) {
            ctx.addAdHocSubtrees(adHocSubtrees);
        }
        if ((wbd = wmInfo.getDescriptor()) != null) {
            ctx.setContextRoot(wbd.getContextRoot());
        } else {
            _logger.log(Level.WARNING, "Unable to set context root", wmInfo);
        }
        String wmInfoWorkDir = wmInfo.getWorkDir();
        if (wmInfoWorkDir != null) {
            StringBuilder workDir = new StringBuilder(wmInfo.getWorkDir());
            if (wmName.equals("__default-web-module")) {
                workDir.append("-");
                workDir.append(FileUtils.makeFriendlyFilename((String)vs.getID()));
            }
            ctx.setWorkDir(workDir.toString());
        }
        if ((parentLoader = wmInfo.getParentLoader()) == null) {
            parentLoader = this._serverContext.getSharedClassLoader();
        }
        ctx.setParentClassLoader(parentLoader);
        if (wbd != null) {
            ctx.configureAlternateDD(wbd);
            ctx.configureWebServices(wbd);
        }
        SunWebApp iasBean = null;
        if (wbd != null) {
            iasBean = wbd.getSunDescriptor();
        }
        ctx.setIasWebAppConfigBean(iasBean);
        ctx.configureMiscSettings(iasBean, vs, displayContextPath);
        if (ctx.getID().startsWith("__default-web-module")) {
            ctx.setAlternateDocBases(vs.getProperties());
        }
        Loader loader = ctx.configureLoader(iasBean);
        if (wbd != null && wbd.hasWebServices()) {
            wbd.addExtraAttribute("WEBLOADER", (Object)loader);
        }
        ctx.configureSessionSettings(wbd, wmInfo);
        ctx.setI18nInfo();
        if (wbd != null) {
            boolean isSystem;
            String resourceType = wmInfo.getObjectType();
            boolean bl = isSystem = resourceType != null && resourceType.startsWith("system-");
            if (!wmName.startsWith("__default-web-module")) {
                Realm realm = (Realm)this.habitat.getByContract(Realm.class);
                if ("null".equals(j2eeApplication)) {
                    if (realm != null && realm instanceof RealmInitializer) {
                        ((RealmInitializer)realm).initializeRealm((Object)wbd, isSystem, vs.getAuthRealmName());
                        ctx.setRealm(realm);
                    }
                } else if (realm != null && realm instanceof RealmInitializer) {
                    ((RealmInitializer)realm).initializeRealm((Object)wbd, isSystem, null);
                    ctx.setRealm(realm);
                }
            }
            if (wbd.getApplication() != null && wbd.getApplication().isVirtual()) {
                wbd.visit((WebBundleVisitor)new WebValidatorWithoutCL());
            }
        }
        this.addMimeMappings(ctx, vs.getMimeMap());
        if (wbd != null && wbd.getApplication() != null) {
            String moduleName = wbd.getApplication().isVirtual() ? wbd.getApplication().getRegistrationName() : wbd.getModuleDescriptor().getArchiveUri();
            ctx.setModuleName(moduleName);
        } else {
            ctx.setModuleName("__default-web-module");
        }
        vs.addChild((org.apache.catalina.Container)ctx);
        ctx.loadSessions(deploymentProperties);
        return ctx;
    }

    protected void updateDefaultWebModule(VirtualServer virtualServer, int[] ports, WebModuleConfig wmInfo) throws LifecycleException {
        Connector[] connectors;
        String defaultContextPath = null;
        if (wmInfo != null) {
            defaultContextPath = wmInfo.getContextPath();
        }
        if (defaultContextPath != null && !defaultContextPath.startsWith("/")) {
            defaultContextPath = "/" + defaultContextPath;
            wmInfo.getDescriptor().setContextRoot(defaultContextPath);
        }
        for (Connector connector : connectors = this._embedded.findConnectors()) {
            PECoyoteConnector conn = (PECoyoteConnector)connector;
            int port = conn.getPort();
            for (int port1 : ports) {
                if (port != port1) continue;
                Mapper mapper = conn.getMapper();
                try {
                    mapper.setDefaultContextPath(virtualServer.getName(), defaultContextPath);
                    virtualServer.setDefaultContextPath(defaultContextPath);
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
    }

    public ServerContext getServerContext() {
        return this._serverContext;
    }

    ServerConfigLookup getServerConfigLookup() {
        return this.serverConfigLookup;
    }

    File getLibPath() {
        return this.instance.getLibPath();
    }

    public String getApplicationId(WebModule wm) {
        return wm.getID();
    }

    public File getModulesRoot() {
        return this._modulesRoot;
    }

    private String getPersistenceFrequency(SessionManager smBean) {
        String persistenceFrequency = null;
        ManagerProperties mgrBean = smBean.getManagerProperties();
        if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
            WebProperty[] props;
            for (WebProperty prop : props = mgrBean.getWebProperty()) {
                String name = prop.getAttributeValue("name");
                String value = prop.getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceFrequency")) continue;
                persistenceFrequency = value;
                break;
            }
        }
        return persistenceFrequency;
    }

    private String getPersistenceScope(SessionManager smBean) {
        String persistenceScope = null;
        StoreProperties storeBean = smBean.getStoreProperties();
        if (storeBean != null && storeBean.sizeWebProperty() > 0) {
            WebProperty[] props;
            for (WebProperty prop : props = storeBean.getWebProperty()) {
                String name = prop.getAttributeValue("name");
                String value = prop.getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceScope")) continue;
                persistenceScope = value;
                break;
            }
        }
        return persistenceScope;
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, Properties props) {
        this.unloadWebModule(contextRoot, appName, virtualServers, false, props);
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, boolean dummy, Properties props) {
        org.apache.catalina.Container[] hostArray;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer.unloadWebModule(): contextRoot: " + contextRoot + " appName:" + appName);
        }
        if (contextRoot.length() != 0 && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        } else if ("/".equals(contextRoot)) {
            contextRoot = "";
        }
        List hostList = StringUtils.parseStringList((String)virtualServers, (String)" ,");
        boolean unloadFromAll = hostList == null || hostList.isEmpty();
        boolean hasBeenUndeployed = false;
        VirtualServer host = null;
        WebModule context = null;
        for (org.apache.catalina.Container aHostArray : hostArray = this.getEngine().findChildren()) {
            WebModuleConfig wmInfo;
            host = (VirtualServer)aHostArray;
            if (unloadFromAll && host.getName().equalsIgnoreCase("__asadmin") || !unloadFromAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (WebModule)host.findChild(contextRoot)) == null) continue;
            context.saveSessions(props);
            host.removeChild((org.apache.catalina.Container)context);
            try {
                if (!this.isShutdown) {
                    context.destroy();
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "[WebContainer] Context " + contextRoot + " threw exception in destroy()", ex);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " undeployed from " + (Object)((Object)host));
            }
            hasBeenUndeployed = true;
            host.fireContainerEvent("remove", (Object)context);
            if (context.hasAdHocPaths() || context.hasAdHocSubtrees()) {
                WebModule wm = this.createAdHocWebModule(context.getID(), host, contextRoot, context.getJ2EEApplication());
                wm.addAdHocPaths(context.getAdHocPaths());
                wm.addAdHocSubtrees(context.getAdHocSubtrees());
            }
            if (dummy || (wmInfo = host.createSystemDefaultWebModuleIfNecessary((WebArchivist)this.habitat.getComponent(WebArchivist.class))) == null) continue;
            this.loadStandaloneWebModule(host, wmInfo);
        }
        if (!hasBeenUndeployed) {
            _logger.log(Level.SEVERE, "[WebContainer] Undeployment failed for context " + contextRoot);
        }
    }

    public boolean suspendWebModule(String contextRoot, String appName, String hosts) {
        List hostList;
        if (contextRoot.length() != 0 && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        boolean suspendOnAll = (hostList = StringUtils.parseStringList((String)hosts, (String)" ,")) == null || hostList.isEmpty();
        boolean hasBeenSuspended = false;
        VirtualServer host = null;
        Context context = null;
        for (org.apache.catalina.Container aHostArray : this.getEngine().findChildren()) {
            host = (VirtualServer)aHostArray;
            if (suspendOnAll && host.getName().equalsIgnoreCase("__asadmin") || !suspendOnAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (Context)host.findChild(contextRoot)) == null) continue;
            context.setAvailable(false);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " disabled from " + (Object)((Object)host));
            }
            hasBeenSuspended = true;
        }
        if (!hasBeenSuspended) {
            _logger.log(Level.WARNING, "[WebContainer] Unable to disable web module at context root " + contextRoot);
        }
        return hasBeenSuspended;
    }

    private void configureDynamicReloadingSettings() {
        if (this.dasConfig != null) {
            this._reloadingEnabled = Boolean.parseBoolean(this.dasConfig.getDynamicReloadEnabled());
            String seconds = this.dasConfig.getDynamicReloadPollIntervalInSeconds();
            if (seconds != null) {
                try {
                    this._pollInterval = Integer.parseInt(seconds);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setDebugLevel() {
        Level logLevel;
        Level level = logLevel = _logger.getLevel() != null ? _logger.getLevel() : Level.INFO;
        this._debug = logLevel.equals(Level.FINE) ? 1 : (logLevel.equals(Level.FINER) ? 2 : (logLevel.equals(Level.FINEST) ? 5 : 0));
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    List<VirtualServer> getVirtualServersForHttpListenerId(HttpService httpService, String httpListenerId) {
        if (httpListenerId == null) {
            return null;
        }
        ArrayList<VirtualServer> result = new ArrayList<VirtualServer>();
        block0: for (com.sun.enterprise.config.serverbeans.VirtualServer vs : httpService.getVirtualServer()) {
            List listeners = StringUtils.parseStringList((String)vs.getNetworkListeners(), (String)",");
            if (listeners == null) continue;
            ListIterator iter = listeners.listIterator();
            while (iter.hasNext()) {
                if (!httpListenerId.equals(iter.next())) continue;
                VirtualServer match = (VirtualServer)this.getEngine().findChild(vs.getId());
                if (match == null) continue block0;
                result.add(match);
                continue block0;
            }
        }
        return result;
    }

    private void addMimeMappings(StandardContext ctx, MimeMap mimeMap) {
        if (mimeMap == null) {
            return;
        }
        Iterator itr = mimeMap.getExtensions();
        while (itr.hasNext()) {
            String extension = (String)itr.next();
            if (ctx.findMimeMapping(extension) != null) continue;
            ctx.addMimeMapping(extension, mimeMap.getType(extension));
        }
    }

    private boolean isReferenced(String appName) {
        Servers servers = this.domain.getServers();
        for (Server server : servers.getServer()) {
            if (!server.getName().equals(this._serverContext.getInstanceName())) continue;
            for (ApplicationRef ref : server.getApplicationRef()) {
                if (!ref.getRef().equals(appName)) continue;
                return true;
            }
        }
        return false;
    }

    public Engine getEngine() {
        return this._embedded.getEngines()[0];
    }

    public void registerAdHocPath(String path, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        this.registerAdHocPathAndSubtree(path, null, ctxtRoot, appName, servletInfo);
    }

    public void registerAdHocPathAndSubtree(String path, String subtree, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        org.apache.catalina.Container[] vsList;
        WebModule wm = null;
        for (org.apache.catalina.Container aVsList : vsList = this.getEngine().findChildren()) {
            VirtualServer vs = (VirtualServer)aVsList;
            if (vs.getName().equalsIgnoreCase("__asadmin")) continue;
            wm = (WebModule)vs.findChild(ctxtRoot);
            if (wm == null) {
                wm = this.createAdHocWebModule(vs, ctxtRoot, appName);
            }
            wm.addAdHocPathAndSubtree(path, subtree, servletInfo);
        }
    }

    public void unregisterAdHocPath(String path, String ctxtRoot) {
        this.unregisterAdHocPathAndSubtree(path, null, ctxtRoot);
    }

    public void unregisterAdHocPathAndSubtree(String path, String subtree, String ctxtRoot) {
        org.apache.catalina.Container[] vsList;
        WebModule wm = null;
        for (org.apache.catalina.Container aVsList : vsList = this.getEngine().findChildren()) {
            VirtualServer vs = (VirtualServer)aVsList;
            if (vs.getName().equalsIgnoreCase("__asadmin") || (wm = (WebModule)vs.findChild(ctxtRoot)) == null) continue;
            wm.removeAdHocPath(path);
            wm.removeAdHocSubtree(subtree);
            if (!(wm instanceof AdHocWebModule) || wm.hasAdHocPaths() || wm.hasAdHocSubtrees()) continue;
            vs.removeChild((org.apache.catalina.Container)wm);
            try {
                wm.destroy();
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "[WebContainer] Context " + wm.getPath() + " threw exception in destroy()", ex);
            }
        }
    }

    private WebModule createAdHocWebModule(VirtualServer vs, String ctxtRoot, String appName) {
        return this.createAdHocWebModule(appName, vs, ctxtRoot, appName);
    }

    private WebModule createAdHocWebModule(String id, VirtualServer vs, String ctxtRoot, String appName) {
        AdHocWebModule wm = new AdHocWebModule();
        wm.setID(id);
        wm.setWebContainer(this);
        wm.restrictedSetPipeline((Pipeline)new WebPipeline((org.apache.catalina.Container)wm));
        wm.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        wm.setContextRoot(ctxtRoot);
        wm.setJ2EEApplication(appName);
        wm.setName(ctxtRoot);
        wm.setDocBase(vs.getAppBase());
        wm.setEngineName(vs.getParent().getName());
        String domain = this._serverContext.getDefaultDomainName();
        wm.setDomain(domain);
        String j2eeServer = this._serverContext.getInstanceName();
        wm.setJ2EEServer(j2eeServer);
        wm.setCrossContext(true);
        vs.addChild((org.apache.catalina.Container)wm);
        return wm;
    }

    void removeDummyModule(VirtualServer vs) {
        WebModule ctx = (WebModule)vs.findChild("");
        if (ctx != null && "__default-web-module".equals(ctx.getModuleName())) {
            this.unloadWebModule("", ctx.getJ2EEApplication(), vs.getName(), true, null);
        }
    }

    private void initInstanceSessionProperties() {
        SessionProperties spBean = this.serverConfigLookup.getInstanceSessionProperties();
        if (spBean == null || spBean.getProperty() == null) {
            return;
        }
        List props = spBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                throw new IllegalArgumentException(rb.getString("webcontainer.nullWebProperty"));
            }
            if (propName.equalsIgnoreCase("enableCookies")) {
                this.instanceEnableCookies = ConfigBeansUtilities.toBoolean((String)propValue);
                continue;
            }
            Object[] params = new Object[]{propName};
            _logger.log(Level.INFO, "webcontainer.notYet", params);
        }
    }

    private static synchronized void setJspFactory() {
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        }
    }

    public void deleteHost(HttpService httpService) throws LifecycleException {
        org.apache.catalina.Container[] virtualServers = this.getEngine().findChildren();
        block2: for (int i = 0; i < virtualServers.length; ++i) {
            for (com.sun.enterprise.config.serverbeans.VirtualServer vse : httpService.getVirtualServer()) {
                if (!virtualServers[i].getName().equals(vse.getId())) continue;
                virtualServers[i] = null;
                continue block2;
            }
        }
        for (org.apache.catalina.Container virtualServer1 : virtualServers) {
            org.apache.catalina.Container[] webModules;
            VirtualServer virtualServer = (VirtualServer)virtualServer1;
            if (virtualServer == null) continue;
            if (virtualServer.getID().equals("__asadmin")) {
                throw new LifecycleException("Cannot delete admin virtual-server.");
            }
            for (org.apache.catalina.Container webModule : webModules = virtualServer.findChildren()) {
                this.unloadWebModule(webModule.getName(), webModule.getName(), virtualServer.getID(), null);
            }
            try {
                virtualServer.destroy();
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error during destruction of virtual server " + virtualServer.getID(), e);
            }
        }
    }

    public void updateHost(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) throws LifecycleException {
        WebModuleConfig wmInfo;
        WebConnector conn;
        Connector[] connectors;
        if ("__asadmin".equals(vsBean.getId())) {
            return;
        }
        VirtualServer vs = (VirtualServer)this.getEngine().findChild(vsBean.getId());
        if (vs == null) {
            _logger.log(Level.WARNING, "Virtual server " + vsBean.getId() + " cannot be updated, because it does not exist");
            return;
        }
        String oldDefaultWebModule = vs.getDefaultWebModuleID();
        vs.setBean(vsBean);
        vs.setLogFile(vsBean.getLogFile(), this.logLevel, this.logHandler);
        vs.configureState();
        vs.clearAliases();
        vs.configureAliases();
        vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        String docroot = vsBean.getPropertyValue("docroot");
        if (docroot == null) {
            docroot = vsBean.getDocroot();
        }
        if (docroot != null) {
            this.updateDocroot(docroot, vs, vsBean);
        }
        List<Property> props = vs.getProperties();
        for (Property prop : props) {
            this.updateHostProperties(vsBean, prop.getName(), prop.getValue(), this.securityService, vs);
        }
        vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory);
        vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        int[] oldPorts = vs.getPorts();
        List listeners = StringUtils.parseStringList((String)vsBean.getNetworkListeners(), (String)",");
        if (listeners != null) {
            HashSet<NetworkListener> networkListeners = new HashSet<NetworkListener>();
            for (String listener : listeners) {
                boolean found = false;
                for (NetworkListener httpListener : this.habitat.getAllByContract(NetworkListener.class)) {
                    if (!httpListener.getName().equals(listener)) continue;
                    networkListeners.add(httpListener);
                    found = true;
                    break;
                }
                if (found) continue;
                _logger.log(Level.SEVERE, "Listener " + listener + " referenced by virtual server " + vs.getName() + " does not exist");
            }
            this.configureHostPortNumbers(vs, networkListeners);
        } else {
            vs.setPorts(new int[0]);
        }
        int[] newPorts = vs.getPorts();
        for (int oldPort : oldPorts) {
            boolean found = false;
            for (int newPort : newPorts) {
                if (oldPort != newPort) continue;
                found = true;
            }
            if (found) continue;
            for (Connector connector : connectors = this._embedded.findConnectors()) {
                conn = (WebConnector)connector;
                if (oldPort != conn.getPort()) continue;
                try {
                    conn.getMapperListener().unregisterHost(vs.getJmxName());
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        for (int newPort : newPorts) {
            boolean found = false;
            for (int oldPort : oldPorts) {
                if (newPort != oldPort) continue;
                found = true;
            }
            if (found) continue;
            for (Connector connector : connectors = this._embedded.findConnectors()) {
                conn = (WebConnector)connector;
                if (newPort != conn.getPort()) continue;
                if (!conn.isAvailable()) {
                    conn.start();
                }
                try {
                    conn.getMapperListener().registerHost(vs.getJmxName());
                }
                catch (Exception e) {
                    throw new LifecycleException((Throwable)e);
                }
            }
        }
        if (oldDefaultWebModule != null) {
            this.updateDefaultWebModule(vs, oldPorts, null);
        }
        if ((wmInfo = vs.getDefaultWebModule(this.domain, (WebArchivist)this.habitat.getComponent(WebArchivist.class), this.appRegistry)) != null && wmInfo.getContextPath() != null && !"".equals(wmInfo.getContextPath()) && !"/".equals(wmInfo.getContextPath())) {
            this.removeDummyModule(vs);
            this.updateDefaultWebModule(vs, vs.getPorts(), wmInfo);
        } else {
            WebModuleConfig wmc = vs.createSystemDefaultWebModuleIfNecessary((WebArchivist)this.habitat.getComponent(WebArchivist.class));
            if (wmc != null) {
                this.loadStandaloneWebModule(vs, wmc);
            }
        }
        Collection httpListeners = this.habitat.getAllByContract(NetworkListener.class);
        if (httpListeners != null) {
            for (NetworkListener httpListener : httpListeners) {
                this.updateConnector(httpListener, (HttpService)this.habitat.getByType(HttpService.class));
            }
        }
    }

    public void updateHostProperties(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String name, String value, SecurityService securityService, VirtualServer vs) {
        if (vs == null) {
            return;
        }
        vs.setBean(vsBean);
        if (name == null) {
            return;
        }
        if (name.startsWith("alternatedocroot_")) {
            this.updateAlternateDocroot(vs);
        } else if ("setCacheControl".equals(name)) {
            vs.configureCacheControl(value);
        } else if ("accessLoggingEnabled".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accesslog".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogWriteInterval".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("accessLogBufferSize".equals(name)) {
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
        } else if ("allowRemoteHost".equals(name) || "denyRemoteHost".equals(name)) {
            vs.configureRemoteHostFilterValve();
        } else if ("allowRemoteAddress".equals(name) || "denyRemoteAddress".equals(name)) {
            vs.configureRemoteAddressFilterValve();
        } else if ("sso-enabled".equals(name)) {
            vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory);
        } else if ("authRealm".equals(name)) {
            vs.configureAuthRealm(securityService);
        } else if (name.startsWith("send-error")) {
            vs.configureErrorPage();
        } else if ("errorReportValve".equals(name)) {
            vs.setErrorReportValveClass(value);
        } else if (name.startsWith("redirect")) {
            vs.configureRedirect();
        } else if (name.startsWith("contextXmlDefault")) {
            vs.setDefaultContextXmlLocation(value);
        }
    }

    public void updateHttpService(HttpService httpService) throws LifecycleException {
        if (httpService == null) {
            return;
        }
        this.globalSSOEnabled = ConfigBeansUtilities.toBoolean((String)httpService.getSsoEnabled());
        this.globalAccessLogWriteInterval = httpService.getAccessLog().getWriteIntervalSeconds();
        this.globalAccessLogBufferSize = httpService.getAccessLog().getBufferSizeBytes();
        this.globalAccessLoggingEnabled = ConfigBeansUtilities.toBoolean((String)httpService.getAccessLoggingEnabled());
        List virtualServers = httpService.getVirtualServer();
        for (com.sun.enterprise.config.serverbeans.VirtualServer virtualServer : virtualServers) {
            VirtualServer vs = (VirtualServer)this.getEngine().findChild(virtualServer.getId());
            if (vs == null) continue;
            vs.configureSingleSignOn(this.globalSSOEnabled, this.webContainerFeatureFactory);
            vs.reconfigureAccessLog(this.globalAccessLogBufferSize, this.globalAccessLogWriteInterval, this.habitat, this.domain, this.globalAccessLoggingEnabled);
            this.updateHost(virtualServer);
        }
        Collection listeners = this.habitat.getAllByContract(NetworkListener.class);
        if (listeners != null) {
            for (NetworkListener httpListener : listeners) {
                this.updateConnector(httpListener, httpService);
            }
        }
    }

    public void updateConnectorProperty(NetworkListener listener, String propName, String propValue) throws LifecycleException {
        WebConnector connector = this.connectorMap.get(listener.getName());
        if (connector != null) {
            connector.configHttpProperties(listener.findProtocol().getHttp(), listener.findTransport(), listener.findProtocol().getSsl());
            connector.configureHttpListenerProperty(propName, propValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnector(NetworkListener networkListener, HttpService httpService) throws LifecycleException {
        Object object = this.mapperUpdateSync;
        synchronized (object) {
            if (networkListener.findProtocol().getHttp().getDefaultVirtualServer().equals("__asadmin") || "http-listener-1".equals(networkListener.getName()) && this.connectorMap.get("admin-listener") == null) {
                return;
            }
            WebConnector connector = this.connectorMap.get(networkListener.getName());
            if (connector != null) {
                this.deleteConnector(connector);
            }
            if (!Boolean.valueOf(networkListener.getEnabled()).booleanValue()) {
                return;
            }
            connector = this.addConnector(networkListener, httpService, false);
            List<VirtualServer> virtualServers = this.getVirtualServersForHttpListenerId(httpService, networkListener.getName());
            if (virtualServers != null) {
                Mapper mapper = connector.getMapper();
                for (VirtualServer vs : virtualServers) {
                    String defaultWebModulePath;
                    boolean found = false;
                    int[] ports = vs.getPorts();
                    for (int i = 0; i < ports.length; ++i) {
                        if (ports[i] != connector.getPort()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        int[] newPorts = new int[ports.length + 1];
                        System.arraycopy(ports, 0, newPorts, 0, ports.length);
                        newPorts[ports.length] = connector.getPort();
                        vs.setPorts(newPorts);
                    }
                    if ((defaultWebModulePath = vs.getDefaultContextPath(this.domain, this.appRegistry)) == null) continue;
                    try {
                        mapper.setDefaultContextPath(vs.getName(), defaultWebModulePath);
                        vs.setDefaultContextPath(defaultWebModulePath);
                    }
                    catch (Exception e) {
                        throw new LifecycleException((Throwable)e);
                    }
                }
            }
            connector.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMapper(HttpService httpService, NetworkListener httpListener, Mapper mapper) {
        Object object = this.mapperUpdateSync;
        synchronized (object) {
            WebConnector connector = this.connectorMap.get(httpListener.getName());
            if (connector != null && connector.getMapper() != mapper) {
                try {
                    this.updateConnector(httpListener, httpService);
                }
                catch (LifecycleException le) {
                    _logger.log(Level.SEVERE, "Exception processing HttpService config change", le);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebConnector addConnector(NetworkListener httpListener, HttpService httpService, boolean start) throws LifecycleException {
        Object object = this.mapperUpdateSync;
        synchronized (object) {
            WebConnector connector;
            int port = Integer.parseInt(httpListener.getPort());
            String virtualServerName = httpListener.findProtocol().getHttp().getDefaultVirtualServer();
            VirtualServer vs = (VirtualServer)this.getEngine().findChild(virtualServerName);
            int[] oldPorts = vs.getPorts();
            int[] newPorts = new int[oldPorts.length + 1];
            System.arraycopy(oldPorts, 0, newPorts, 0, oldPorts.length);
            newPorts[oldPorts.length] = port;
            vs.setPorts(newPorts);
            Mapper mapper = null;
            for (Mapper m : this.habitat.getAllByContract(Mapper.class)) {
                if (m.getPort() != port) continue;
                mapper = m;
                break;
            }
            if ((connector = this.createHttpListener(httpListener, httpService, mapper)).getRedirectPort() == -1) {
                connector.setRedirectPort(this.defaultRedirectPort);
            }
            if (start) {
                connector.start();
            }
            return connector;
        }
    }

    public void deleteConnector(WebConnector connector) throws LifecycleException {
        Connector[] connectors;
        int port = connector.getPort();
        for (Connector connector1 : connectors = this._embedded.findConnectors()) {
            WebConnector conn = (WebConnector)connector1;
            if (port != conn.getPort()) continue;
            this._embedded.removeConnector((Connector)conn);
            this.portMap.remove(connector.getName());
            this.connectorMap.remove(connector.getName());
        }
    }

    public void deleteConnector(NetworkListener httpListener) throws LifecycleException {
        Connector[] connectors = this._embedded.findConnectors();
        int port = Integer.parseInt(httpListener.getPort());
        for (Connector connector : connectors) {
            WebConnector conn = (WebConnector)connector;
            if (port != conn.getPort()) continue;
            this._embedded.removeConnector((Connector)conn);
            this.portMap.remove(httpListener.getName());
            this.connectorMap.remove(httpListener.getName());
        }
    }

    public void updateAccessLog(HttpService httpService) {
        org.apache.catalina.Container[] virtualServers;
        for (org.apache.catalina.Container virtualServer : virtualServers = this.getEngine().findChildren()) {
            ((VirtualServer)virtualServer).reconfigureAccessLog(httpService, this.webContainerFeatureFactory);
        }
    }

    private void updateDocroot(String docroot, VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.validateDocroot(docroot, vsBean.getId(), vsBean.getDefaultWebModule());
        vs.setAppBase(docroot);
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebArchivist)this.habitat.getComponent(WebArchivist.class));
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    private void updateAlternateDocroot(VirtualServer vs) {
        this.removeDummyModule(vs);
        WebModuleConfig wmInfo = vs.createSystemDefaultWebModuleIfNecessary((WebArchivist)this.habitat.getComponent(WebArchivist.class));
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    private void createProbeProviders() {
        this.webModuleProbeProvider = new WebModuleProbeProvider();
        this.servletProbeProvider = new ServletProbeProvider();
        this.jspProbeProvider = new JspProbeProvider();
        this.sessionProbeProvider = new SessionProbeProvider();
        this.requestProbeProvider = new RequestProbeProvider();
    }

    private void createStatsProviders() {
        HttpServiceStatsProviderBootstrap httpStatsBootstrap = (HttpServiceStatsProviderBootstrap)this.habitat.getByType(HttpServiceStatsProviderBootstrap.class);
        WebStatsProviderBootstrap webStatsBootstrap = (WebStatsProviderBootstrap)this.habitat.getByType(WebStatsProviderBootstrap.class);
    }

    public Class loadCommonClass(String className) throws Exception {
        return this.clh.getCommonClassLoader().loadClass(className);
    }

    static {
        useDOLforDeployment = true;
        if (System.getProperty(DOL_DEPLOYMENT) != null) {
            useDOLforDeployment = Boolean.valueOf(System.getProperty(DOL_DEPLOYMENT));
        }
    }
}

