/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.flashlight.statistics.TimeStats;
import org.glassfish.flashlight.statistics.factory.CounterFactory;
import org.glassfish.flashlight.statistics.factory.TimeStatsFactory;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.web.admin.monitor.WebStatsProviderBootstrap;

@ManagedObject
@Description(value="Web Request Statistics")
public class WebRequestStatsProvider {
    private Counter errorCount = CounterFactory.createCount((long[])new long[0]);
    private TimeStats requestProcessTime = TimeStatsFactory.createTimeStatsMilli();
    private Logger logger;
    private String virtualServerName = null;
    private String moduleName = null;

    public WebRequestStatsProvider(String appName, String vsName, Logger logger) {
        this.logger = logger;
        this.virtualServerName = vsName;
        this.moduleName = appName;
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Longest response time for a request; not a cumulative value, but the largest response time from among the response times")
    public TimeStatistic getMaxTime() {
        TimeStatisticImpl maxTime = new TimeStatisticImpl(this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "MaxTime", "milliseconds", "Longest response time for a request; not a cumulative value, but the largest response time from among the response times", this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
        return maxTime;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Cumulative number of requests processed so far")
    public CountStatistic getRequestCount() {
        CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Cumulative number of requests processed so far");
        requestCount.setCount(this.requestProcessTime.getCount());
        return requestCount;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Cumulative value of the times taken to process each request, with processing time being the average of request processing times over the request count")
    public TimeStatistic getProcessingTime() {
        TimeStatisticImpl processingTime = new TimeStatisticImpl((long)this.requestProcessTime.getTime(), this.requestProcessTime.getMaximumTime(), this.requestProcessTime.getMinimumTime(), this.requestProcessTime.getTotalTime(), "ProcessingTime", "milliseconds", "Cumulative value of the times taken to process each request, with processing time being the average of request processing times over the request count ", this.requestProcessTime.getStartTime(), this.requestProcessTime.getLastSampleTime());
        return processingTime;
    }

    @ProbeListener(value="glassfish:web:http-service:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="hostName") String hostName) {
        this.logger.finest("[TM]requestStartEvent Unprocessed received - virtual-server = " + request.getServerName() + ":" + request.getServerPort() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        if (this.virtualServerName != null && this.moduleName != null) {
            String appName;
            String contextPath = request.getContextPath();
            String string = appName = contextPath == null ? null : WebStatsProviderBootstrap.getAppName(contextPath);
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.requestProcessTime.entry();
                this.logger.finest("[TM]requestStartEvent resolved - virtual-server = " + request.getServerName() + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + request.getServletPath() + " : port = " + request.getServerPort());
            }
        } else {
            this.requestProcessTime.entry();
            this.logger.finest("[TM]requestStartEvent resolved - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath());
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="request") HttpServletRequest request, @ProbeParam(value="response") HttpServletResponse response, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="statusCode") int statusCode) {
        this.logger.finest("[TM]requestEndEvent Unprocessed received - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " :Response code = " + statusCode + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        if (this.virtualServerName != null && this.moduleName != null) {
            String appName;
            String contextPath = request.getContextPath();
            String string = appName = contextPath == null ? null : WebStatsProviderBootstrap.getAppName(contextPath);
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.requestProcessTime.exit();
                if (statusCode > 400) {
                    this.errorCount.increment();
                }
                this.logger.finest("[TM]requestEndEvent resolved - virtual-server = " + request.getServerName() + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + request.getServletPath() + " : port = " + request.getServerPort() + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
            }
        } else {
            this.requestProcessTime.exit();
            if (statusCode > 400) {
                this.errorCount.increment();
            }
            this.logger.finest("[TM]requestEndEvent resolved - virtual-server = " + request.getServerName() + ": application = " + request.getContextPath() + " : servlet = " + request.getServletPath() + " : port = " + request.getServerPort() + " :Response code = " + statusCode + " :Response time = " + this.requestProcessTime.getTime());
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.virtualServerName;
    }
}

